/*
 * Decompiled with CFR 0.152.
 */
package ome.system.utests;

import java.util.Properties;
import ome.conditions.ApiUsageException;
import ome.system.Server;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ServerTest {
    @Test(expectedExceptions={ApiUsageException.class})
    public void test_null_host() {
        new Server(null);
    }

    @Test(expectedExceptions={ApiUsageException.class})
    public void test_bad_port() {
        new Server("", -100);
    }

    @Test
    public void test_asProperties() {
        Server s = new Server("a");
        Properties p = s.asProperties();
        Assert.assertNotNull((Object)p.getProperty("server.host"));
        Assert.assertNotNull((Object)p.getProperty("server.port"));
        Assert.assertEquals((String)p.getProperty("server.host"), (String)"a");
        Assert.assertEquals((String)p.getProperty("server.port"), (String)"1099");
    }

    @Test
    public void test_asProperties_ext() {
        Server l = new Server("a", 999);
        Properties p = l.asProperties();
        Assert.assertNotNull((Object)p.getProperty("server.host"));
        Assert.assertNotNull((Object)p.getProperty("server.port"));
        Assert.assertEquals((String)p.getProperty("server.host"), (String)"a");
        Assert.assertEquals((String)p.getProperty("server.port"), (String)"999");
    }

    @Test
    public void test_getters() {
        Server s = new Server("a");
        Assert.assertNotNull((Object)s.getHost());
        Assert.assertEquals((String)s.getHost(), (String)"a");
        Assert.assertEquals((int)s.getPort(), (int)1099);
    }

    @Test
    public void test_getters_ext() {
        Server s = new Server("a", 999);
        Assert.assertNotNull((Object)s.getHost());
        Assert.assertEquals((String)s.getHost(), (String)"a");
        Assert.assertEquals((int)s.getPort(), (int)999);
    }
}

