/*
 * Decompiled with CFR 0.152.
 */
package ome.testing;

import com.jamonapi.MonitorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class Report {
    static int LABEL = 0;
    static int HITS = 1;
    static int AVG = 2;
    static int TOTAL = 3;
    static int STDDEV = 4;
    static int LASTVALUE = 5;
    static int MIN = 6;
    static int MAX = 7;
    static int ACTIVE = 8;
    static int AVGACTIVE = 9;
    static int MAXACTIVE = 10;
    static int FIRSTACCESS = 11;
    static int LASTACCESS = 12;
    String[] header = MonitorFactory.getHeader();
    Object[][] data = MonitorFactory.getData();

    public Report() {
        MonitorFactory.reset();
    }

    public String toString() {
        if (this.header == null) {
            return "====== No report =======";
        }
        int[] labels = new int[]{LABEL, AVG, MIN, MAX, TOTAL, HITS};
        StringBuilder sb = new StringBuilder();
        for (int l : labels) {
            sb.append(this.header[l]);
            for (int i = 0; i < 8 - this.header[l].length(); ++i) {
                sb.append(" ");
            }
            sb.append("\t");
        }
        sb.append("\n");
        HashMap<String, String> ordering = new HashMap<String, String>();
        for (int i = 0; i < this.data.length; ++i) {
            StringBuilder line = new StringBuilder();
            for (int l : labels) {
                Object d = this.data[i][l];
                if (d instanceof Double) {
                    line.append(String.format("%3.2e\t", (Double)d));
                    continue;
                }
                line.append(d + "\t");
            }
            line.append("\n");
            ordering.put((String)this.data[i][LABEL], line.toString());
        }
        ArrayList keys = new ArrayList(ordering.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append((String)ordering.get(key));
        }
        return sb.toString();
    }
}

