/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000BoxType;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.in.JPEG2000MetadataParser;
import loci.formats.meta.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPEG2000Reader
extends FormatReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPEG2000Reader.class);
    private Integer resolutionLevels;
    private int[][] lut;
    private long pixelsOffset;
    private int lastSeries = -1;
    private byte[] lastSeriesPlane;

    public JPEG2000Reader() {
        super("JPEG-2000", new String[]{"jp2", "j2k", "jpf"});
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean validStart;
        int blockLen = 40;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)40, (boolean)false)) {
            return false;
        }
        boolean bl = validStart = (stream.readShort() & 0xFFFF) == 65359;
        if (!validStart) {
            stream.skipBytes(2);
            boolean bl2 = validStart = stream.readInt() == JPEG2000BoxType.SIGNATURE.getCode();
            if (validStart) {
                stream.skipBytes(12);
                validStart = !stream.readString(4).equals("jpx ");
            }
        }
        stream.seek(stream.length() - 2L);
        boolean validEnd = (stream.readShort() & 0xFFFF) == 65497;
        return validStart && validEnd;
    }

    public byte[][] get8BitLookupTable() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.lut == null || FormatTools.getBytesPerPixel((int)this.getPixelType()) != 1) {
            return null;
        }
        byte[][] byteLut = new byte[this.lut.length][this.lut[0].length];
        for (int i = 0; i < this.lut.length; ++i) {
            for (int j = 0; j < this.lut[i].length; ++j) {
                byteLut[i][j] = (byte)(this.lut[i][j] & 0xFF);
            }
        }
        return byteLut;
    }

    public short[][] get16BitLookupTable() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.lut == null || FormatTools.getBytesPerPixel((int)this.getPixelType()) != 2) {
            return null;
        }
        short[][] shortLut = new short[this.lut.length][this.lut[0].length];
        for (int i = 0; i < this.lut.length; ++i) {
            for (int j = 0; j < this.lut[i].length; ++j) {
                shortLut[i][j] = (short)(this.lut[i][j] & 0xFFFF);
            }
        }
        return shortLut;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.resolutionLevels = null;
            this.lut = null;
            this.pixelsOffset = 0L;
            this.lastSeries = -1;
            this.lastSeriesPlane = null;
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.lastSeries == this.getCoreIndex() && this.lastSeriesPlane != null) {
            try (RandomAccessInputStream s = new RandomAccessInputStream(this.lastSeriesPlane);){
                this.readPlane(s, x, y, w, h, buf);
            }
            return buf;
        }
        JPEG2000CodecOptions options = JPEG2000CodecOptions.getDefaultOptions();
        options.interleaved = this.isInterleaved();
        options.littleEndian = this.isLittleEndian();
        if (this.resolutionLevels != null) {
            options.resolution = Math.abs(this.getCoreIndex() - this.resolutionLevels);
        } else if (this.core.size() > 1) {
            options.resolution = this.getCoreIndex();
        }
        this.in.seek(this.pixelsOffset);
        this.lastSeriesPlane = new JPEG2000Codec().decompress(this.in, (CodecOptions)options);
        try (RandomAccessInputStream s = new RandomAccessInputStream(this.lastSeriesPlane);){
            this.readPlane(s, x, y, w, h, buf);
        }
        this.lastSeries = this.getCoreIndex();
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata ms0 = (CoreMetadata)this.core.get(0);
        JPEG2000MetadataParser metadataParser = new JPEG2000MetadataParser(this.in);
        if (metadataParser.isRawCodestream()) {
            LOGGER.info("Codestream is raw, using codestream dimensions.");
            ms0.sizeX = metadataParser.getCodestreamSizeX();
            ms0.sizeY = metadataParser.getCodestreamSizeY();
            ms0.sizeC = metadataParser.getCodestreamSizeC().shortValue();
            ms0.pixelType = metadataParser.getCodestreamPixelType();
        } else {
            LOGGER.info("Codestream is JP2 boxed, using header dimensions.");
            ms0.sizeX = metadataParser.getHeaderSizeX();
            ms0.sizeY = metadataParser.getHeaderSizeY();
            ms0.sizeC = metadataParser.getHeaderSizeC().shortValue();
            ms0.pixelType = metadataParser.getHeaderPixelType();
        }
        this.lut = metadataParser.getLookupTable();
        this.resolutionLevels = metadataParser.getResolutionLevels();
        this.pixelsOffset = metadataParser.getCodestreamOffset();
        ms0.sizeZ = 1;
        ms0.sizeT = 1;
        ms0.imageCount = 1;
        ms0.dimensionOrder = "XYCZT";
        ms0.rgb = this.getSizeC() > 1;
        ms0.interleaved = true;
        ms0.littleEndian = false;
        boolean bl = ms0.indexed = !this.isRGB() && this.lut != null;
        if (this.resolutionLevels != null) {
            int seriesCount;
            ((CoreMetadata)this.core.get((int)0)).resolutionCount = seriesCount = this.resolutionLevels + 1;
            for (i = 1; i < seriesCount; ++i) {
                CoreMetadata ms = new CoreMetadata((IFormatReader)this, 0);
                this.core.add(ms);
                ms.sizeX = Math.max(((CoreMetadata)this.core.get((int)(i - 1))).sizeX / 2, 1);
                ms.sizeY = Math.max(((CoreMetadata)this.core.get((int)(i - 1))).sizeY / 2, 1);
                ms.thumbnail = true;
            }
        }
        ArrayList<String> comments = metadataParser.getComments();
        LOGGER.debug("Found {} comments", (Object)comments.size());
        for (i = 0; i < comments.size(); ++i) {
            String comment = comments.get(i);
            int equal = comment.indexOf(61);
            if (equal >= 0) {
                String key = comment.substring(0, equal);
                String value = comment.substring(equal + 1);
                this.addGlobalMeta(key, value);
                continue;
            }
            this.addGlobalMetaList("Comment", comment);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
    }
}

