/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.facility;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import omero.ServerError;
import omero.api.IMetadataPrx;
import omero.api.IQueryPrx;
import omero.cmd.CmdCallbackI;
import omero.cmd.OriginalMetadataRequest;
import omero.cmd.OriginalMetadataResponse;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.facility.BrowseFacility;
import omero.gateway.facility.Facility;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ChannelData;
import omero.gateway.model.DataObject;
import omero.gateway.model.FilesetData;
import omero.gateway.model.ImageAcquisitionData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PixelsData;
import omero.gateway.model.PlaneInfoData;
import omero.gateway.util.OriginalMetadataParser;
import omero.gateway.util.PojoMapper;
import omero.gateway.util.Pojos;
import omero.model.Channel;
import omero.model.FilesetI;
import omero.model.IObject;
import omero.model.Pixels;
import omero.model.PlaneInfo;
import omero.sys.ParametersI;
import org.apache.commons.collections.CollectionUtils;

public class MetadataFacility
extends Facility {
    private BrowseFacility browse;

    MetadataFacility(Gateway gateway) throws ExecutionException {
        super(gateway);
        this.browse = gateway.getFacility(BrowseFacility.class);
    }

    public ImageAcquisitionData getImageAcquisitionData(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        if (imageId < 0L) {
            return null;
        }
        ParametersI params = new ParametersI();
        params.acquisitionData();
        ImageData img = this.browse.getImage(ctx, imageId, params);
        return new ImageAcquisitionData(img.asImage());
    }

    public List<ChannelData> getChannelData(SecurityContext ctx, long imageId) throws DSOutOfServiceException, DSAccessException {
        ArrayList<ChannelData> result = new ArrayList<ChannelData>();
        if (imageId < 0L) {
            return result;
        }
        try {
            ImageData img = this.browse.getImage(ctx, imageId);
            long pixelsId = img.getDefaultPixels().getId();
            Pixels pixels = this.gateway.getPixelsService(ctx).retrievePixDescription(pixelsId);
            List<Channel> l = pixels.copyChannels();
            for (int i = 0; i < l.size(); ++i) {
                result.add(new ChannelData(i, l.get(i)));
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot load channel data.");
        }
        return result;
    }

    public List<AnnotationData> getAnnotations(SecurityContext ctx, DataObject object) throws DSOutOfServiceException, DSAccessException {
        return this.getAnnotations(ctx, object, null, null);
    }

    public List<AnnotationData> getAnnotations(SecurityContext ctx, DataObject object, List<Class<? extends AnnotationData>> annotationTypes, List<Long> userIds) throws DSOutOfServiceException, DSAccessException {
        if (!Pojos.hasID(object)) {
            return Collections.emptyList();
        }
        Map<DataObject, List<AnnotationData>> result = this.getAnnotations(ctx, Arrays.asList(object), annotationTypes, userIds);
        return result.get(object);
    }

    /*
     * WARNING - void declaration
     */
    public Map<DataObject, List<AnnotationData>> getAnnotations(SecurityContext ctx, List<? extends DataObject> objects, List<Class<? extends AnnotationData>> annotationTypes, List<Long> userIds) throws DSOutOfServiceException, DSAccessException {
        HashMap<DataObject, List<AnnotationData>> result = new HashMap<DataObject, List<AnnotationData>>();
        if (CollectionUtils.isEmpty(objects)) {
            return result;
        }
        String type = null;
        ArrayList<Long> ids = new ArrayList<Long>();
        for (DataObject dataObject : objects) {
            if (type == null) {
                type = PojoMapper.getModelType(dataObject.getClass()).getName();
            } else if (!type.equals(PojoMapper.getModelType(dataObject.getClass()).getName())) {
                throw new IllegalArgumentException("All objects have to be the same type");
            }
            ids.add(dataObject.getId());
        }
        try {
            void var9_13;
            IMetadataPrx proxy = this.gateway.getMetadataService(ctx);
            Object var9_11 = null;
            if (annotationTypes != null) {
                ArrayList<String> arrayList = new ArrayList<String>(annotationTypes.size());
                for (Class<? extends AnnotationData> c : annotationTypes) {
                    arrayList.add(PojoMapper.getModelType(c).getName());
                }
            }
            Map<Long, List<IObject>> annos = proxy.loadAnnotations(type, ids, (List<String>)var9_13, userIds, null);
            for (Map.Entry<Long, List<IObject>> e : annos.entrySet()) {
                long id = e.getKey();
                DataObject dobj = null;
                for (DataObject dataObject : objects) {
                    if (dataObject.getId() != id) continue;
                    dobj = dataObject;
                    break;
                }
                ArrayList<AnnotationData> list = new ArrayList<AnnotationData>();
                for (IObject a : e.getValue()) {
                    list.add((AnnotationData)PojoMapper.asDataObject(a));
                }
                result.put(dobj, list);
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Cannot get annotations.");
        }
        return result;
    }

    public List<String> getManagedRepositoriesPaths(SecurityContext ctx, ImageData img) throws DSOutOfServiceException, DSAccessException {
        try {
            FilesetData fs = this.loadFileset(ctx, img);
            if (fs != null) {
                return fs.getAbsolutePaths();
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not get the file paths.");
        }
        return Collections.emptyList();
    }

    public List<String> getOriginalPaths(SecurityContext ctx, ImageData img) throws DSOutOfServiceException, DSAccessException {
        try {
            FilesetData fs = this.loadFileset(ctx, img);
            if (fs != null) {
                return fs.getUsedFilePaths();
            }
        }
        catch (Throwable t) {
            this.handleException(this, t, "Could not get the file paths.");
        }
        return Collections.emptyList();
    }

    public List<PlaneInfoData> getPlaneInfos(SecurityContext ctx, PixelsData pix) throws DSOutOfServiceException, DSAccessException {
        ArrayList<PlaneInfoData> result = new ArrayList<PlaneInfoData>();
        try {
            ParametersI p = new ParametersI();
            p.addLong("id", pix.getId());
            List<IObject> planeinfos = this.gateway.getQueryService(ctx).findAllByQuery("select info from PlaneInfo as info join fetch info.deltaT as dt join fetch info.exposureTime as et where info.pixels.id = :id", p);
            for (IObject obj : planeinfos) {
                result.add(new PlaneInfoData((PlaneInfo)obj));
            }
        }
        catch (Throwable th) {
            this.handleException(this, th, "Could not get the planeinfos.");
        }
        return result;
    }

    private FilesetData loadFileset(SecurityContext ctx, ImageData img) throws ServerError, DSOutOfServiceException {
        String query = "select fs from Fileset as fs join fetch fs.images as image left outer join fetch fs.usedFiles as usedFile join fetch usedFile.originalFile as f join fetch f.hasher where image.id = :id";
        IQueryPrx service = this.gateway.getQueryService(ctx);
        ParametersI param = new ParametersI();
        param.addId(img.getId());
        FilesetI fs = (FilesetI)service.findByQuery(query, param);
        if (fs != null) {
            return new FilesetData(fs);
        }
        return null;
    }

    private OriginalMetadataResponse requestOriginalMetadata(SecurityContext ctx, long imageId) {
        OriginalMetadataRequest cmd = new OriginalMetadataRequest();
        cmd.imageId = imageId;
        try {
            CmdCallbackI cb = this.gateway.submit(ctx, cmd);
            if (cb.block(10000L)) {
                return (OriginalMetadataResponse)cb.getResponse();
            }
            this.logError(this, "Could not request original metadata", null);
        }
        catch (Throwable t) {
            this.logError(this, "Could not request original metadata", t);
        }
        return null;
    }

    public void getOriginalMetadata(SecurityContext ctx, long imageId, File output) throws Exception {
        if (output == null) {
            return;
        }
        OriginalMetadataResponse response = this.requestOriginalMetadata(ctx, imageId);
        if (response != null) {
            new OriginalMetadataParser(output).read(response);
        }
    }

    public void getOriginalMetadata(SecurityContext ctx, long imageId, StringBuffer buffer) {
        if (buffer == null) {
            return;
        }
        OriginalMetadataResponse response = this.requestOriginalMetadata(ctx, imageId);
        if (response != null) {
            try {
                new OriginalMetadataParser(buffer).read(response);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

