/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.fire;

import Glacier2.SessionManagerPrx;
import Glacier2.SessionManagerPrxHelper;
import Glacier2.SessionPrx;
import Ice.Communicator;
import Ice.Identity;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectPrx;
import Ice.Util;
import IceGrid.AdminPrx;
import IceGrid.AdminSessionPrx;
import IceGrid.ObjectExistsException;
import IceGrid.ObjectNotRegisteredException;
import IceGrid.PermissionDeniedException;
import IceGrid.QueryPrx;
import IceGrid.QueryPrxHelper;
import IceGrid.RegistryPrx;
import IceGrid.RegistryPrxHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import omero.api.ServiceFactoryPrx;
import omero.api.ServiceFactoryPrxHelper;
import omero.grid.ClusterNodePrx;
import omero.grid.ClusterNodePrxHelper;
import omero.grid.InternalRepositoryPrx;
import omero.grid.InternalRepositoryPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid.ProcessorPrxHelper;
import omero.grid.TablesPrx;
import omero.grid.TablesPrxHelper;
import omero.grid._ClusterNodeDisp;
import omero.grid._InternalRepositoryDisp;
import omero.grid._ProcessorDisp;
import omero.grid._TablesDisp;
import omero.grid.monitors.MonitorServerPrx;
import omero.grid.monitors.MonitorServerPrxHelper;
import omero.grid.monitors._MonitorServerDisp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Registry {
    public ServiceFactoryPrx getInternalServiceFactory(String var1, Long var2, int var3, int var4, String var5) throws Exception;

    public QueryPrx getGridQuery();

    public AdminSessionPrx getAdminSession() throws PermissionDeniedException;

    public void addObject(ObjectPrx var1) throws Exception;

    public void removeObject(Identity var1) throws Exception;

    public boolean removeObjectSafely(Identity var1);

    public ClusterNodePrx[] lookupClusterNodes();

    public ProcessorPrx[] lookupProcessors();

    public InternalRepositoryPrx[] lookupRepositories();

    public TablesPrx[] lookupTables();

    public MonitorServerPrx[] lookupMonitorServers();

    public static class Impl
    implements Registry {
        private static final Logger log = LoggerFactory.getLogger(Registry.class);
        private final Communicator ic;

        public Impl(Communicator ic) {
            this.ic = ic;
        }

        @Override
        public ServiceFactoryPrx getInternalServiceFactory(String user, Long groupId, int retries, int interval, String client_uuid) throws Exception {
            int tryCount = 0;
            Throwable excpt = null;
            ObjectPrx prx = this.ic.stringToProxy("IceGrid/Query");
            QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)prx);
            if (client_uuid == null || client_uuid.isEmpty()) {
                client_uuid = UUID.randomUUID().toString();
            }
            while (tryCount < retries) {
                try {
                    HashMap<String, String> ctx = new HashMap<String, String>();
                    ctx.put("omero.client.uuid", client_uuid);
                    if (groupId != null) {
                        ctx.put("omero.group", Long.toString(groupId));
                    }
                    prx = query.findAllObjectsByType("::Glacier2::SessionManager")[0];
                    SessionManagerPrx blitz = SessionManagerPrxHelper.checkedCast((ObjectPrx)prx);
                    SessionPrx sf = blitz.create(user, null, ctx);
                    return ServiceFactoryPrxHelper.checkedCast((ObjectPrx)sf);
                }
                catch (ObjectAdapterDeactivatedException oade) {
                    excpt = oade;
                }
                catch (Exception e) {
                    log.info("Failed to get session on attempt " + tryCount);
                    ++tryCount;
                    excpt = e;
                }
                ++tryCount;
                try {
                    Thread.sleep(interval * 1000);
                }
                catch (InterruptedException interruptedException) {}
            }
            log.warn("Failed to get internal service factory", excpt);
            throw excpt;
        }

        @Override
        public QueryPrx getGridQuery() {
            try {
                ObjectPrx objectPrx = this.ic.stringToProxy("IceGrid/Query");
                QueryPrx query = QueryPrxHelper.checkedCast((ObjectPrx)objectPrx);
                return query;
            }
            catch (Exception e) {
                log.warn("Could not find IceGrid/Query: " + e);
                return null;
            }
        }

        @Override
        public AdminSessionPrx getAdminSession() throws PermissionDeniedException {
            ObjectPrx objectPrx = this.ic.stringToProxy("IceGrid/Registry");
            RegistryPrx reg = RegistryPrxHelper.checkedCast((ObjectPrx)objectPrx);
            AdminSessionPrx session = reg.createAdminSession("null", "");
            return session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addObject(ObjectPrx obj) throws Exception {
            AdminSessionPrx session = this.getAdminSession();
            AdminPrx admin = session.getAdmin();
            String str = this.ic.identityToString(obj.ice_getIdentity());
            try {
                admin.addObject(obj);
                log.info("Added " + str + " to registry");
            }
            catch (ObjectExistsException e) {
                admin.updateObject(obj);
                log.info("Updated " + str + " in registry");
            }
            finally {
                session.destroy();
            }
        }

        @Override
        public void removeObject(Identity id) throws Exception {
            AdminSessionPrx session = this.getAdminSession();
            try {
                session.getAdmin().removeObject(id);
                log.info("Removed " + this.ic.identityToString(id) + " from registry");
            }
            finally {
                session.destroy();
            }
        }

        @Override
        public boolean removeObjectSafely(Identity id) {
            try {
                this.removeObject(id);
                return true;
            }
            catch (ObjectNotRegisteredException onre) {
                log.debug(Util.identityToString((Identity)id) + " not registered");
            }
            catch (Exception e) {
                log.error("Failed to remove registry object " + Util.identityToString((Identity)id), (Throwable)e);
            }
            return false;
        }

        @Override
        public ClusterNodePrx[] lookupClusterNodes() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_ClusterNodeDisp.ice_staticId());
                Object[] nodes = new ClusterNodePrx[candidates.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = ClusterNodePrxHelper.uncheckedCast(candidates[i]);
                }
                log.info("Found " + nodes.length + " cluster node(s) : " + Arrays.toString(nodes));
                return nodes;
            }
            catch (Exception e) {
                log.warn("Could not query cluster nodes " + e);
                return null;
            }
        }

        @Override
        public ProcessorPrx[] lookupProcessors() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_ProcessorDisp.ice_staticId());
                Object[] procs = new ProcessorPrx[candidates.length];
                for (int i = 0; i < procs.length; ++i) {
                    procs[i] = ProcessorPrxHelper.uncheckedCast(candidates[i]);
                }
                log.info("Found " + procs.length + " processor(s) : " + Arrays.toString(procs));
                return procs;
            }
            catch (Exception e) {
                log.warn("Could not query processors " + e);
                return null;
            }
        }

        @Override
        public TablesPrx[] lookupTables() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_TablesDisp.ice_staticId());
                Object[] tables = new TablesPrx[candidates.length];
                for (int i = 0; i < tables.length; ++i) {
                    tables[i] = TablesPrxHelper.uncheckedCast(candidates[i]);
                }
                log.info("Found " + tables.length + " table services(s) : " + Arrays.toString(tables));
                return tables;
            }
            catch (Exception e) {
                log.warn("Could not query tables " + e);
                return null;
            }
        }

        @Override
        public InternalRepositoryPrx[] lookupRepositories() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_InternalRepositoryDisp.ice_staticId());
                Object[] repos = new InternalRepositoryPrx[candidates.length];
                for (int i = 0; i < repos.length; ++i) {
                    repos[i] = InternalRepositoryPrxHelper.uncheckedCast(candidates[i]);
                }
                log.info("Found " + repos.length + " repo(s) : " + Arrays.toString(repos));
                return repos;
            }
            catch (Exception e) {
                log.warn("Could not query repositories " + e);
                return null;
            }
        }

        @Override
        public MonitorServerPrx[] lookupMonitorServers() {
            QueryPrx query = this.getGridQuery();
            if (query == null) {
                return null;
            }
            try {
                ObjectPrx[] candidates = null;
                candidates = query.findAllObjectsByType(_MonitorServerDisp.ice_staticId());
                Object[] mss = new MonitorServerPrx[candidates.length];
                for (int i = 0; i < mss.length; ++i) {
                    mss[i] = MonitorServerPrxHelper.uncheckedCast(candidates[i]);
                }
                log.info("Found " + mss.length + " monitor server(s) : " + Arrays.toString(mss));
                return mss;
            }
            catch (Exception e) {
                log.warn("Could not query repositories " + e);
                return null;
            }
        }
    }
}

