/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.display.Thumbnail;
import ome.model.internal.Details;
import ome.services.delete.Deletion;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphTraversal;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGraphTraversalProcessor
implements GraphTraversal.Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseGraphTraversalProcessor.class);
    private static final Collection<String> DELETION_CLASS_NAMES = ImmutableSet.of((Object)OriginalFile.class.getName(), (Object)Pixels.class.getName(), (Object)Thumbnail.class.getName());
    protected final Session session;
    private final List<Map.Entry<String, Collection<Long>>> deletionLog = new ArrayList<Map.Entry<String, Collection<Long>>>();

    public BaseGraphTraversalProcessor(Session session) {
        this.session = session;
    }

    @Override
    public void nullProperties(String className, String propertyName, Collection<Long> ids) {
        String update = "UPDATE " + className + " SET " + propertyName + " = NULL WHERE id IN (:ids)";
        this.session.createQuery(update).setParameterList("ids", ids).executeUpdate();
    }

    @Override
    public void deleteInstances(String className, Collection<Long> ids) throws GraphException {
        String update = "DELETE FROM " + className + " WHERE id IN (:ids)";
        int count = this.session.createQuery(update).setParameterList("ids", ids).executeUpdate();
        if (count != ids.size()) {
            LOGGER.warn("not all the objects of type " + className + " could be deleted");
        }
        if (DELETION_CLASS_NAMES.contains(className)) {
            this.deletionLog.add(new AbstractMap.SimpleImmutableEntry<String, Collection<Long>>(className.substring(className.lastIndexOf(46) + 1), ids));
        }
    }

    public void deleteFiles(Deletion deletionInstance) {
        for (Map.Entry<String, Collection<Long>> deletionBatch : this.deletionLog) {
            deletionInstance.deleteFiles((SetMultimap<String, Long>)ImmutableSetMultimap.builder().putAll((Object)deletionBatch.getKey(), (Iterable)deletionBatch.getValue()).build());
        }
        this.deletionLog.clear();
    }

    @Override
    public void assertMayProcess(String className, long id, Details details) throws GraphException {
    }
}

