/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ApiUsageException;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.RString;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.Folder;
import omero.model.FolderAnnotationLink;
import omero.model.FolderAnnotationLinkI;
import omero.model.FolderImageLink;
import omero.model.FolderImageLinkI;
import omero.model.FolderRoiLink;
import omero.model.FolderRoiLinkI;
import omero.model.IObject;
import omero.model.Image;
import omero.model.Roi;
import omero.rtypes;
import omero.util.IceMapper;

public class FolderI
extends Folder
implements ModelBased {
    public static final String CHILDFOLDERS = "ome.model.containers.Folder_childFolders";
    public static final String PARENTFOLDER = "ome.model.containers.Folder_parentFolder";
    public static final String IMAGELINKS = "ome.model.containers.Folder_imageLinks";
    public static final String ROILINKS = "ome.model.containers.Folder_roiLinks";
    public static final String ANNOTATIONLINKS = "ome.model.containers.Folder_annotationLinks";
    public static final String NAME = "ome.model.containers.Folder_name";
    public static final String DESCRIPTION = "ome.model.containers.Folder_description";
    public static final String DETAILS = "ome.model.containers.Folder_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
        if (load) {
            this.childFoldersSeq = new ArrayList();
            this.childFoldersLoaded = true;
        } else {
            this.childFoldersSeq = null;
            this.childFoldersLoaded = false;
        }
        if (load) {
            this.imageLinksSeq = new ArrayList();
            this.imageLinksLoaded = true;
        } else {
            this.imageLinksSeq = null;
            this.imageLinksLoaded = false;
        }
        if (load) {
            this.roiLinksSeq = new ArrayList();
            this.roiLinksLoaded = true;
        } else {
            this.roiLinksSeq = null;
            this.roiLinksLoaded = false;
        }
        if (load) {
            this.annotationLinksSeq = new ArrayList();
            this.annotationLinksLoaded = true;
        } else {
            this.annotationLinksSeq = null;
            this.annotationLinksLoaded = false;
        }
    }

    public FolderI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public FolderI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public FolderI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadChildFolders();
        this.unloadParentFolder();
        this.unloadImageLinks();
        this.unloadRoiLinks();
        this.unloadAnnotationLinks();
        this.unloadName();
        this.unloadDescription();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return true;
    }

    @Override
    public boolean isLink(Current current) {
        return false;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        FolderI copy = new FolderI();
        copy.id = this.id;
        copy.version = this.version;
        if (!this.childFoldersLoaded) {
            copy.childFoldersLoaded = false;
            copy.childFoldersSeq = null;
        } else {
            copy.childFoldersLoaded = true;
            copy.childFoldersSeq = new ArrayList<Folder>();
            for (IObject item : this.childFoldersSeq) {
                copy.childFoldersSeq.add(item == null ? null : (Folder)item.proxy());
            }
        }
        Folder folder = copy.parentFolder = this.parentFolder == null ? null : (Folder)this.parentFolder.proxy();
        if (!this.imageLinksLoaded) {
            copy.imageLinksLoaded = false;
            copy.imageLinksSeq = null;
        } else {
            copy.imageLinksLoaded = true;
            copy.imageLinksSeq = new ArrayList<FolderImageLink>();
            for (IObject item : this.imageLinksSeq) {
                copy.imageLinksSeq.add(item == null ? null : (FolderImageLink)item.proxy());
            }
        }
        if (!this.roiLinksLoaded) {
            copy.roiLinksLoaded = false;
            copy.roiLinksSeq = null;
        } else {
            copy.roiLinksLoaded = true;
            copy.roiLinksSeq = new ArrayList<FolderRoiLink>();
            for (IObject item : this.roiLinksSeq) {
                copy.roiLinksSeq.add(item == null ? null : (FolderRoiLink)item.proxy());
            }
        }
        if (!this.annotationLinksLoaded) {
            copy.annotationLinksLoaded = false;
            copy.annotationLinksSeq = null;
        } else {
            copy.annotationLinksLoaded = true;
            copy.annotationLinksSeq = new ArrayList<FolderAnnotationLink>();
            for (IObject item : this.annotationLinksSeq) {
                copy.annotationLinksSeq.add(item == null ? null : (FolderAnnotationLink)item.proxy());
            }
        }
        copy.name = this.name;
        copy.description = this.description;
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new FolderI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    @Override
    public void unloadChildFolders(Current current) {
        this.childFoldersLoaded = false;
        this.childFoldersSeq = null;
    }

    protected List getChildFolders(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.childFoldersSeq;
    }

    protected void setChildFolders(List childFolders, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.childFoldersSeq = childFolders == null ? new ArrayList() : new ArrayList(childFolders);
        this.childFoldersLoaded = childFolders != null;
    }

    private void copyChildFolders(ome.model.containers.Folder source, IceMapper mapper) {
        this.setChildFolders((List)mapper.findCollection((Collection)source.retrieve(CHILDFOLDERS)), null);
    }

    private void fillChildFolders(ome.model.containers.Folder target, IceMapper mapper) {
        if (this.childFoldersLoaded) {
            target.putAt(CHILDFOLDERS, (Object)mapper.reverse(this.childFoldersSeq, Set.class));
        } else {
            target.putAt(CHILDFOLDERS, null);
        }
    }

    public boolean isChildFoldersLoaded() {
        return this.childFoldersLoaded;
    }

    @Override
    public int sizeOfChildFolders(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            return -1;
        }
        return this.childFoldersSeq.size();
    }

    public List copyChildFolders(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            this.throwNullCollectionException("childFoldersSeq");
        }
        ArrayList result = new ArrayList(this.childFoldersSeq);
        return result;
    }

    public Iterator iterateChildFolders() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            this.throwNullCollectionException("childFoldersSeq");
        }
        return this.childFoldersSeq.iterator();
    }

    @Override
    public void addChildFolders(Folder target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            this.throwNullCollectionException("childFoldersSeq");
        }
        this.childFoldersSeq.add(target);
        target.setParentFolder(this);
    }

    @Override
    public void addAllChildFoldersSet(List<Folder> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            this.throwNullCollectionException("childFoldersSeq");
        }
        this.childFoldersSeq.addAll(targets);
        for (Folder target : targets) {
            target.setParentFolder(this);
        }
    }

    @Override
    public void removeChildFolders(Folder target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            this.throwNullCollectionException("childFoldersSeq");
        }
        this.childFoldersSeq.remove(target);
        target.setParentFolder(null);
    }

    @Override
    public void removeAllChildFoldersSet(List<Folder> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            this.throwNullCollectionException("childFoldersSeq");
        }
        for (Folder elt : targets) {
            elt.setParentFolder(null);
            this.childFoldersSeq.remove(elt);
        }
    }

    @Override
    public void clearChildFolders(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.childFoldersLoaded) {
            this.throwNullCollectionException("childFoldersSeq");
        }
        for (Folder elt : this.childFoldersSeq) {
            elt.setParentFolder(null);
        }
        this.childFoldersSeq.clear();
    }

    @Override
    public void reloadChildFolders(Folder toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.childFoldersLoaded) {
            throw new ClientError("Cannot reload active collection: childFoldersSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<Folder> copy = toCopy.copyChildFolders();
        for (Folder elt : copy) {
            elt.setParentFolder(this);
        }
        this.childFoldersSeq = new ArrayList<Folder>(copy);
        toCopy.unloadChildFolders();
        this.childFoldersLoaded = true;
    }

    public void unloadParentFolder() {
        this.parentFolder = null;
    }

    @Override
    public Folder getParentFolder(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.parentFolder;
    }

    @Override
    public void setParentFolder(Folder parentFolder, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.parentFolder = parentFolder;
    }

    private void copyParentFolder(ome.model.containers.Folder source, IceMapper mapper) {
        this.parentFolder = (Folder)mapper.findTarget(source.getParentFolder());
    }

    private void fillParentFolder(ome.model.containers.Folder target, IceMapper mapper) {
        target.putAt(PARENTFOLDER, (Object)mapper.reverse((ModelBased)this.getParentFolder()));
    }

    @Override
    public void unloadImageLinks(Current current) {
        this.imageLinksLoaded = false;
        this.imageLinksSeq = null;
    }

    protected List getImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.imageLinksSeq;
    }

    protected void setImageLinks(List imageLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.imageLinksSeq = imageLinks == null ? new ArrayList() : new ArrayList(imageLinks);
        this.imageLinksLoaded = imageLinks != null;
    }

    private void copyImageLinks(ome.model.containers.Folder source, IceMapper mapper) {
        this.setImageLinks((List)mapper.findCollection((Collection)source.retrieve(IMAGELINKS)), null);
        this.imageLinksCountPerOwner = source.getImageLinksCountPerOwner();
    }

    private void fillImageLinks(ome.model.containers.Folder target, IceMapper mapper) {
        if (this.imageLinksLoaded) {
            target.putAt(IMAGELINKS, (Object)mapper.reverse(this.imageLinksSeq, Set.class));
        } else {
            target.putAt(IMAGELINKS, null);
        }
    }

    public boolean isImageLinksLoaded() {
        return this.imageLinksLoaded;
    }

    @Override
    public int sizeOfImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            return -1;
        }
        return this.imageLinksSeq.size();
    }

    public List copyImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        ArrayList result = new ArrayList(this.imageLinksSeq);
        return result;
    }

    public Iterator iterateImageLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        return this.imageLinksSeq.iterator();
    }

    @Override
    public void addFolderImageLink(FolderImageLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllFolderImageLinkSet(List<FolderImageLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.addAll(targets);
        for (FolderImageLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeFolderImageLink(FolderImageLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllFolderImageLinkSet(List<FolderImageLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        for (FolderImageLink elt : targets) {
            elt.setParent(null);
            this.imageLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearImageLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        for (FolderImageLink elt : this.imageLinksSeq) {
            elt.setParent(null);
        }
        this.imageLinksSeq.clear();
    }

    @Override
    public void reloadImageLinks(Folder toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.imageLinksLoaded) {
            throw new ClientError("Cannot reload active collection: imageLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FolderImageLink> copy = toCopy.copyImageLinks();
        for (FolderImageLink elt : copy) {
            elt.setParent(this);
        }
        this.imageLinksSeq = new ArrayList<FolderImageLink>(copy);
        toCopy.unloadImageLinks();
        this.imageLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getImageLinksCountPerOwner(Current current) {
        return this.imageLinksCountPerOwner;
    }

    @Override
    public FolderImageLink linkImage(Image addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        FolderImageLinkI link = new FolderImageLinkI();
        link.link(this, addition);
        this.addFolderImageLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addFolderImageLinkToBoth(FolderImageLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.add(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().addFolderImageLinkToBoth(link, false);
        }
    }

    @Override
    public List<FolderImageLink> findFolderImageLink(Image removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        ArrayList<FolderImageLink> result = new ArrayList<FolderImageLink>();
        for (FolderImageLink link : this.imageLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkImage(Image removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        List<FolderImageLink> toRemove = this.findFolderImageLink(removal);
        Iterator<FolderImageLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFolderImageLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeFolderImageLinkFromBoth(FolderImageLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("imageLinksSeq");
        }
        this.imageLinksSeq.remove(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().removeFolderImageLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Image> linkedImageList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.imageLinksLoaded) {
            this.throwNullCollectionException("ImageLinks");
        }
        ArrayList<Image> linked = new ArrayList<Image>();
        for (FolderImageLink link : this.imageLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void unloadRoiLinks(Current current) {
        this.roiLinksLoaded = false;
        this.roiLinksSeq = null;
    }

    protected List getRoiLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.roiLinksSeq;
    }

    protected void setRoiLinks(List roiLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.roiLinksSeq = roiLinks == null ? new ArrayList() : new ArrayList(roiLinks);
        this.roiLinksLoaded = roiLinks != null;
    }

    private void copyRoiLinks(ome.model.containers.Folder source, IceMapper mapper) {
        this.setRoiLinks((List)mapper.findCollection((Collection)source.retrieve(ROILINKS)), null);
        this.roiLinksCountPerOwner = source.getRoiLinksCountPerOwner();
    }

    private void fillRoiLinks(ome.model.containers.Folder target, IceMapper mapper) {
        if (this.roiLinksLoaded) {
            target.putAt(ROILINKS, (Object)mapper.reverse(this.roiLinksSeq, Set.class));
        } else {
            target.putAt(ROILINKS, null);
        }
    }

    public boolean isRoiLinksLoaded() {
        return this.roiLinksLoaded;
    }

    @Override
    public int sizeOfRoiLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            return -1;
        }
        return this.roiLinksSeq.size();
    }

    public List copyRoiLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        ArrayList result = new ArrayList(this.roiLinksSeq);
        return result;
    }

    public Iterator iterateRoiLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        return this.roiLinksSeq.iterator();
    }

    @Override
    public void addFolderRoiLink(FolderRoiLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        this.roiLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllFolderRoiLinkSet(List<FolderRoiLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        this.roiLinksSeq.addAll(targets);
        for (FolderRoiLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeFolderRoiLink(FolderRoiLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        this.roiLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllFolderRoiLinkSet(List<FolderRoiLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        for (FolderRoiLink elt : targets) {
            elt.setParent(null);
            this.roiLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearRoiLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        for (FolderRoiLink elt : this.roiLinksSeq) {
            elt.setParent(null);
        }
        this.roiLinksSeq.clear();
    }

    @Override
    public void reloadRoiLinks(Folder toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.roiLinksLoaded) {
            throw new ClientError("Cannot reload active collection: roiLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FolderRoiLink> copy = toCopy.copyRoiLinks();
        for (FolderRoiLink elt : copy) {
            elt.setParent(this);
        }
        this.roiLinksSeq = new ArrayList<FolderRoiLink>(copy);
        toCopy.unloadRoiLinks();
        this.roiLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getRoiLinksCountPerOwner(Current current) {
        return this.roiLinksCountPerOwner;
    }

    @Override
    public FolderRoiLink linkRoi(Roi addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        FolderRoiLinkI link = new FolderRoiLinkI();
        link.link(this, addition);
        this.addFolderRoiLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addFolderRoiLinkToBoth(FolderRoiLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        this.roiLinksSeq.add(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().addFolderRoiLinkToBoth(link, false);
        }
    }

    @Override
    public List<FolderRoiLink> findFolderRoiLink(Roi removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        ArrayList<FolderRoiLink> result = new ArrayList<FolderRoiLink>();
        for (FolderRoiLink link : this.roiLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkRoi(Roi removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        List<FolderRoiLink> toRemove = this.findFolderRoiLink(removal);
        Iterator<FolderRoiLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFolderRoiLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeFolderRoiLinkFromBoth(FolderRoiLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("roiLinksSeq");
        }
        this.roiLinksSeq.remove(link);
        if (bothSides && link.getChild().isLoaded()) {
            link.getChild().removeFolderRoiLinkFromBoth(link, false);
        }
    }

    @Override
    public List<Roi> linkedRoiList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.roiLinksLoaded) {
            this.throwNullCollectionException("RoiLinks");
        }
        ArrayList<Roi> linked = new ArrayList<Roi>();
        for (FolderRoiLink link : this.roiLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    @Override
    public void unloadAnnotationLinks(Current current) {
        this.annotationLinksLoaded = false;
        this.annotationLinksSeq = null;
    }

    protected List getAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.annotationLinksSeq;
    }

    protected void setAnnotationLinks(List annotationLinks, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.annotationLinksSeq = annotationLinks == null ? new ArrayList() : new ArrayList(annotationLinks);
        this.annotationLinksLoaded = annotationLinks != null;
    }

    private void copyAnnotationLinks(ome.model.containers.Folder source, IceMapper mapper) {
        this.setAnnotationLinks((List)mapper.findCollection((Collection)source.retrieve(ANNOTATIONLINKS)), null);
        this.annotationLinksCountPerOwner = source.getAnnotationLinksCountPerOwner();
    }

    private void fillAnnotationLinks(ome.model.containers.Folder target, IceMapper mapper) {
        if (this.annotationLinksLoaded) {
            target.putAt(ANNOTATIONLINKS, (Object)mapper.reverse(this.annotationLinksSeq, Set.class));
        } else {
            target.putAt(ANNOTATIONLINKS, null);
        }
    }

    public boolean isAnnotationLinksLoaded() {
        return this.annotationLinksLoaded;
    }

    @Override
    public int sizeOfAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            return -1;
        }
        return this.annotationLinksSeq.size();
    }

    public List copyAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList result = new ArrayList(this.annotationLinksSeq);
        return result;
    }

    public Iterator iterateAnnotationLinks() throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        return this.annotationLinksSeq.iterator();
    }

    @Override
    public void addFolderAnnotationLink(FolderAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(target);
        target.setParent(this);
    }

    @Override
    public void addAllFolderAnnotationLinkSet(List<FolderAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.addAll(targets);
        for (FolderAnnotationLink target : targets) {
            target.setParent(this);
        }
    }

    @Override
    public void removeFolderAnnotationLink(FolderAnnotationLink target, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(target);
        target.setParent(null);
    }

    @Override
    public void removeAllFolderAnnotationLinkSet(List<FolderAnnotationLink> targets, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (FolderAnnotationLink elt : targets) {
            elt.setParent(null);
            this.annotationLinksSeq.remove(elt);
        }
    }

    @Override
    public void clearAnnotationLinks(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        for (FolderAnnotationLink elt : this.annotationLinksSeq) {
            elt.setParent(null);
        }
        this.annotationLinksSeq.clear();
    }

    @Override
    public void reloadAnnotationLinks(Folder toCopy, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (this.annotationLinksLoaded) {
            throw new ClientError("Cannot reload active collection: annotationLinksSeq");
        }
        if (toCopy == null) {
            throw new ClientError("Argument cannot be null");
        }
        if (toCopy.getId().getValue() != this.getId().getValue()) {
            throw new ClientError("Argument must have the same id as this instance");
        }
        if (toCopy.getDetails().getUpdateEvent().getId().getValue() < this.getDetails().getUpdateEvent().getId().getValue()) {
            throw new ClientError("Argument may not be older than this instance");
        }
        List<FolderAnnotationLink> copy = toCopy.copyAnnotationLinks();
        for (FolderAnnotationLink elt : copy) {
            elt.setParent(this);
        }
        this.annotationLinksSeq = new ArrayList<FolderAnnotationLink>(copy);
        toCopy.unloadAnnotationLinks();
        this.annotationLinksLoaded = true;
    }

    @Override
    public Map<Long, Long> getAnnotationLinksCountPerOwner(Current current) {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    public FolderAnnotationLink linkAnnotation(Annotation addition, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        FolderAnnotationLinkI link = new FolderAnnotationLinkI();
        link.link(this, addition);
        this.addFolderAnnotationLinkToBoth(link, true);
        return link;
    }

    @Override
    public void addFolderAnnotationLinkToBoth(FolderAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.add(link);
    }

    @Override
    public List<FolderAnnotationLink> findFolderAnnotationLink(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        ArrayList<FolderAnnotationLink> result = new ArrayList<FolderAnnotationLink>();
        for (FolderAnnotationLink link : this.annotationLinksSeq) {
            if (link.getChild() != removal) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        List<FolderAnnotationLink> toRemove = this.findFolderAnnotationLink(removal);
        Iterator<FolderAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeFolderAnnotationLinkFromBoth(it.next(), true);
        }
    }

    @Override
    public void removeFolderAnnotationLinkFromBoth(FolderAnnotationLink link, boolean bothSides, Current current) throws UnloadedEntityException, UnloadedCollectionException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("annotationLinksSeq");
        }
        this.annotationLinksSeq.remove(link);
    }

    @Override
    public List<Annotation> linkedAnnotationList(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        if (!this.annotationLinksLoaded) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        ArrayList<Annotation> linked = new ArrayList<Annotation>();
        for (FolderAnnotationLink link : this.annotationLinksSeq) {
            linked.add(link.getChild());
        }
        return linked;
    }

    public void unloadName() {
        this.name = null;
    }

    @Override
    public RString getName(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.name;
    }

    @Override
    public void setName(RString name, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.name = name;
    }

    private void copyName(ome.model.containers.Folder source, IceMapper mapper) {
        this.name = source.getName() == null ? null : rtypes.rstring(source.getName());
    }

    private void fillName(ome.model.containers.Folder target, IceMapper mapper) {
        try {
            target.setName((String)mapper.fromRType(this.getName()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void unloadDescription() {
        this.description = null;
    }

    @Override
    public RString getDescription(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.description;
    }

    @Override
    public void setDescription(RString description, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.description = description;
    }

    private void copyDescription(ome.model.containers.Folder source, IceMapper mapper) {
        this.description = source.getDescription() == null ? null : rtypes.rstring(source.getDescription());
    }

    private void fillDescription(ome.model.containers.Folder target, IceMapper mapper) {
        try {
            target.setDescription((String)mapper.fromRType(this.getDescription()));
        }
        catch (ApiUsageException aue) {
            throw new ClientError(aue.message);
        }
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.containers.Folder) {
            ome.model.containers.Folder source = (ome.model.containers.Folder)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyChildFolders(source, mapper);
                this.copyParentFolder(source, mapper);
                this.copyImageLinks(source, mapper);
                this.copyRoiLinks(source, mapper);
                this.copyAnnotationLinks(source, mapper);
                this.copyName(source, mapper);
                this.copyDescription(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("Folder cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.containers.Folder target = new ome.model.containers.Folder();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillChildFolders(target, mapper);
            this.fillParentFolder(target, mapper);
            this.fillImageLinks(target, mapper);
            this.fillRoiLinks(target, mapper);
            this.fillAnnotationLinks(target, mapper);
            this.fillName(target, mapper);
            this.fillDescription(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<FolderI> cast(List list) {
        return list;
    }
}

