/*
 * Decompiled with CFR 0.152.
 */
package omero.model;

import Ice.Current;
import java.util.List;
import ome.model.ModelBased;
import ome.util.Filterable;
import ome.util.ModelMapper;
import ome.util.ReverseModelMapper;
import omero.ClientError;
import omero.RInt;
import omero.RLong;
import omero.UnloadedCollectionException;
import omero.UnloadedEntityException;
import omero.model.Annotation;
import omero.model.Details;
import omero.model.DetailsI;
import omero.model.IObject;
import omero.model.Objective;
import omero.model.ObjectiveAnnotationLink;
import omero.rtypes;
import omero.util.IceMapper;

public class ObjectiveAnnotationLinkI
extends ObjectiveAnnotationLink
implements ModelBased {
    public static final String PARENT = "ome.model.annotations.ObjectiveAnnotationLink_parent";
    public static final String CHILD = "ome.model.annotations.ObjectiveAnnotationLink_child";
    public static final String DETAILS = "ome.model.annotations.ObjectiveAnnotationLink_details";

    protected void errorIfUnloaded() throws UnloadedEntityException {
        if (!this.loaded) {
            throw new UnloadedEntityException("Object unloaded:" + this);
        }
    }

    protected void throwNullCollectionException(String propertyName) throws UnloadedCollectionException {
        throw new UnloadedCollectionException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"" + propertyName + "Loaded\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    protected void toggleCollectionsLoaded(boolean load) {
    }

    public ObjectiveAnnotationLinkI() {
        this.loaded = true;
        this.toggleCollectionsLoaded(true);
        this.details = new DetailsI();
    }

    public ObjectiveAnnotationLinkI(long id, boolean loaded) {
        this(rtypes.rlong(id), loaded);
    }

    public ObjectiveAnnotationLinkI(RLong id, boolean loaded) {
        this.id = id;
        this.loaded = loaded;
        if (loaded) {
            this.details = new DetailsI();
        }
        this.toggleCollectionsLoaded(loaded);
    }

    @Override
    public void unload(Current current) {
        this.loaded = false;
        this.unloadParent();
        this.unloadChild();
        this.unloadDetails();
    }

    @Override
    public boolean isLoaded(Current current) {
        return this.loaded;
    }

    @Override
    public void unloadCollections(Current current) {
        this.toggleCollectionsLoaded(false);
    }

    @Override
    public boolean isGlobal(Current current) {
        return false;
    }

    @Override
    public boolean isMutable(Current current) {
        return true;
    }

    @Override
    public boolean isAnnotated(Current current) {
        return false;
    }

    @Override
    public boolean isLink(Current current) {
        return true;
    }

    @Override
    public IObject shallowCopy(Current current) {
        if (!this.loaded) {
            return this.proxy();
        }
        ObjectiveAnnotationLinkI copy = new ObjectiveAnnotationLinkI();
        copy.id = this.id;
        copy.version = this.version;
        copy.parent = this.parent == null ? null : (Objective)this.parent.proxy();
        copy.child = this.child == null ? null : (Annotation)this.child.proxy();
        copy.details = null;
        return copy;
    }

    @Override
    public IObject proxy(Current current) {
        if (this.id == null) {
            throw new ClientError("Proxies require an id");
        }
        return new ObjectiveAnnotationLinkI(this.id.getValue(), false);
    }

    @Override
    public RLong getId(Current current) {
        return this.id;
    }

    @Override
    public void setId(RLong id, Current current) {
        this.id = id;
    }

    @Override
    public Details getDetails(Current current) {
        this.errorIfUnloaded();
        return this.details;
    }

    @Override
    public void unloadDetails(Current current) {
        this.details = null;
    }

    private void copyDetails(ome.model.IObject source, IceMapper mapper) {
        this.details = (Details)mapper.findTarget(source.getDetails());
    }

    private void fillDetails(ome.model.IObject target, IceMapper mapper) {
        ome.model.internal.Details details = (ome.model.internal.Details)mapper.reverse((ModelBased)this.getDetails());
        if (details != null) {
            target.getDetails().copy(details);
        }
    }

    @Override
    public RInt getVersion(Current current) {
        this.errorIfUnloaded();
        return this.version;
    }

    @Override
    public void setVersion(RInt version, Current current) {
        this.version = version;
    }

    public void unloadParent() {
        this.parent = null;
    }

    @Override
    public Objective getParent(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.parent;
    }

    @Override
    public void setParent(Objective parent, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.parent = parent;
    }

    private void copyParent(ome.model.annotations.ObjectiveAnnotationLink source, IceMapper mapper) {
        this.parent = (Objective)mapper.findTarget(source.getParent());
    }

    private void fillParent(ome.model.annotations.ObjectiveAnnotationLink target, IceMapper mapper) {
        target.putAt(PARENT, (Object)mapper.reverse((ModelBased)this.getParent()));
    }

    public void unloadChild() {
        this.child = null;
    }

    @Override
    public Annotation getChild(Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        return this.child;
    }

    @Override
    public void setChild(Annotation child, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.child = child;
    }

    private void copyChild(ome.model.annotations.ObjectiveAnnotationLink source, IceMapper mapper) {
        this.child = (Annotation)mapper.findTarget(source.getChild());
    }

    private void fillChild(ome.model.annotations.ObjectiveAnnotationLink target, IceMapper mapper) {
        target.putAt(CHILD, (Object)mapper.reverse((ModelBased)this.getChild()));
    }

    @Override
    public void link(Objective _parent, Annotation _child, Current current) throws UnloadedEntityException {
        this.errorIfUnloaded();
        this.setParent(_parent);
        this.setChild(_child);
    }

    public void copyObject(Filterable model, ModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        if (model instanceof ome.model.annotations.ObjectiveAnnotationLink) {
            ome.model.annotations.ObjectiveAnnotationLink source = (ome.model.annotations.ObjectiveAnnotationLink)model;
            this.loaded = source.isLoaded();
            Long id = (Long)mapper.findTarget(source.getId());
            this.setId(id == null ? null : rtypes.rlong(id));
            if (!source.isLoaded()) {
                this.unload();
            } else {
                this.version = source.getVersion() == null ? null : rtypes.rint(source.getVersion());
                this.copyParent(source, mapper);
                this.copyChild(source, mapper);
                this.copyDetails((ome.model.IObject)source, mapper);
            }
        } else {
            throw new IllegalArgumentException("ObjectiveAnnotationLink cannot copy from " + (model == null ? "null" : model.getClass().getName()));
        }
    }

    public Filterable fillObject(ReverseModelMapper _mapper) {
        IceMapper mapper = (IceMapper)_mapper;
        ome.model.annotations.ObjectiveAnnotationLink target = new ome.model.annotations.ObjectiveAnnotationLink();
        mapper.store(this, target);
        if (!this.loaded) {
            target.setId(this.id == null ? null : Long.valueOf(this.id.getValue()));
            target.unload();
        } else {
            RLong id = this.getId();
            target.setId(id == null ? null : Long.valueOf(id.getValue()));
            target.setVersion(this.version == null ? null : Integer.valueOf(this.version.getValue()));
            this.fillParent(target, mapper);
            this.fillChild(target, mapper);
            this.fillDetails((ome.model.IObject)target, mapper);
        }
        return target;
    }

    public static List<ObjectiveAnnotationLinkI> cast(List list) {
        return list;
    }
}

