/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class CV7000Reader
extends FormatReader {
    public static final String DUPLICATE_PLANES_KEY = "cv7000.duplicate_missing_planes";
    public static final boolean DUPLICATE_PLANES_DEFAULT = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(CV7000Reader.class);
    private static final String MEASUREMENT_FILE = "MeasurementData.mlf";
    private static final String MEASUREMENT_DETAIL = "MeasurementDetail.mrf";
    private static final String POST_PROCESS = "PostProcess.ppf";
    private List<String> allFiles = new ArrayList<String>();
    private MinimalTiffReader reader;
    private String wppPath;
    private String detailPath;
    private String measurementPath;
    private String settingsPath;
    private ArrayList<Plane> planeData;
    private int[][] reversePlaneLookup;
    private ArrayList<LightSource> lightSources;
    private ArrayList<Channel> channels;
    private int fields;
    private String startTime;
    private String endTime;
    private ArrayList<String> extraFiles;
    private transient Map<String, Boolean> acquiredWells = new HashMap<String, Boolean>();

    public CV7000Reader() {
        super("Yokogawa CV7000", new String[]{"wpi"});
        this.hasCompanionFiles = true;
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.datasetDescription = "Directory with XML files and one .tif/.tiff file per plane";
    }

    public boolean duplicatePlanes() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(DUPLICATE_PLANES_KEY, Boolean.valueOf(true));
        }
        return true;
    }

    public int getRequiredDirectories(String[] files) throws FormatException, IOException {
        return 1;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getUsedFiles(boolean noPixels) {
        ArrayList<String> files = new ArrayList<String>();
        files.add(new Location(this.currentId).getAbsolutePath());
        for (String file : this.allFiles) {
            if (file == null || files.contains(file) || noPixels && CV7000Reader.checkSuffix((String)file, (String)"tif")) continue;
            files.add(file);
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        HashSet<String> files = new HashSet<String>();
        files.add(new Location(this.currentId).getAbsolutePath());
        files.add(this.measurementPath);
        if (this.detailPath != null) {
            files.add(this.detailPath);
        }
        if (this.settingsPath != null) {
            files.add(this.settingsPath);
        }
        if (this.wppPath != null) {
            files.add(this.wppPath);
        }
        if (!noPixels && this.planeData != null) {
            for (int index : this.reversePlaneLookup[this.getSeries()]) {
                Plane p;
                if (index < 0 || (p = this.planeData.get(index)) == null || p.file == null) continue;
                files.add(p.file);
            }
        }
        if (!noPixels && this.channels != null) {
            Object object = this.channels.iterator();
            while (object.hasNext()) {
                Channel c = (Channel)object.next();
                if (c == null || c.correctionFile == null || !new Location(c.correctionFile).exists()) continue;
                files.add(c.correctionFile);
            }
        }
        files.addAll(this.extraFiles);
        for (String file : this.allFiles) {
            if (file == null || CV7000Reader.checkSuffix((String)file, (String)"tif") || new Location(file).isDirectory()) continue;
            files.add(file);
        }
        Object[] allFiles = files.toArray(new String[files.size()]);
        Arrays.sort(allFiles);
        return allFiles;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.measurementPath = null;
            this.detailPath = null;
            this.wppPath = null;
            this.settingsPath = null;
            this.planeData = null;
            this.fields = 0;
            this.lightSources = null;
            this.channels = null;
            this.startTime = null;
            this.endTime = null;
            this.reversePlaneLookup = null;
            this.extraFiles = null;
            this.acquiredWells.clear();
            if (this.allFiles != null) {
                this.allFiles.clear();
            } else {
                this.allFiles = new ArrayList<String>();
            }
        }
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        Arrays.fill(buf, this.getFillColor());
        Plane p = this.lookupPlane(this.getSeries(), no);
        LOGGER.trace("series = {}, no = {}, file = {}", new Object[]{this.series, no, p == null ? null : p.file});
        if (p != null && p.file != null) {
            this.reader.setId(p.file);
            return this.reader.openBytes(0, buf, x, y, w, h);
        }
        if (this.duplicatePlanes() && no > 0) {
            int[] zct = this.getZCTCoords(no);
            int dupPlane = this.getIndex(0, zct[1], 0);
            if (dupPlane == no) {
                dupPlane = 0;
            }
            return this.openBytes(dupPlane, buf, x, y, w, h);
        }
        return buf;
    }

    protected ArrayList<String> getAvailableOptions() {
        ArrayList optionsList = super.getAvailableOptions();
        optionsList.add(DUPLICATE_PLANES_KEY);
        return optionsList;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        WPIHandler plate = new WPIHandler();
        String wpiXML = this.readSanitizedXML(id);
        XMLTools.parseXML(wpiXML, (DefaultHandler)plate);
        Location parent = new Location(id).getAbsoluteFile().getParentFile();
        Object[] listedFiles = parent.list(true);
        Arrays.sort(listedFiles);
        for (int i = 0; i < listedFiles.length; ++i) {
            Location file = new Location(parent, (String)listedFiles[i]);
            if (file.isDirectory() || !file.canRead()) continue;
            this.allFiles.add(file.getAbsolutePath());
        }
        Location measurementData = new Location(parent, MEASUREMENT_FILE);
        if (!measurementData.exists()) {
            throw new FormatException("Missing MeasurementData.mlf file");
        }
        this.measurementPath = measurementData.getAbsolutePath();
        MeasurementDataHandler measurementHandler = new MeasurementDataHandler(parent.getAbsolutePath());
        XMLTools.parseXML(this.readSanitizedXML(this.measurementPath), (DefaultHandler)measurementHandler);
        this.planeData = measurementHandler.getPlanes();
        Location measurementDetail = new Location(parent, MEASUREMENT_DETAIL);
        if (!measurementDetail.exists()) {
            LOGGER.warn("Missing MeasurementDetail.mrf file");
        } else {
            this.channels = new ArrayList();
            this.detailPath = measurementDetail.getAbsolutePath();
            MeasurementDetailHandler detailHandler = new MeasurementDetailHandler();
            XMLTools.parseXML(this.readSanitizedXML(this.detailPath), (DefaultHandler)detailHandler);
            if (this.wppPath != null) {
                this.wppPath = new Location(parent, this.wppPath).getAbsolutePath();
            }
            if (this.settingsPath != null) {
                this.settingsPath = new Location(parent, this.settingsPath).getAbsolutePath();
            }
        }
        if (this.settingsPath != null && new Location(this.settingsPath).exists()) {
            this.lightSources = new ArrayList();
            MeasurementSettingsHandler settingsHandler = new MeasurementSettingsHandler();
            String xml = this.readSanitizedXML(this.settingsPath);
            if (xml.length() > 0) {
                XMLTools.parseXML(xml, (DefaultHandler)settingsHandler);
            }
        }
        this.channels.sort(new Comparator<Channel>(){

            @Override
            public int compare(Channel c1, Channel c2) {
                if (c1.actionIndex != c2.actionIndex) {
                    return c1.actionIndex - c2.actionIndex;
                }
                return c1.index - c2.index;
            }
        });
        for (Channel ch : this.channels) {
            if (ch.correctionFile == null) continue;
            ch.correctionFile = new Location(parent, ch.correctionFile).getAbsolutePath();
        }
        String firstFile = null;
        HashMap<Integer, MinMax> minMax = new HashMap<Integer, MinMax>();
        this.fields = 0;
        HashSet<Integer> uniqueWells = new HashSet<Integer>();
        HashSet<Integer> uniqueChannels = new HashSet<Integer>();
        for (Plane p : this.planeData) {
            if (p == null || !this.isWellAcquired(p.field.row, p.field.column)) continue;
            if (!this.allFiles.contains(p.file)) {
                this.allFiles.add(p.file);
            }
            p.channelIndex = this.getChannelIndex(p);
            int wellIndex = p.field.row * plate.getPlateColumns() + p.field.column;
            if (!minMax.containsKey(wellIndex)) {
                minMax.put(wellIndex, new MinMax());
            }
            MinMax m = (MinMax)minMax.get(wellIndex);
            if (p.file != null && firstFile == null) {
                firstFile = p.file;
            }
            if (p.timepoint > m.maxT) {
                m.maxT = p.timepoint;
            }
            if (p.timepoint < m.minT) {
                m.minT = p.timepoint;
            }
            if (p.z > m.maxZ) {
                m.maxZ = p.z;
            }
            if (p.z < m.minZ) {
                m.minZ = p.z;
            }
            if (p.channelIndex > m.maxC) {
                m.maxC = p.channelIndex;
            }
            if (p.channelIndex < m.minC) {
                m.minC = p.channelIndex;
            }
            uniqueChannels.add(p.channelIndex);
            if (p.field.field >= this.fields) {
                this.fields = p.field.field + 1;
            }
            uniqueWells.add(wellIndex);
        }
        this.reader = new MinimalTiffReader();
        this.reader.setId(firstFile);
        this.core.clear();
        this.core.add(new CoreMetadata((CoreMetadata)this.reader.getCoreMetadataList().get(0)));
        ((CoreMetadata)this.core.get((int)0)).dimensionOrder = "XYCZT";
        int realWells = uniqueWells.size();
        Object[] wells = uniqueWells.toArray(new Integer[realWells]);
        Arrays.sort(wells);
        this.reversePlaneLookup = new int[realWells * this.fields][];
        Object[] channelIndexes = uniqueChannels.toArray(new Integer[uniqueChannels.size()]);
        Arrays.sort(channelIndexes);
        for (int i = 0; i < realWells * this.fields; ++i) {
            if (i > 0) {
                this.core.add(new CoreMetadata((CoreMetadata)this.core.get(0)));
            }
            int wellIndex = (Integer)wells[i / this.fields];
            MinMax m = (MinMax)minMax.get(wellIndex);
            ((CoreMetadata)this.core.get((int)i)).sizeZ = m.maxZ - m.minZ + 1;
            ((CoreMetadata)this.core.get((int)i)).sizeT = m.maxT - m.minT + 1;
            ((CoreMetadata)this.core.get((int)i)).sizeC = this.reader.getSizeC() * uniqueChannels.size();
            ((CoreMetadata)this.core.get((int)i)).imageCount = ((CoreMetadata)this.core.get((int)i)).sizeZ * ((CoreMetadata)this.core.get((int)i)).sizeT * (((CoreMetadata)this.core.get((int)i)).sizeC / this.reader.getSizeC());
            this.reversePlaneLookup[i] = new int[((CoreMetadata)this.core.get((int)i)).imageCount];
            Arrays.fill(this.reversePlaneLookup[i], -1);
        }
        int[] seriesLengths = new int[]{this.fields, realWells};
        int[] planeLengths = new int[]{this.getSizeC(), this.getSizeZ(), this.getSizeT()};
        this.extraFiles = new ArrayList();
        for (int i = 0; i < this.planeData.size(); ++i) {
            Plane p = this.planeData.get(i);
            p.channelIndex = Arrays.binarySearch(channelIndexes, (Object)p.channelIndex);
            Field f = p.field;
            if (!this.isWellAcquired(f.row, f.column)) continue;
            int wellNumber = f.row * plate.getPlateColumns() + f.column;
            int wellIndex = Arrays.binarySearch(wells, (Object)wellNumber);
            p.series = FormatTools.positionToRaster((int[])seriesLengths, (int[])new int[]{f.field, wellIndex});
            MinMax m = (MinMax)minMax.get(wellNumber);
            planeLengths[0] = ((CoreMetadata)this.core.get((int)p.series)).sizeC / this.reader.getSizeC();
            planeLengths[1] = ((CoreMetadata)this.core.get((int)p.series)).sizeZ;
            planeLengths[2] = ((CoreMetadata)this.core.get((int)p.series)).sizeT;
            p.no = FormatTools.positionToRaster((int[])planeLengths, (int[])new int[]{p.channelIndex, p.z - m.minZ, p.timepoint - m.minT});
            if (this.reversePlaneLookup[p.series][p.no] < 0) {
                this.reversePlaneLookup[p.series][p.no] = i;
                continue;
            }
            LOGGER.warn("Ignoring file {}", (Object)p.file);
            this.extraFiles.add(p.file);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)true);
        store.setPlateID(MetadataTools.createLSID((String)"Plate", (int[])new int[]{0}), 0);
        store.setPlateName(plate.getPlateName(), 0);
        store.setPlateDescription(plate.getPlateDescription(), 0);
        store.setPlateExternalIdentifier(plate.getPlateID(), 0);
        store.setPlateRows(new PositiveInteger(Integer.valueOf(plate.getPlateRows())), 0);
        store.setPlateColumns(new PositiveInteger(Integer.valueOf(plate.getPlateColumns())), 0);
        String plateAcqID = MetadataTools.createLSID((String)"PlateAcquisition", (int[])new int[]{0, 0});
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        PositiveInteger fieldCount = FormatTools.getMaxFieldCount((Integer)this.fields);
        if (fieldCount != null) {
            store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
        }
        if (this.startTime != null) {
            store.setPlateAcquisitionStartTime(new Timestamp(this.startTime), 0, 0);
        }
        if (this.endTime != null) {
            store.setPlateAcquisitionEndTime(new Timestamp(this.endTime), 0, 0);
        }
        int nextWell = 0;
        int nextImage = 0;
        for (int row = 0; row < plate.getPlateRows(); ++row) {
            for (int col = 0; col < plate.getPlateColumns(); ++col) {
                store.setWellID(MetadataTools.createLSID((String)"Well", (int[])new int[]{0, nextWell}), 0, nextWell);
                store.setWellRow(new NonNegativeInteger(Integer.valueOf(row)), 0, nextWell);
                store.setWellColumn(new NonNegativeInteger(Integer.valueOf(col)), 0, nextWell);
                if (!this.isWellAcquired(row, col)) {
                    ++nextWell;
                    continue;
                }
                for (int field = 0; field < this.fields; ++field) {
                    String wellSampleID = MetadataTools.createLSID((String)"WellSample", (int[])new int[]{0, nextWell, field});
                    store.setWellSampleID(wellSampleID, 0, nextWell, field);
                    store.setWellSampleIndex(new NonNegativeInteger(Integer.valueOf(nextImage)), 0, nextWell, field);
                    String imageID = MetadataTools.createLSID((String)"Image", (int[])new int[]{nextImage});
                    store.setImageID(imageID, nextImage);
                    store.setWellSampleImageRef(imageID, 0, nextWell, field);
                    String name = "Well " + FormatTools.getWellRowName((int)row) + (col + 1) + ", Field " + (field + 1);
                    store.setImageName(name, nextImage);
                    store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, nextImage);
                    this.setSeries(nextImage);
                    int no = 0;
                    Plane p = this.lookupPlane(nextImage, no);
                    while (p == null && no < this.getImageCount()) {
                        p = this.lookupPlane(nextImage, no++);
                    }
                    if (p != null) {
                        store.setWellSamplePositionX(FormatTools.createLength((Double)p.xpos, (Unit)UNITS.REFERENCEFRAME), 0, nextWell, field);
                        store.setWellSamplePositionY(FormatTools.createLength((Double)p.ypos, (Unit)UNITS.REFERENCEFRAME), 0, nextWell, field);
                    }
                    ++nextImage;
                }
                ++nextWell;
            }
        }
        this.setSeries(0);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setPlateName(plate.getPlateName(), 0);
            store.setPlateDescription(plate.getPlateDescription(), 0);
            store.setPlateExternalIdentifier(plate.getPlateID(), 0);
            String instrument = null;
            ArrayList<String> usedObjectiveIDs = new ArrayList<String>();
            if (this.lightSources.size() > 0) {
                instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
                store.setInstrumentID(instrument, 0);
                int nextLightSource = 0;
                for (LightSource l : this.lightSources) {
                    if (!"Laser".equals(l.type)) continue;
                    String laserID = MetadataTools.createLSID((String)"LightSource", (int[])new int[]{0, nextLightSource});
                    store.setLaserID(laserID, 0, nextLightSource);
                    store.setLaserWavelength(new Length((Number)l.wavelength, UNITS.NANOMETER), 0, nextLightSource);
                    store.setLaserPower(new Power((Number)l.power, UNITS.MILLIWATT), 0, nextLightSource);
                    ++nextLightSource;
                }
                for (Channel c : this.channels) {
                    if (c.objectiveID == null || usedObjectiveIDs.contains(c.objectiveID)) continue;
                    int index = usedObjectiveIDs.size();
                    String objectiveID = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, index});
                    store.setObjectiveID(objectiveID, 0, index);
                    store.setObjectiveModel(c.objective, 0, index);
                    usedObjectiveIDs.add(c.objectiveID);
                }
            }
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                this.setSeries(i);
                if (this.channels != null) {
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        Channel channel;
                        Plane p = this.lookupPlane(i, c);
                        if (p == null || (channel = this.lookupChannel(p)) == null) continue;
                        if (c == 0) {
                            store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX((Double)channel.xSize), i);
                            store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY((Double)channel.ySize), i);
                        }
                        int objective = -1;
                        if (channel.objectiveID != null) {
                            objective = usedObjectiveIDs.indexOf(channel.objectiveID);
                        }
                        if (channel.magnification != null && objective >= 0) {
                            store.setObjectiveNominalMagnification(channel.magnification, 0, objective);
                        }
                        if (objective >= 0) {
                            String objectiveID = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, objective});
                            store.setObjectiveSettingsID(objectiveID, i);
                        }
                        store.setChannelName("Action #" + (p.actionIndex + 1) + ", Channel #" + (channel.index + 1) + ", Camera #" + channel.cameraNumber, i, c);
                        if (channel.color != null) {
                            store.setChannelColor(channel.color, i, c);
                        }
                        if (channel.fluor != null && !channel.fluor.isEmpty()) {
                            store.setChannelFluor(channel.fluor, i, c);
                        }
                        if (channel.excitation != null && channel.lightSourceRefs != null) {
                            int index = -1;
                            for (int ref = 0; ref < channel.lightSourceRefs.size(); ++ref) {
                                int lightSource = channel.lightSourceRefs.get(ref);
                                if (!"Laser".equals(this.lightSources.get((int)lightSource).type) || !(this.lightSources.get((int)lightSource).wavelength < channel.excitation)) continue;
                                index = lightSource;
                            }
                            if (index >= 0) {
                                store.setChannelLightSourceSettingsID(MetadataTools.createLSID((String)"LightSource", (int[])new int[]{0, index}), i, c);
                                store.setChannelExcitationWavelength(new Length((Number)channel.excitation, UNITS.NANOMETER), i, c);
                            }
                        }
                        if (channel.exposureTime == null) continue;
                        Time exposure = new Time((Number)channel.exposureTime, UNITS.MILLISECOND);
                        for (int z = 0; z < this.getSizeZ(); ++z) {
                            for (int t = 0; t < this.getSizeT(); ++t) {
                                int plane = this.getIndex(z, c, t);
                                store.setPlaneExposureTime(exposure, i, plane);
                            }
                        }
                    }
                }
                for (int p = 0; p < this.getImageCount(); ++p) {
                    Plane plane = this.lookupPlane(i, p);
                    if (plane == null) continue;
                    store.setPlanePositionX(FormatTools.createLength((Double)plane.xpos, (Unit)UNITS.REFERENCEFRAME), i, p);
                    store.setPlanePositionY(FormatTools.createLength((Double)plane.ypos, (Unit)UNITS.REFERENCEFRAME), i, p);
                    store.setPlanePositionZ(FormatTools.createLength((Double)plane.zpos, (Unit)UNITS.REFERENCEFRAME), i, p);
                }
            }
            this.setSeries(0);
        }
    }

    private int getChannelIndex(Plane p) {
        int index = -1;
        for (int action = 0; action <= p.actionIndex; ++action) {
            for (Channel ch : this.channels) {
                if (ch.timelineIndex != p.timelineIndex || ch.actionIndex != action) continue;
                ++index;
                if (ch.index != p.channel || ch.actionIndex != p.actionIndex) continue;
                return index;
            }
        }
        return index;
    }

    private Channel lookupChannel(Plane p) {
        for (Channel ch : this.channels) {
            if (ch.index != p.channel) continue;
            return ch;
        }
        return null;
    }

    private String readSanitizedXML(String filename) throws IOException {
        String xml = DataTools.readFile(filename).trim();
        if (xml.endsWith(">>")) {
            xml = xml.substring(0, xml.length() - 1);
        }
        return xml;
    }

    private boolean isWellAcquired(int row, int col) {
        String key = row + "-" + col;
        if (this.acquiredWells.containsKey(key)) {
            return this.acquiredWells.get(key);
        }
        if (this.planeData != null) {
            for (Plane p : this.planeData) {
                if (p == null || p.file == null || p.field.row != row || p.field.column != col) continue;
                this.acquiredWells.put(key, true);
                return true;
            }
        }
        this.acquiredWells.put(key, false);
        return false;
    }

    private Plane lookupPlane(int series, int no) {
        int index = this.reversePlaneLookup[series][no];
        LOGGER.trace("lookupPlane(series={}, no={}), index = {}", new Object[]{series, no, index});
        if (index < 0 || index >= this.planeData.size()) {
            return null;
        }
        Plane p = this.planeData.get(index);
        if (p.series != series || p.no != no) {
            return null;
        }
        return p;
    }

    class Plane {
        public String file;
        public String timestamp;
        public Field field;
        public int timepoint;
        public int z;
        public int channel;
        public int channelIndex;
        public double xpos;
        public double ypos;
        public double zpos;
        public int series;
        public int no;
        public int actionIndex;
        public int timelineIndex;

        Plane() {
        }
    }

    class Channel {
        public int timelineIndex = -1;
        public int actionIndex = -1;
        public int index;
        public double xSize;
        public double ySize;
        public int cameraNumber;
        public String correctionFile;
        public List<Integer> lightSourceRefs = new ArrayList<Integer>();
        public Double excitation;
        public String objectiveID;
        public String objective;
        public Double magnification;
        public Double exposureTime;
        public String binning;
        public Color color;
        public String fluor;

        public Channel() {
        }

        public Channel(Channel ch) {
            this.index = ch.index;
            this.xSize = ch.xSize;
            this.ySize = ch.ySize;
            this.cameraNumber = ch.cameraNumber;
            this.correctionFile = ch.correctionFile;
            this.lightSourceRefs = ch.lightSourceRefs;
            this.excitation = ch.excitation;
            this.objectiveID = ch.objectiveID;
            this.objective = ch.objective;
            this.magnification = ch.magnification;
            this.exposureTime = ch.exposureTime;
            this.binning = ch.binning;
            this.color = ch.color;
            this.fluor = ch.fluor;
        }

        public String toString() {
            return "timelineIndex=" + this.timelineIndex + ", actionIndex=" + this.actionIndex + ", index=" + this.index;
        }
    }

    class WPIHandler
    extends BaseHandler {
        private int plateRows;
        private int plateColumns;
        private String name;
        private String plateID;
        private String description;

        WPIHandler() {
        }

        public int getPlateRows() {
            return this.plateRows;
        }

        public int getPlateColumns() {
            return this.plateColumns;
        }

        public String getPlateName() {
            return this.name;
        }

        public String getPlateID() {
            return this.plateID;
        }

        public String getPlateDescription() {
            return this.description;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("bts:WellPlate")) {
                this.name = attributes.getValue("bts:Name");
                this.plateID = attributes.getValue("bts:ProductID");
                this.plateRows = Integer.parseInt(attributes.getValue("bts:Rows"));
                this.plateColumns = Integer.parseInt(attributes.getValue("bts:Columns"));
            }
        }
    }

    class MeasurementDataHandler
    extends BaseHandler {
        private StringBuffer currentValue = new StringBuffer();
        private String btsType;
        private ArrayList<Plane> planes = new ArrayList();
        private String parentDir;
        private int currentField = -1;

        public MeasurementDataHandler(String parentDir) {
            this.parentDir = parentDir;
        }

        public ArrayList<Plane> getPlanes() {
            return this.planes;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            this.currentValue.append(value);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentValue.setLength(0);
            try {
                this.btsType = attributes.getValue("bts:Type");
                if (qName.equals("bts:MeasurementRecord") && this.btsType.equals("IMG")) {
                    Plane p = new Plane();
                    p.field = new Field();
                    p.field.row = Integer.parseInt(attributes.getValue("bts:Row")) - 1;
                    p.field.column = Integer.parseInt(attributes.getValue("bts:Column")) - 1;
                    p.timepoint = Integer.parseInt(attributes.getValue("bts:TimePoint")) - 1;
                    p.field.field = Integer.parseInt(attributes.getValue("bts:FieldIndex")) - 1;
                    p.z = Integer.parseInt(attributes.getValue("bts:ZIndex")) - 1;
                    p.channel = Integer.parseInt(attributes.getValue("bts:Ch")) - 1;
                    p.actionIndex = Integer.parseInt(attributes.getValue("bts:ActionIndex")) - 1;
                    p.timelineIndex = Integer.parseInt(attributes.getValue("bts:TimelineIndex")) - 1;
                    if (p.field.field != this.currentField) {
                        this.currentField = p.field.field;
                    }
                    p.xpos = DataTools.parseDouble(attributes.getValue("bts:X"));
                    p.ypos = DataTools.parseDouble(attributes.getValue("bts:Y"));
                    p.zpos = DataTools.parseDouble(attributes.getValue("bts:Z"));
                    p.timestamp = attributes.getValue("bts:Time");
                    this.planes.add(p);
                }
            }
            catch (RuntimeException e) {
                if (LOGGER.isErrorEnabled()) {
                    HashMap<String, String> attributeMap = new HashMap<String, String>();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        attributeMap.put(attributes.getQName(i), attributes.getValue(i));
                    }
                    LOGGER.error("Error parsing attributes: {}", attributeMap, (Object)e);
                }
                throw e;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            Location imgFile;
            String value = this.currentValue.toString();
            if (qName.equals("bts:MeasurementRecord") && this.btsType.equals("IMG") && value.trim().length() > 0 && (imgFile = new Location(this.parentDir, value)).exists()) {
                this.planes.get((int)(this.planes.size() - 1)).file = imgFile.getAbsolutePath();
            }
        }
    }

    class MeasurementDetailHandler
    extends BaseHandler {
        MeasurementDetailHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("bts:MeasurementSamplePlate")) {
                CV7000Reader.this.wppPath = attributes.getValue("bts:WellPlateProductFileName");
                if (CV7000Reader.this.wppPath != null && CV7000Reader.this.wppPath.trim().length() == 0) {
                    CV7000Reader.this.wppPath = null;
                }
            } else if (qName.equals("bts:MeasurementChannel")) {
                Channel c = new Channel();
                c.index = Integer.parseInt(attributes.getValue("bts:Ch")) - 1;
                c.xSize = DataTools.parseDouble(attributes.getValue("bts:HorizontalPixelDimension"));
                c.ySize = DataTools.parseDouble(attributes.getValue("bts:VerticalPixelDimension"));
                c.cameraNumber = Integer.parseInt(attributes.getValue("bts:CameraNumber"));
                c.correctionFile = attributes.getValue("bts:ShadingCorrectionSource");
                if (c.correctionFile != null && c.correctionFile.trim().length() == 0) {
                    c.correctionFile = null;
                }
                CV7000Reader.this.channels.add(c);
            } else if (qName.equals("bts:MeasurementDetail")) {
                CV7000Reader.this.startTime = attributes.getValue("bts:BeginTime");
                CV7000Reader.this.endTime = attributes.getValue("bts:EndTime");
                CV7000Reader.this.settingsPath = attributes.getValue("bts:MeasurementSettingFileName");
                String system = attributes.getValue("bts:TargetSystem");
                CV7000Reader.this.addGlobalMeta("Acquisition system", system);
                if (!system.toLowerCase().startsWith("cv7000")) {
                    LOGGER.warn("Found data from {}; this is not well-supported", (Object)system);
                }
            }
        }
    }

    class MeasurementSettingsHandler
    extends BaseHandler {
        private Channel currentChannel = null;
        private StringBuffer currentValue = new StringBuffer();
        private int timelineIndex = -1;
        private int actionIndex = -1;

        MeasurementSettingsHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            this.currentValue.append(value);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentValue.setLength(0);
            if (qName.equals("bts:LightSource")) {
                LightSource l = new LightSource();
                l.name = attributes.getValue("bts:Name");
                l.type = attributes.getValue("bts:Type");
                String wavelength = attributes.getValue("bts:WaveLength");
                String power = attributes.getValue("bts:Power");
                l.wavelength = DataTools.parseDouble(wavelength);
                l.power = DataTools.parseDouble(power);
                CV7000Reader.this.lightSources.add(l);
            } else if (qName.equals("bts:Channel")) {
                int index;
                String ch = attributes.getValue("bts:Ch");
                if (ch != null && (index = Integer.parseInt(ch) - 1) >= 0 && index < CV7000Reader.this.channels.size()) {
                    String acquisition;
                    this.currentChannel = (Channel)CV7000Reader.this.channels.get(index);
                    this.currentChannel.objectiveID = attributes.getValue("bts:ObjectiveID");
                    this.currentChannel.objective = attributes.getValue("bts:Objective");
                    this.currentChannel.binning = attributes.getValue("bts:Binning");
                    String mag = attributes.getValue("bts:Magnification");
                    this.currentChannel.magnification = DataTools.parseDouble(mag);
                    String exposure = attributes.getValue("bts:ExposureTime");
                    this.currentChannel.exposureTime = DataTools.parseDouble(exposure);
                    String color = attributes.getValue("bts:Color");
                    if (color != null && (color = color.replaceAll("#", "")).length() >= 6) {
                        int[] colors = new int[color.length() / 2];
                        for (int i = 0; i < color.length(); i += 2) {
                            colors[i / 2] = Integer.parseInt(color.substring(i, i + 2), 16);
                        }
                        int alpha = colors.length == 4 ? colors[0] : 255;
                        int red = colors[colors.length - 3];
                        int green = colors[colors.length - 2];
                        int blue = colors[colors.length - 1];
                        this.currentChannel.color = new Color(red, green, blue, alpha);
                    }
                    if ((acquisition = attributes.getValue("bts:Acquisition")) != null && acquisition.indexOf("/") > 0) {
                        acquisition = acquisition.replaceAll("BP", "");
                        String wave = acquisition.substring(0, acquisition.indexOf("/"));
                        this.currentChannel.excitation = DataTools.parseDouble(wave);
                    }
                    this.currentChannel.fluor = attributes.getValue("bts:Fluorophore");
                }
            } else if (qName.equals("bts:Timeline")) {
                ++this.timelineIndex;
                this.actionIndex = -1;
            } else if (qName.startsWith("bts:ActionAcquire")) {
                ++this.actionIndex;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            int channelIndex;
            String value = this.currentValue.toString();
            if (qName.equals("bts:LightSourceName") && this.currentChannel != null) {
                int index = -1;
                for (int i = 0; i < CV7000Reader.this.lightSources.size(); ++i) {
                    if (!((LightSource)((CV7000Reader)CV7000Reader.this).lightSources.get((int)i)).name.equals(value)) continue;
                    index = i;
                }
                if (index >= 0) {
                    this.currentChannel.lightSourceRefs.add(index);
                }
            } else if (qName.equals("bts:Ch") && (channelIndex = Integer.parseInt(value) - 1) >= 0 && channelIndex < CV7000Reader.this.channels.size()) {
                Channel ch = (Channel)CV7000Reader.this.channels.get(channelIndex);
                if (ch.timelineIndex == -1 && ch.actionIndex == -1) {
                    ch.timelineIndex = this.timelineIndex;
                    ch.actionIndex = this.actionIndex;
                } else {
                    Channel duplicate = new Channel(ch);
                    duplicate.timelineIndex = this.timelineIndex;
                    duplicate.actionIndex = this.actionIndex;
                    CV7000Reader.this.channels.add(duplicate);
                }
            }
        }
    }

    class Field {
        public int row;
        public int column;
        public int field;

        Field() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field f = (Field)o;
            return f.row == this.row && f.column == this.column && f.field == this.field;
        }

        public int hashCode() {
            return (this.row & 0xFF) << 24 | (this.column & 0xFF) << 16 | this.field & 0xFFFF;
        }
    }

    class MinMax {
        public int minZ = Integer.MAX_VALUE;
        public int maxZ = 0;
        public int minC = Integer.MAX_VALUE;
        public int maxC = 0;
        public int minT = Integer.MAX_VALUE;
        public int maxT = 0;

        MinMax() {
        }
    }

    class LightSource {
        public String name;
        public String type;
        public Double wavelength;
        public Double power;

        LightSource() {
        }
    }
}

