/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class KhorosReader
extends FormatReader {
    public static final int KHOROS_MAGIC_BYTES = 43777;
    private byte[][] lut;
    private long offset;

    public KhorosReader() {
        super("Khoros XV", "xv");
        this.domains = new String[]{"Graphics"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)2, (boolean)false)) {
            return false;
        }
        return stream.readShort() == 43777;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int bufSize = FormatTools.getPlaneSize((IFormatReader)this);
        this.in.seek(this.offset + (long)(no * bufSize));
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.lut = null;
            this.offset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.skipBytes(4);
        this.in.order(true);
        int dependency = this.in.readInt();
        this.addGlobalMeta("Comment", this.in.readString(512));
        this.in.order(dependency == 4 || dependency == 8);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        this.in.skipBytes(28);
        m.imageCount = this.in.readInt();
        if (this.getImageCount() == 0) {
            m.imageCount = 1;
        }
        m.sizeC = this.in.readInt();
        int type = this.in.readInt();
        switch (type) {
            case 0: {
                m.pixelType = 0;
                break;
            }
            case 1: {
                m.pixelType = 1;
                break;
            }
            case 2: {
                m.pixelType = 3;
                break;
            }
            case 4: {
                m.pixelType = 4;
                break;
            }
            case 5: {
                m.pixelType = 6;
                break;
            }
            case 9: {
                m.pixelType = 7;
                break;
            }
            default: {
                throw new FormatException("Unsupported pixel type : " + type);
            }
        }
        this.in.skipBytes(12);
        int c = this.in.readInt();
        if (c > 1) {
            m.sizeC = c;
            int n = this.in.readInt();
            this.lut = new byte[c][n];
            this.in.skipBytes(436);
            for (int i = 0; i < this.lut.length; ++i) {
                for (int j = 0; j < this.lut[0].length; ++j) {
                    this.lut[i][j] = this.in.readByte();
                }
            }
        } else {
            this.in.skipBytes(440);
        }
        this.offset = this.in.getFilePointer();
        m.sizeZ = this.getImageCount();
        m.sizeT = 1;
        m.rgb = this.getSizeC() > 1;
        m.interleaved = false;
        m.littleEndian = dependency == 4 || dependency == 8;
        m.dimensionOrder = "XYCZT";
        m.indexed = this.lut != null;
        m.falseColor = false;
        m.metadataComplete = true;
        if (this.isIndexed()) {
            m.sizeC = 1;
            m.rgb = false;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

