/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.io.Serializable;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;

public final class Roles
implements Serializable {
    private static final long serialVersionUID = -2488864989534638213L;
    private final long rId;
    private final String rName;
    private final long sgId;
    private final String sgName;
    private final long ugId;
    private final String ugName;
    private final long guestId;
    private final String guestName;
    private final long ggId;
    private final String ggName;

    public Roles() {
        long nextUserId = -1L;
        long nextGroupId = -1L;
        ++nextUserId;
        this.rId = nextUserId++;
        this.rName = "root";
        ++nextGroupId;
        this.sgId = nextGroupId++;
        this.sgName = "system";
        this.ugId = nextGroupId++;
        this.ugName = "user";
        this.guestId = nextUserId;
        this.guestName = "guest";
        this.ggId = nextGroupId;
        this.ggName = "guest";
    }

    public Roles(long rootUserId, String rootUserName, long systemGroupId, String systemGroupName, long userGroupId, String userGroupName, long guestUserId, String guestUserName, long guestGroupId, String guestGroupName) {
        this.rId = rootUserId;
        this.rName = rootUserName;
        this.sgId = systemGroupId;
        this.sgName = systemGroupName;
        this.ugId = userGroupId;
        this.ugName = userGroupName;
        this.guestId = guestUserId;
        this.guestName = guestUserName;
        this.ggId = guestGroupId;
        this.ggName = guestGroupName;
    }

    public boolean isRootUser(Experimenter user) {
        return user != null && user.getId() != null && user.getId().equals(this.getRootId());
    }

    public boolean isUserGroup(ExperimenterGroup group) {
        return group != null && group.getId() != null && group.getId().equals(this.getUserGroupId());
    }

    public boolean isSystemGroup(ExperimenterGroup group) {
        return group != null && group.getId() != null && group.getId().equals(this.getSystemGroupId());
    }

    public long getRootId() {
        return this.rId;
    }

    public String getRootName() {
        return this.rName;
    }

    public long getGuestId() {
        return this.guestId;
    }

    public String getGuestName() {
        return this.guestName;
    }

    public long getSystemGroupId() {
        return this.sgId;
    }

    public String getSystemGroupName() {
        return this.sgName;
    }

    public long getUserGroupId() {
        return this.ugId;
    }

    public String getUserGroupName() {
        return this.ugName;
    }

    public long getGuestGroupId() {
        return this.ggId;
    }

    public String getGuestGroupName() {
        return this.ggName;
    }
}

