/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.util;

import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import omero.log.Logger;

public class NetworkChecker {
    private final AtomicLong lastCheck = new AtomicLong(System.currentTimeMillis());
    private final AtomicBoolean lastValue = new AtomicBoolean(true);
    private InetAddress ipAddress;
    private final String address;
    private Logger logger;
    private long interfacesCount;

    public NetworkChecker(String address, Logger logger) {
        this.address = address;
        this.logger = logger;
        if (this.ipAddress != null) {
            try {
                this.ipAddress = InetAddress.getByName(address);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        this.interfacesCount = 0L;
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface ni = interfaces.nextElement();
                    if (ni.isLoopback() || !ni.isUp()) continue;
                    ++this.interfacesCount;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isNetworkup(boolean useCachedValue) throws Exception {
        long elapsed;
        if (useCachedValue && (elapsed = System.currentTimeMillis() - this.lastCheck.get()) <= 5000L) {
            return this.lastValue.get();
        }
        boolean newValue = this._isNetworkup();
        long stop = System.currentTimeMillis();
        this.lastValue.set(newValue);
        this.lastCheck.set(stop);
        return newValue;
    }

    public boolean isAvailable() throws Exception {
        if (this.ipAddress != null && this.ipAddress.isLoopbackAddress()) {
            return true;
        }
        if (this.address != null) {
            try {
                URL url = new URL("http://" + this.address);
                HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
                urlConnect.setConnectTimeout(1000);
                urlConnect.getContent();
            }
            catch (Exception e) {
                this.log("Not available %s", e);
                return false;
            }
        }
        return true;
    }

    private boolean _isNetworkup() throws Exception {
        if (this.ipAddress != null && this.ipAddress.isLoopbackAddress()) {
            return true;
        }
        boolean networkup = false;
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        long count = 0L;
        if (interfaces != null && !networkup) {
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                if (ni.isLoopback() || !ni.isUp()) continue;
                ++count;
            }
        }
        if (count >= this.interfacesCount) {
            networkup = true;
        } else {
            networkup = this.isAvailable();
            if (networkup) {
                this.interfacesCount = count;
            }
        }
        if (!networkup) {
            throw new UnknownHostException("Network is down.");
        }
        return networkup;
    }

    void log(String msg, Object ... objs) {
        if (this.logger != null) {
            this.logger.debug((Object)this, String.format(msg, objs));
        }
    }
}

