/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;

public class VGSAMReader
extends FormatReader {
    public static final String VG_MAGIC_STRING = "VGS";
    public static final int PIXEL_OFFSET = 368;

    public VGSAMReader() {
        super("VG SAM", "dti");
        this.domains = new String[]{"Scanning Probe Microscopy (SPM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 3;
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)3, (boolean)false)) {
            return false;
        }
        return stream.readString(3).indexOf(VG_MAGIC_STRING) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.in.seek(368L);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        this.in.seek(348L);
        m.sizeX = this.in.readInt();
        m.sizeY = this.in.readInt();
        this.in.skipBytes(4);
        int bpp = this.in.readInt();
        this.addGlobalMeta("Bytes per pixel", bpp);
        m.pixelType = FormatTools.pixelTypeFromBytes((int)bpp, (boolean)false, (bpp == 4 ? 1 : 0) != 0);
        m.littleEndian = false;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = 1;
        m.rgb = false;
        m.interleaved = false;
        m.dimensionOrder = "XYZCT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
    }
}

