/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import com.google.common.math.DoubleMath;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import loci.formats.IFormatReader;
import ome.formats.model.ChannelData;
import ome.formats.model.ColorsFactory;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.RInt;
import omero.RString;
import omero.model.Channel;
import omero.model.Filter;
import omero.model.Image;
import omero.model.Laser;
import omero.model.Length;
import omero.model.LightSource;
import omero.model.LogicalChannel;
import omero.model.Pixels;
import omero.model.TransmittanceRange;
import omero.rtypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProcessor
implements ModelProcessor {
    public static final String RED_TEXT = "Red";
    public static final String GREEN_TEXT = "Green";
    public static final String BLUE_TEXT = "Blue";
    public static final String ALPHA_TEXT = "Alpha";
    private Logger log = LoggerFactory.getLogger(ChannelProcessor.class);
    private IObjectContainerStore store;
    private IFormatReader reader;

    private String getNameFromWavelength(Length value) {
        if (value == null) {
            return null;
        }
        if (DoubleMath.isMathematicalInteger((double)value.getValue())) {
            return "" + value.getValue();
        }
        return value.toString();
    }

    private void setSingleChannel(ChannelData channelData) {
        int channelIndex = channelData.getChannelIndex();
        Channel channel = channelData.getChannel();
        if (this.hasColor(channel)) {
            return;
        }
        int[] defaultColor = ColorsFactory.newGreyColor();
        channel.setRed(rtypes.rint(defaultColor[0]));
        channel.setGreen(rtypes.rint(defaultColor[1]));
        channel.setBlue(rtypes.rint(defaultColor[2]));
        channel.setAlpha(rtypes.rint(defaultColor[3]));
    }

    private void populateDefault(ChannelData channelData, boolean isGraphicsDomain) {
        LightSource ls;
        int channelIndex = channelData.getChannelIndex();
        Channel channel = channelData.getChannel();
        LogicalChannel lc = channelData.getLogicalChannel();
        if (isGraphicsDomain) {
            this.log.debug("Setting color channel to RGB.");
            this.setDefaultChannelColor(channel, channelIndex);
            switch (channelIndex) {
                case 0: {
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(RED_TEXT));
                    break;
                }
                case 1: {
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(GREEN_TEXT));
                    break;
                }
                case 2: {
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(BLUE_TEXT));
                    break;
                }
                case 3: {
                    channel.setRed(rtypes.rint(0));
                    channel.setGreen(rtypes.rint(0));
                    channel.setBlue(rtypes.rint(0));
                    channel.setAlpha(rtypes.rint(0));
                    if (lc.getName() != null) break;
                    lc.setName(rtypes.rstring(ALPHA_TEXT));
                }
            }
            return;
        }
        if (this.hasColor(channel)) {
            RString name;
            this.log.debug("Already set in BF.");
            if (lc.getName() == null && (name = this.getChannelName(channelData)) != null) {
                lc.setName(name);
            }
            return;
        }
        Length valueWavelength = lc.getEmissionWave();
        if (valueWavelength != null) {
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(valueWavelength));
            if (lc.getName() == null) {
                lc.setName(rtypes.rstring(this.getNameFromWavelength(valueWavelength)));
            }
            return;
        }
        Length valueFilter = null;
        Filter f = this.getValidFilter(channelData.getLightPathEmissionFilters(), true);
        if (f != null) {
            valueFilter = ColorsFactory.getValueFromFilter(f, true);
        }
        if (valueFilter != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(valueFilter));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        f = channelData.getFilterSetEmissionFilter();
        valueFilter = ColorsFactory.getValueFromFilter(f, true);
        if (valueFilter != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(valueFilter));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        if (channelData.getLightSource() != null && (ls = channelData.getLightSource()) instanceof Laser && (valueWavelength = ((Laser)ls).getWavelength()) != null) {
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(valueWavelength));
            if (lc.getName() == null) {
                lc.setName(rtypes.rstring(this.getNameFromWavelength(valueWavelength)));
            }
            return;
        }
        valueWavelength = lc.getExcitationWave();
        if (valueWavelength != null) {
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(valueWavelength));
            if (lc.getName() == null) {
                lc.setName(rtypes.rstring(this.getNameFromWavelength(valueWavelength)));
            }
            return;
        }
        f = this.getValidFilter(channelData.getLightPathExcitationFilters(), false);
        if (f != null) {
            valueFilter = ColorsFactory.getValueFromFilter(f, false);
        }
        if (valueFilter != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(valueFilter));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        f = channelData.getFilterSetExcitationFilter();
        valueFilter = ColorsFactory.getValueFromFilter(f, false);
        if (valueFilter != null) {
            RString name;
            this.setChannelColor(channel, channelIndex, ColorsFactory.determineColor(valueFilter));
            if (lc.getName() == null && (name = this.getNameFromFilter(f)) != null) {
                lc.setName(name);
            }
            return;
        }
        this.setDefaultChannelColor(channel, channelIndex);
    }

    private boolean hasColor(Channel channel) {
        Integer red = this.getValue(channel.getRed());
        Integer green = this.getValue(channel.getGreen());
        Integer blue = this.getValue(channel.getBlue());
        Integer alpha = this.getValue(channel.getAlpha());
        return red != null && green != null && blue != null && alpha != null;
    }

    private Filter getValidFilter(List<Filter> filters, boolean emission) {
        if (filters == null) {
            return null;
        }
        Iterator<Filter> i = filters.iterator();
        Length value = null;
        while (i.hasNext()) {
            Filter f = i.next();
            value = ColorsFactory.getValueFromFilter(f, emission);
            if (value == null) continue;
            return f;
        }
        return null;
    }

    private void setDefaultChannelColor(Channel channel, int index) {
        int[] defaultColor;
        int value = index % 3;
        switch (value) {
            case 0: {
                defaultColor = ColorsFactory.newRedColor();
                break;
            }
            case 1: {
                defaultColor = ColorsFactory.newGreenColor();
                break;
            }
            default: {
                defaultColor = ColorsFactory.newBlueColor();
            }
        }
        channel.setRed(rtypes.rint(defaultColor[0]));
        channel.setGreen(rtypes.rint(defaultColor[1]));
        channel.setBlue(rtypes.rint(defaultColor[2]));
        channel.setAlpha(rtypes.rint(defaultColor[3]));
    }

    private void setChannelColor(Channel channel, int index, int[] rgba) {
        if (rgba == null) {
            this.setDefaultChannelColor(channel, index);
            return;
        }
        channel.setRed(rtypes.rint(rgba[0]));
        channel.setGreen(rtypes.rint(rgba[1]));
        channel.setBlue(rtypes.rint(rgba[2]));
        channel.setAlpha(rtypes.rint(rgba[3]));
    }

    private RString getNameFromFilter(Filter filter) {
        if (filter == null) {
            return null;
        }
        TransmittanceRange t = filter.getTransmittanceRange();
        return t == null ? null : rtypes.rstring(String.valueOf(t.getCutIn().getValue()));
    }

    private Integer getValue(RInt value) {
        return value == null ? null : Integer.valueOf(value.getValue());
    }

    private RString getChannelName(ChannelData channelData) {
        Laser laser;
        RString name;
        Iterator<Filter> i;
        LogicalChannel lc = channelData.getLogicalChannel();
        Length value = lc.getEmissionWave();
        if (value != null) {
            return rtypes.rstring(this.getNameFromWavelength(value));
        }
        List<Filter> filters = channelData.getLightPathEmissionFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                name = this.getNameFromFilter(i.next());
                if (name == null) continue;
                return name;
            }
        }
        if ((name = this.getNameFromFilter(channelData.getFilterSetEmissionFilter())) != null) {
            return name;
        }
        LightSource ls = channelData.getLightSource();
        if (ls != null && ls instanceof Laser && (value = (laser = (Laser)ls).getWavelength()) != null) {
            return rtypes.rstring(this.getNameFromWavelength(value));
        }
        value = lc.getExcitationWave();
        if (value != null) {
            return rtypes.rstring(this.getNameFromWavelength(value));
        }
        filters = channelData.getLightPathExcitationFilters();
        if (filters != null) {
            i = filters.iterator();
            while (i.hasNext()) {
                name = this.getNameFromFilter(i.next());
                if (name == null) continue;
                return name;
            }
        }
        return this.getNameFromFilter(channelData.getFilterSetExcitationFilter());
    }

    @Override
    public void process(IObjectContainerStore store) throws ModelException {
        this.store = store;
        this.reader = this.store.getReader();
        if (this.reader == null) {
            this.log.warn("Unexpected null reader.");
            return;
        }
        List<Image> images = store.getSourceObjects(Image.class);
        String[] domains = this.reader.getDomains();
        boolean isGraphicsDomain = false;
        for (String domain : domains) {
            if (!"Graphics".equals(domain)) continue;
            this.log.debug("Images are of the graphics domain.");
            isGraphicsDomain = true;
            break;
        }
        this.log.debug("isGraphicsDomain: " + isGraphicsDomain);
        for (int i = 0; i < images.size(); ++i) {
            ChannelData channelData2;
            Pixels pixels = (Pixels)store.getSourceObject(new LSID(Pixels.class, new int[]{i}));
            if (pixels == null) {
                throw new ModelException("Unable to locate Pixels:" + i);
            }
            int count = 0;
            HashMap<ChannelData, Boolean> m = new HashMap<ChannelData, Boolean>();
            int sizeC = pixels.getSizeC().getValue();
            if (sizeC == 1) {
                channelData2 = ChannelData.fromObjectContainerStore(store, i, 0);
                this.setSingleChannel(channelData2);
            } else {
                for (int c = 0; c < sizeC; ++c) {
                    boolean v;
                    channelData2 = ChannelData.fromObjectContainerStore(store, i, c);
                    boolean hasBFColor = this.hasColor(channelData2.getChannel());
                    this.populateDefault(channelData2, isGraphicsDomain);
                    if (isGraphicsDomain) continue;
                    boolean bl = v = ColorsFactory.hasEmissionData(channelData2) || hasBFColor;
                    if (!v) {
                        ++count;
                    }
                    m.put(channelData2, v);
                }
            }
            if (count <= 0 || count == m.size()) continue;
            for (ChannelData channelData2 : m.keySet()) {
                if (((Boolean)m.get(channelData2)).booleanValue()) continue;
                int[] defaultColor = ColorsFactory.newWhiteColor();
                Channel channel = channelData2.getChannel();
                channel.setRed(rtypes.rint(defaultColor[0]));
                channel.setGreen(rtypes.rint(defaultColor[1]));
                channel.setBlue(rtypes.rint(defaultColor[2]));
                channel.setAlpha(rtypes.rint(defaultColor[3]));
            }
        }
    }
}

