/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.graphs;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ome.api.IQuery;
import ome.io.nio.PixelsService;
import ome.io.nio.ThumbnailService;
import ome.model.IObject;
import ome.parameters.Parameters;
import ome.services.graphs.GraphPathBean;
import ome.services.util.ReadOnlyStatus;
import omero.api.LongPair;
import omero.cmd.DiskUsage;
import omero.cmd.DiskUsageResponse;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.model.OriginalFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DiskUsageI
extends DiskUsage
implements IRequest,
ReadOnlyStatus.IsAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUsageI.class);
    private static final ImmutableMap<String, String> ALL_GROUPS_CONTEXT = ImmutableMap.of((Object)"omero.group", (Object)"-1");
    private static final ImmutableMultimap<String, Map.Entry<String, String>> TRAVERSAL_QUERIES;
    private static final ImmutableSet<String> OWNED_OBJECTS;
    private static final ImmutableSet<String> ANNOTATABLE_OBJECTS;
    private static final Map<String, String> classIdProperties;
    private final PixelsService pixelsService;
    private final ThumbnailService thumbnailService;
    private final GraphPathBean graphPathBean;
    private Helper helper;

    public DiskUsageI(PixelsService pixelsService, ThumbnailService thumbnailService, GraphPathBean graphPathBean) {
        this.pixelsService = pixelsService;
        this.thumbnailService = thumbnailService;
        this.graphPathBean = graphPathBean;
    }

    public ImmutableMap<String, String> getCallContext() {
        return ALL_GROUPS_CONTEXT;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        helper.setSteps(1);
    }

    public DiskUsageResponse step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        if (step != 0) {
            throw this.helper.cancel(new ERR(), (Throwable)new IllegalArgumentException(), "disk usage operation has no step " + step, new String[0]);
        }
        try {
            return this.getDiskUsage();
        }
        catch (HandleI.Cancel c) {
            throw c;
        }
        catch (Throwable t) {
            throw this.helper.cancel(new ERR(), t, "disk usage operation failed", new String[0]);
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (step == 0) {
            this.helper.setResponseIfNull((DiskUsageResponse)((Object)object));
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private static long getFileSize(String path) {
        File file = new File(path);
        return file.exists() ? file.length() : 0L;
    }

    private String getIdPropertyFor(String className) throws HandleI.Cancel {
        String idProperty = classIdProperties.get(className);
        if (idProperty == null) {
            Class<? extends IObject> actualClass = this.graphPathBean.getClassForSimpleName(className);
            if (actualClass == null) {
                IllegalArgumentException e = new IllegalArgumentException("class " + className + " is unknown");
                throw this.helper.cancel(new ERR(), (Throwable)e, "bad-class", new String[0]);
            }
            idProperty = this.graphPathBean.getIdentifierProperty(actualClass.getName());
            if (idProperty == null) {
                IllegalArgumentException e = new IllegalArgumentException("no identifier property is known for class " + className);
                throw this.helper.cancel(new ERR(), (Throwable)e, "bad-class", new String[0]);
            }
            classIdProperties.put(className, idProperty);
        }
        return idProperty;
    }

    /*
     * WARNING - void declaration
     */
    private DiskUsageResponse getDiskUsage() {
        IQuery queryService = this.helper.getServiceFactory().getQueryService();
        int batchSize = 256;
        HashMultimap objectsToProcess = HashMultimap.create();
        HashMultimap objectsProcessed = HashMultimap.create();
        Usage usage = new Usage();
        HashMultimap typesWithFiles = HashMultimap.create();
        HashMap fileSizes = new HashMap();
        for (String string : this.classes) {
            String hql = "SELECT " + this.getIdPropertyFor(string) + " FROM " + string;
            for (Object[] resultRow : queryService.projection(hql, null)) {
                if (resultRow == null) continue;
                Long objectId = (Long)resultRow[0];
                objectsToProcess.put((Object)string, (Object)objectId);
            }
        }
        for (Map.Entry entry : this.objects.entrySet()) {
            objectsToProcess.putAll((Object)((String)entry.getKey()), (Iterable)entry.getValue());
            if (!LOGGER.isDebugEnabled()) continue;
            ArrayList ids = Lists.newArrayList((Iterable)objectsToProcess.get((Object)((String)entry.getKey())));
            Collections.sort(ids);
            LOGGER.debug("size calculator to process " + (String)entry.getKey() + " " + Joiner.on((String)", ").join((Iterable)ids));
        }
        for (String string : objectsToProcess.keySet()) {
            this.getIdPropertyFor(string);
        }
        while (!objectsToProcess.isEmpty()) {
            String hql;
            Long groupId;
            Long ownerId;
            String hql2;
            void var9_18;
            Map.Entry nextClass = objectsToProcess.asMap().entrySet().iterator().next();
            String string = (String)nextClass.getKey();
            int lastDot = string.lastIndexOf(46);
            if (lastDot >= 0) {
                String string2 = string.substring(lastDot + 1);
            } else if (string.charAt(0) == '/') {
                String string3 = string.substring(1);
            }
            Collection ids = (Collection)nextClass.getValue();
            ids.removeAll(objectsProcessed.get((Object)var9_18));
            if (ids.isEmpty()) continue;
            ArrayList idsToQuery = Lists.newArrayList((Iterable)Iterables.limit((Iterable)ids, (int)256));
            ids.removeAll(idsToQuery);
            objectsProcessed.putAll((Object)var9_18, (Iterable)idsToQuery);
            Parameters parameters = new Parameters().addIds((Collection)idsToQuery);
            if ("Pixels".equals(var9_18)) {
                hql2 = "SELECT id, details.owner.id, details.group.id FROM Pixels WHERE id IN (:ids)";
                for (Object[] resultRow : queryService.projection("SELECT id, details.owner.id, details.group.id FROM Pixels WHERE id IN (:ids)", parameters)) {
                    if (resultRow == null) continue;
                    Long pixelsId = (Long)resultRow[0];
                    ownerId = (Long)resultRow[1];
                    groupId = (Long)resultRow[2];
                    String pixelsPath = this.pixelsService.getPixelsPath(pixelsId);
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(pixelsPath));
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(pixelsPath + "_pyramid"));
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(pixelsPath + "_pyramid" + ".pyr_lock"));
                }
            } else if ("Thumbnail".equals(var9_18)) {
                hql2 = "SELECT id, details.owner.id, details.group.id FROM Thumbnail WHERE id IN (:ids)";
                for (Object[] resultRow : queryService.projection("SELECT id, details.owner.id, details.group.id FROM Thumbnail WHERE id IN (:ids)", parameters)) {
                    if (resultRow == null) continue;
                    Long thumbnailId = (Long)resultRow[0];
                    ownerId = (Long)resultRow[1];
                    groupId = (Long)resultRow[2];
                    String thumbnailPath = this.thumbnailService.getThumbnailPath(thumbnailId);
                    usage.bumpTotals().add(ownerId, groupId, (String)var9_18, DiskUsageI.getFileSize(thumbnailPath));
                }
            } else if ("OriginalFile".equals(var9_18)) {
                hql2 = "SELECT id, details.owner.id, details.group.id, size FROM OriginalFile WHERE id IN (:ids)";
                for (Object[] resultRow : queryService.projection("SELECT id, details.owner.id, details.group.id, size FROM OriginalFile WHERE id IN (:ids)", parameters)) {
                    if (resultRow == null || !(resultRow[3] instanceof Long)) continue;
                    Iterator fileId = (Long)resultRow[0];
                    ownerId = (Long)resultRow[1];
                    groupId = (Long)resultRow[2];
                    Long fileSize = (Long)resultRow[3];
                    fileSizes.put(fileId, new OwnershipAndSize(ownerId, groupId, fileSize));
                }
            } else if ("Experimenter".equals(var9_18)) {
                for (String resultClassName : OWNED_OBJECTS) {
                    hql = "SELECT " + this.getIdPropertyFor(resultClassName) + " FROM " + resultClassName + " WHERE details.owner.id IN (:ids)";
                    for (Object[] resultRow : queryService.projection(hql, parameters)) {
                        objectsToProcess.put((Object)resultClassName, (Object)((Long)resultRow[0]));
                    }
                }
            } else if ("ExperimenterGroup".equals(var9_18)) {
                for (String resultClassName : OWNED_OBJECTS) {
                    hql = "SELECT " + this.getIdPropertyFor(resultClassName) + " FROM " + resultClassName + " WHERE details.group.id IN (:ids)";
                    for (Object[] resultRow : queryService.projection(hql, parameters)) {
                        objectsToProcess.put((Object)resultClassName, (Object)((Long)resultRow[0]));
                    }
                }
            }
            for (Map.Entry query : TRAVERSAL_QUERIES.get((Object)var9_18)) {
                String resultClassName = (String)query.getKey();
                String hql3 = (String)query.getValue();
                for (Object[] resultRow : queryService.projection(hql3, parameters)) {
                    if (resultRow == null || !(resultRow[0] instanceof Long)) continue;
                    Long resultId = (Long)resultRow[0];
                    objectsToProcess.put((Object)resultClassName, (Object)resultId);
                    if (!"OriginalFile".equals(resultClassName)) continue;
                    typesWithFiles.put((Object)resultId, (Object)var9_18);
                }
            }
            if (ANNOTATABLE_OBJECTS.contains((Object)var9_18)) {
                hql2 = "SELECT child.id FROM " + (String)var9_18 + "AnnotationLink WHERE parent.id IN (:ids)";
                for (Object[] resultRow : queryService.projection(hql2, parameters)) {
                    objectsToProcess.put((Object)"Annotation", (Object)((Long)resultRow[0]));
                }
            }
            if (!LOGGER.isDebugEnabled()) continue;
            Collections.sort(idsToQuery);
            LOGGER.debug("usage is " + usage + " after processing " + (String)var9_18 + " " + Joiner.on((String)", ").join((Iterable)idsToQuery));
        }
        for (Map.Entry entry : fileSizes.entrySet()) {
            Long fileId = (Long)entry.getKey();
            OwnershipAndSize fileSize = (OwnershipAndSize)entry.getValue();
            Set types = typesWithFiles.get((Object)fileId);
            if (types.isEmpty()) {
                types = ImmutableSet.of((Object)"OriginalFile");
            }
            usage.bumpTotals();
            for (String type : types) {
                usage.add(fileSize.owner, fileSize.group, type, fileSize.size);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("usage is " + usage + " after including " + OriginalFile.class.getSimpleName() + " sizes");
        }
        return usage.getDiskUsageResponse();
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return true;
    }

    static {
        classIdProperties = Collections.synchronizedMap(new HashMap());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)"Project", new AbstractMap.SimpleImmutableEntry<String, String>("Dataset", "SELECT child.id FROM ProjectDatasetLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"Dataset", new AbstractMap.SimpleImmutableEntry<String, String>("Image", "SELECT child.id FROM DatasetImageLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"Folder", new AbstractMap.SimpleImmutableEntry<String, String>("Image", "SELECT child.id FROM FolderImageLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"Folder", new AbstractMap.SimpleImmutableEntry<String, String>("Roi", "SELECT child.id FROM FolderRoiLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"Folder", new AbstractMap.SimpleImmutableEntry<String, String>("Folder", "SELECT id FROM Folder WHERE parentFolder.id IN (:ids)"));
        builder.put((Object)"Screen", new AbstractMap.SimpleImmutableEntry<String, String>("Plate", "SELECT child.id FROM ScreenPlateLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"Plate", new AbstractMap.SimpleImmutableEntry<String, String>("Well", "SELECT id FROM Well WHERE plate.id IN (:ids)"));
        builder.put((Object)"Plate", new AbstractMap.SimpleImmutableEntry<String, String>("PlateAcquisition", "SELECT id FROM PlateAcquisition WHERE plate.id IN (:ids)"));
        builder.put((Object)"PlateAcquisition", new AbstractMap.SimpleImmutableEntry<String, String>("WellSample", "SELECT id FROM WellSample WHERE plateAcquisition.id IN (:ids)"));
        builder.put((Object)"Well", new AbstractMap.SimpleImmutableEntry<String, String>("WellSample", "SELECT id FROM WellSample WHERE well.id IN (:ids)"));
        builder.put((Object)"Well", new AbstractMap.SimpleImmutableEntry<String, String>("Reagent", "SELECT child.id FROM WellReagentLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"WellSample", new AbstractMap.SimpleImmutableEntry<String, String>("Image", "SELECT image.id FROM WellSample WHERE id IN (:ids)"));
        builder.put((Object)"Image", new AbstractMap.SimpleImmutableEntry<String, String>("Pixels", "SELECT id FROM Pixels WHERE image.id IN (:ids)"));
        builder.put((Object)"Pixels", new AbstractMap.SimpleImmutableEntry<String, String>("Thumbnail", "SELECT id FROM Thumbnail WHERE pixels.id IN (:ids)"));
        builder.put((Object)"Pixels", new AbstractMap.SimpleImmutableEntry<String, String>("OriginalFile", "SELECT parent.id FROM PixelsOriginalFileMap WHERE child.id IN (:ids)"));
        builder.put((Object)"Pixels", new AbstractMap.SimpleImmutableEntry<String, String>("Channel", "SELECT id FROM Channel WHERE pixels.id IN (:ids)"));
        builder.put((Object)"Pixels", new AbstractMap.SimpleImmutableEntry<String, String>("PlaneInfo", "SELECT id FROM PlaneInfo WHERE pixels.id IN (:ids)"));
        builder.put((Object)"Channel", new AbstractMap.SimpleImmutableEntry<String, String>("LogicalChannel", "SELECT logicalChannel.id FROM Channel WHERE id IN (:ids)"));
        builder.put((Object)"Image", new AbstractMap.SimpleImmutableEntry<String, String>("Fileset", "SELECT fileset.id FROM Image WHERE id IN (:ids)"));
        builder.put((Object)"Fileset", new AbstractMap.SimpleImmutableEntry<String, String>("Job", "SELECT child.id FROM FilesetJobLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"Job", new AbstractMap.SimpleImmutableEntry<String, String>("OriginalFile", "SELECT child.id FROM JobOriginalFileLink WHERE parent.id IN (:ids)"));
        builder.put((Object)"Fileset", new AbstractMap.SimpleImmutableEntry<String, String>("Image", "SELECT id FROM Image WHERE fileset.id IN (:ids)"));
        builder.put((Object)"Fileset", new AbstractMap.SimpleImmutableEntry<String, String>("FilesetEntry", "SELECT id FROM FilesetEntry WHERE fileset.id IN (:ids)"));
        builder.put((Object)"FilesetEntry", new AbstractMap.SimpleImmutableEntry<String, String>("OriginalFile", "SELECT originalFile.id FROM FilesetEntry WHERE id IN (:ids)"));
        builder.put((Object)"Annotation", new AbstractMap.SimpleImmutableEntry<String, String>("OriginalFile", "SELECT file.id FROM FileAnnotation WHERE id IN (:ids)"));
        builder.put((Object)"Image", new AbstractMap.SimpleImmutableEntry<String, String>("Roi", "SELECT id FROM Roi WHERE image.id IN (:ids)"));
        builder.put((Object)"Roi", new AbstractMap.SimpleImmutableEntry<String, String>("Shape", "SELECT id FROM Shape WHERE roi.id IN (:ids)"));
        builder.put((Object)"Roi", new AbstractMap.SimpleImmutableEntry<String, String>("OriginalFile", "SELECT source.id FROM Roi WHERE id IN (:ids)"));
        builder.put((Object)"Image", new AbstractMap.SimpleImmutableEntry<String, String>("Instrument", "SELECT instrument.id FROM Image WHERE id IN (:ids)"));
        builder.put((Object)"Instrument", new AbstractMap.SimpleImmutableEntry<String, String>("Detector", "SELECT id FROM Detector WHERE instrument.id IN (:ids)"));
        builder.put((Object)"Instrument", new AbstractMap.SimpleImmutableEntry<String, String>("Dichroic", "SELECT id FROM Dichroic WHERE instrument.id IN (:ids)"));
        builder.put((Object)"Instrument", new AbstractMap.SimpleImmutableEntry<String, String>("Filter", "SELECT id FROM Filter WHERE instrument.id IN (:ids)"));
        builder.put((Object)"Instrument", new AbstractMap.SimpleImmutableEntry<String, String>("LightSource", "SELECT id FROM LightSource WHERE instrument.id IN (:ids)"));
        builder.put((Object)"Instrument", new AbstractMap.SimpleImmutableEntry<String, String>("Objective", "SELECT id FROM Objective WHERE instrument.id IN (:ids)"));
        builder.put((Object)"Dichroic", new AbstractMap.SimpleImmutableEntry<String, String>("LightPath", "SELECT id FROM LightPath WHERE dichroic.id IN (:ids)"));
        builder.put((Object)"LogicalChannel", new AbstractMap.SimpleImmutableEntry<String, String>("LightPath", "SELECT lightPath.id FROM LogicalChannel WHERE id IN (:ids)"));
        TRAVERSAL_QUERIES = builder.build();
        builder = ImmutableSet.builder();
        builder.add((Object)"Annotation");
        builder.add((Object)"Channel");
        builder.add((Object)"Dataset");
        builder.add((Object)"Detector");
        builder.add((Object)"Dichroic");
        builder.add((Object)"Fileset");
        builder.add((Object)"Filter");
        builder.add((Object)"Folder");
        builder.add((Object)"Image");
        builder.add((Object)"LogicalChannel");
        builder.add((Object)"Instrument");
        builder.add((Object)"LightPath");
        builder.add((Object)"LightSource");
        builder.add((Object)"Objective");
        builder.add((Object)"OriginalFile");
        builder.add((Object)"Pixels");
        builder.add((Object)"PlaneInfo");
        builder.add((Object)"PlateAcquisition");
        builder.add((Object)"Plate");
        builder.add((Object)"Project");
        builder.add((Object)"Reagent");
        builder.add((Object)"Roi");
        builder.add((Object)"Screen");
        builder.add((Object)"Shape");
        builder.add((Object)"Well");
        builder.add((Object)"WellSample");
        OWNED_OBJECTS = builder.build();
        builder = ImmutableSet.builder();
        builder.add((Object)"Annotation");
        builder.add((Object)"Channel");
        builder.add((Object)"Dataset");
        builder.add((Object)"Detector");
        builder.add((Object)"Dichroic");
        builder.add((Object)"Experimenter");
        builder.add((Object)"ExperimenterGroup");
        builder.add((Object)"Fileset");
        builder.add((Object)"Filter");
        builder.add((Object)"Folder");
        builder.add((Object)"Image");
        builder.add((Object)"Instrument");
        builder.add((Object)"LightPath");
        builder.add((Object)"LightSource");
        builder.add((Object)"Objective");
        builder.add((Object)"OriginalFile");
        builder.add((Object)"PlaneInfo");
        builder.add((Object)"PlateAcquisition");
        builder.add((Object)"Plate");
        builder.add((Object)"Project");
        builder.add((Object)"Reagent");
        builder.add((Object)"Roi");
        builder.add((Object)"Screen");
        builder.add((Object)"Shape");
        builder.add((Object)"Well");
        ANNOTATABLE_OBJECTS = builder.build();
    }

    private static class OwnershipAndSize {
        public final long owner;
        public final long group;
        public final long size;

        OwnershipAndSize(long owner, long group, long size) {
            this.owner = owner;
            this.group = group;
            this.size = size;
        }
    }

    private static class Usage {
        private final Map<LongPair, Map<String, Integer>> countByTypeByWho = new HashMap<LongPair, Map<String, Integer>>();
        private final Map<LongPair, Map<String, Long>> sizeByTypeByWho = new HashMap<LongPair, Map<String, Long>>();
        private final Map<LongPair, Integer> totalCountByWho = new HashMap<LongPair, Integer>();
        private final Map<LongPair, Long> totalSizeByWho = new HashMap<LongPair, Long>();
        private boolean bumpTotals = false;

        private Usage() {
        }

        Usage bumpTotals() {
            this.bumpTotals = true;
            return this;
        }

        void add(long owner, long group, String type, Long size) {
            Map<Object, Object> sizeByType;
            Map<Object, Object> countByType;
            if (size <= 0L) {
                this.bumpTotals = false;
                return;
            }
            LongPair ownership = new LongPair(owner, group);
            if (this.countByTypeByWho.containsKey(ownership)) {
                countByType = this.countByTypeByWho.get(ownership);
                sizeByType = this.sizeByTypeByWho.get(ownership);
            } else {
                countByType = new HashMap();
                sizeByType = new HashMap();
                this.countByTypeByWho.put(ownership, countByType);
                this.sizeByTypeByWho.put(ownership, sizeByType);
            }
            Long sizeThisType = (Long)sizeByType.get(type);
            if (sizeThisType == null) {
                countByType.put(type, 1);
                sizeByType.put(type, size);
            } else {
                countByType.put(type, (Integer)countByType.get(type) + 1);
                sizeByType.put(type, sizeThisType + size);
            }
            if (this.bumpTotals) {
                Integer totalCount = this.totalCountByWho.get(ownership);
                Long totalSize = this.totalSizeByWho.get(ownership);
                if (totalCount == null) {
                    totalCount = 0;
                }
                if (totalSize == null) {
                    totalSize = 0L;
                }
                Integer n = totalCount;
                Integer n2 = totalCount = Integer.valueOf(totalCount + 1);
                totalSize = totalSize + size;
                this.totalCountByWho.put(ownership, totalCount);
                this.totalSizeByWho.put(ownership, totalSize);
                this.bumpTotals = false;
            }
        }

        public DiskUsageResponse getDiskUsageResponse() {
            return new DiskUsageResponse(this.countByTypeByWho, this.sizeByTypeByWho, this.totalCountByWho, this.totalSizeByWho);
        }

        private String toString(Map<LongPair, ?> byWho) {
            ArrayList<String> asStrings = new ArrayList<String>(byWho.size());
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<LongPair, ?> entry : byWho.entrySet()) {
                sb.setLength(0);
                sb.append(entry.getKey().first);
                sb.append('/');
                sb.append(entry.getKey().second);
                sb.append('=');
                sb.append(entry.getValue());
                asStrings.add(sb.toString());
            }
            return Joiner.on((String)", ").join(asStrings);
        }

        public String toString() {
            return "files = [" + this.toString(this.totalCountByWho) + "], bytes = [" + this.toString(this.totalSizeByWho) + "]";
        }
    }
}

