/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd.mail;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ome.api.IQuery;
import ome.api.local.LocalAdmin;
import ome.model.meta.Experimenter;
import ome.parameters.Parameters;
import ome.services.mail.MailUtil;
import ome.services.util.ReadOnlyStatus;
import ome.system.EventContext;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Helper;
import omero.cmd.IRequest;
import omero.cmd.Response;
import omero.cmd.SendEmailRequest;
import omero.cmd.SendEmailResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;

public class SendEmailRequestI
extends SendEmailRequest
implements IRequest,
ReadOnlyStatus.IsAware {
    private static final Logger log = LoggerFactory.getLogger(SendEmailRequestI.class);
    private static final long serialVersionUID = -1L;
    private final SendEmailResponse rsp = new SendEmailResponse();
    private String sender = null;
    private List<String> recipients = new ArrayList<String>();
    private final MailUtil mailUtil;
    private Helper helper;

    public SendEmailRequestI(MailUtil mailUtil) {
        this.mailUtil = mailUtil;
    }

    @Override
    public Map<String, String> getCallContext() {
        HashMap<String, String> all = new HashMap<String, String>();
        all.put("omero.group", "-1");
        return all;
    }

    @Override
    public void init(Helper helper) {
        this.helper = helper;
        EventContext ec = ((LocalAdmin)helper.getServiceFactory().getAdminService()).getEventContextQuiet();
        if (!ec.isCurrentUserAdmin()) {
            throw helper.cancel(new ERR(), null, "no-permissions", "ApiUsageException", String.format("You have no permissions to send email.", new Object[0]));
        }
        this.rsp.invalidusers = new ArrayList<Long>();
        this.rsp.invalidemails = new ArrayList<String>();
        if (!this.everyone && this.groupIds.isEmpty() && this.userIds.isEmpty()) {
            throw helper.cancel(new ERR(), null, "no-body", "ApiUsageException", String.format("No recipients specified.", new Object[0]));
        }
        this.sender = this.mailUtil.getSender();
        if (StringUtils.isBlank((String)this.sender)) {
            throw helper.cancel(new ERR(), null, "no-sender", "ApiUsageException", String.format("omero.mail.from cannot be empty.", new Object[0]));
        }
        if (StringUtils.isBlank((String)this.subject)) {
            throw helper.cancel(new ERR(), null, "no-subject", "ApiUsageException", String.format("Email must contain subject.", new Object[0]));
        }
        if (StringUtils.isBlank((String)this.body)) {
            throw helper.cancel(new ERR(), null, "no-body", "ApiUsageException", String.format("Email must contain body.", new Object[0]));
        }
        this.recipients = this.parseRecipients();
        this.recipients.addAll(this.parseExtraRecipients());
        this.rsp.total = this.recipients.size();
        this.rsp.success = 0L;
        if (this.recipients.isEmpty()) {
            this.helper.setSteps(1);
        } else {
            this.helper.setSteps(this.recipients.size());
        }
    }

    @Override
    public Object step(int step) throws HandleI.Cancel {
        this.helper.assertStep(step);
        try {
            this.recipients.get(step);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        String email = this.recipients.get(step);
        try {
            this.mailUtil.sendEmail(this.sender, email, this.subject, this.body, this.html, null, null);
        }
        catch (MailException me) {
            log.error(me.getMessage());
            this.rsp.invalidemails.add(email);
        }
        ++this.rsp.success;
        return null;
    }

    @Override
    public void finish() throws HandleI.Cancel {
    }

    @Override
    public void buildResponse(int step, Object object) {
        this.helper.assertResponse(step);
        if (this.helper.isLast(step)) {
            this.helper.setResponseIfNull(this.rsp);
        }
    }

    @Override
    public Response getResponse() {
        return this.helper.getResponse();
    }

    private List<String> parseRecipients() {
        Parameters p = new Parameters();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct e from Experimenter e left outer join fetch e.groupExperimenterMap m left outer join fetch m.parent g where 1=1 ");
        if (!this.inactive) {
            sql.append(" and g.id = :active ");
            p.addLong("active", Long.valueOf(this.helper.getServiceFactory().getAdminService().getSecurityRoles().getUserGroupId()));
        }
        if (!this.everyone) {
            if (this.groupIds.size() > 0) {
                sql.append(" and e.id in ");
                sql.append(" (select m.child from GroupExperimenterMap m  where m.parent.id in (:gids) )");
                p.addSet("gids", new HashSet(this.groupIds));
            }
            if (this.userIds.size() > 0) {
                if (this.groupIds.size() > 0) {
                    sql.append(" or ");
                } else {
                    sql.append(" and ");
                }
                sql.append(" e.id in (:eids)");
                p.addSet("eids", new HashSet(this.userIds));
            }
        }
        IQuery iquery = this.helper.getServiceFactory().getQueryService();
        List exps = iquery.findAllByQuery(sql.toString(), p);
        HashSet<String> recipients = new HashSet<String>();
        for (Experimenter e : exps) {
            if (e.getEmail() != null && this.mailUtil.validateEmail(e.getEmail())) {
                recipients.add(e.getEmail());
                continue;
            }
            this.rsp.invalidusers.add(e.getId());
        }
        return new ArrayList<String>(recipients);
    }

    private List<String> parseExtraRecipients() {
        HashSet<String> extraRecipients = new HashSet<String>();
        for (String e : this.extra) {
            if (this.mailUtil.validateEmail(e)) {
                extraRecipients.add(e);
                continue;
            }
            this.rsp.invalidemails.add(e);
        }
        return new ArrayList<String>(extraRecipients);
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return true;
    }
}

