/*
 * Decompiled with CFR 0.152.
 */
package omero.util;

import omero.util.TileData;
import omero.util.TileLoopIteration;

public abstract class TileLoop {
    public abstract TileData createData();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forEachTile(int sizeX, int sizeY, int sizeZ, int sizeC, int sizeT, int tileWidth, int tileHeight, TileLoopIteration iteration) {
        try (TileData data = this.createData();){
            int tileCount = 0;
            for (int t = 0; t < sizeT; ++t) {
                for (int c = 0; c < sizeC; ++c) {
                    for (int z = 0; z < sizeZ; ++z) {
                        for (int tileOffsetY = 0; tileOffsetY < (sizeY + tileHeight - 1) / tileHeight; ++tileOffsetY) {
                            for (int tileOffsetX = 0; tileOffsetX < (sizeX + tileWidth - 1) / tileWidth; ++tileOffsetX) {
                                int h;
                                int x = tileOffsetX * tileWidth;
                                int y = tileOffsetY * tileHeight;
                                int w = tileWidth;
                                if (w + x > sizeX) {
                                    w = sizeX - x;
                                }
                                if ((h = tileHeight) + y > sizeY) {
                                    h = sizeY - y;
                                }
                                iteration.run(data, z, c, t, x, y, w, h, tileCount);
                                ++tileCount;
                            }
                        }
                    }
                }
            }
            int n = tileCount;
            return n;
        }
    }
}

