/*
 * Decompiled with CFR 0.152.
 */
package ome.security;

import java.util.Set;
import ome.model.IObject;
import ome.security.ACLVoter;
import ome.tools.hibernate.HibernateUtils;
import org.hibernate.Session;
import org.hibernate.event.PostDeleteEvent;
import org.hibernate.event.PostDeleteEventListener;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PostLoadEvent;
import org.hibernate.event.PostLoadEventListener;
import org.hibernate.event.PostUpdateEvent;
import org.hibernate.event.PostUpdateEventListener;
import org.hibernate.event.PreDeleteEvent;
import org.hibernate.event.PreDeleteEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.event.PreLoadEventListener;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLEventListener
implements PreDeleteEventListener,
PreInsertEventListener,
PreLoadEventListener,
PreUpdateEventListener,
PostDeleteEventListener,
PostInsertEventListener,
PostLoadEventListener,
PostUpdateEventListener {
    private static final long serialVersionUID = 3603644089117965153L;
    private static Logger log = LoggerFactory.getLogger(ACLEventListener.class);
    private final ACLVoter aclVoter;

    public ACLEventListener(ACLVoter aclVoter) {
        this.aclVoter = aclVoter;
    }

    public void onPostDelete(PostDeleteEvent event) {
    }

    public void onPostInsert(PostInsertEvent event) {
    }

    public void onPostUpdate(PostUpdateEvent event) {
    }

    public void onPreLoad(PreLoadEvent event) {
    }

    public void onPostLoad(PostLoadEvent event) {
        Object entity = event.getEntity();
        if (entity instanceof IObject) {
            IObject o = (IObject)entity;
            if (!this.aclVoter.allowLoad((Session)event.getSession(), o.getClass(), o.getDetails(), o.getId())) {
                this.aclVoter.throwLoadViolation(o);
            }
            Set<String> restrictions = this.aclVoter.restrictions(o);
            ((IObject)entity).getDetails().getPermissions().addExtendedRestrictions(restrictions);
        }
    }

    public boolean onPreInsert(PreInsertEvent event) {
        IObject obj;
        Object entity = event.getEntity();
        if (entity instanceof IObject && !this.aclVoter.allowCreation(obj = (IObject)entity)) {
            this.aclVoter.throwCreationViolation(obj);
        }
        return false;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        IObject obj;
        Object entity = event.getEntity();
        Object[] state = event.getOldState();
        String[] names = event.getPersister().getPropertyNames();
        if (entity instanceof IObject && !this.aclVoter.allowUpdate(obj = (IObject)entity, HibernateUtils.getDetails(state, names))) {
            this.aclVoter.throwUpdateViolation(obj);
        }
        return false;
    }

    public boolean onPreDelete(PreDeleteEvent event) {
        IObject obj;
        Object entity = event.getEntity();
        Object[] state = event.getDeletedState();
        String[] names = event.getPersister().getPropertyNames();
        if (entity instanceof IObject && !this.aclVoter.allowDelete(obj = (IObject)entity, HibernateUtils.getDetails(state, names))) {
            this.aclVoter.throwDeleteViolation(obj);
        }
        return false;
    }
}

