/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import ome.conditions.ApiUsageException;
import ome.conditions.InternalException;
import ome.conditions.SessionTimeoutException;
import ome.logic.HardWiredInterceptor;
import ome.security.MethodSecurity;
import ome.security.basic.BasicEventContext;
import ome.security.basic.PrincipalHolder;
import ome.services.sessions.stats.DelegatingStats;
import ome.system.Principal;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicSecurityWiring
extends HardWiredInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BasicSecurityWiring.class);
    protected PrincipalHolder principalHolder;
    protected MethodSecurity methodSecurity;

    @Override
    public String getName() {
        return "securityWiring";
    }

    public void setPrincipalHolder(PrincipalHolder principalHolder) {
        this.principalHolder = principalHolder;
    }

    public void setMethodSecurity(MethodSecurity security) {
        this.methodSecurity = security;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation mi) throws Throwable {
        Principal p = this.getPrincipal(mi);
        boolean hp = this.hasPassword(mi);
        boolean close = "close".equals(mi.getMethod().getName());
        if (!close && this.methodSecurity.isActive()) {
            this.methodSecurity.checkMethod(mi.getThis(), mi.getMethod(), p, hp);
        }
        try {
            this.login(mi, p);
        }
        catch (SessionTimeoutException ste) {
            if (!close) {
                throw ste;
            }
            log.warn("SessionTimeoutException on close:" + p);
            this.principalHolder.login(new CloseOnNoSessionContext());
        }
        try {
            Object object = mi.proceed();
            return object;
        }
        finally {
            this.logout();
        }
    }

    private void login(MethodInvocation mi, Principal p) {
        if (p == null) {
            throw new ApiUsageException("ome.system.Principal instance must be provided on login.");
        }
        int size = this.principalHolder.size();
        if (size > 0) {
            throw new InternalException("SecuritySystem is still active on login. " + size + " logins remaining in thread.");
        }
        this.principalHolder.login(p);
        if (log.isDebugEnabled()) {
            log.debug("Running with user: " + p.getName());
        }
    }

    private void logout() {
        int size = this.principalHolder.logout();
        if (size > 0) {
            log.error("SecuritySystem is still active on logout. " + size + " logins remaining in thread.");
        }
    }

    public static class CloseOnNoSessionContext
    extends BasicEventContext {
        public CloseOnNoSessionContext() {
            super(new Principal(""), new DelegatingStats());
        }
    }
}

