/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ome.annotations.RolesAllowed;
import ome.api.IDelete;
import ome.api.ServiceInterface;
import ome.api.local.LocalAdmin;
import ome.conditions.ApiUsageException;
import ome.conditions.SecurityViolation;
import ome.conditions.ValidationException;
import ome.logic.AbstractLevel2Service;
import ome.model.IObject;
import ome.model.annotations.ImageAnnotationLink;
import ome.model.containers.DatasetImageLink;
import ome.model.core.Channel;
import ome.model.core.Image;
import ome.model.core.LogicalChannel;
import ome.model.core.Pixels;
import ome.model.display.ChannelBinding;
import ome.model.display.RenderingDef;
import ome.model.internal.Details;
import ome.model.screen.Plate;
import ome.parameters.Parameters;
import ome.security.AdminAction;
import ome.services.delete.QueryConstraints;
import ome.services.delete.UnloadedCollector;
import ome.system.EventContext;
import ome.tools.hibernate.SessionFactory;
import ome.util.CBlock;
import org.hibernate.Query;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DeleteBean
extends AbstractLevel2Service
implements IDelete {
    public static final Logger log = LoggerFactory.getLogger(DeleteBean.class);
    public static final String IMAGE_QUERY = "select i from Image as i left outer join fetch i.pixels as p left outer join fetch p.channels as c left outer join fetch c.logicalChannel as lc left outer join fetch lc.channels as c2 left outer join fetch c.statsInfo as sinfo left outer join fetch p.planeInfo as pinfo left outer join fetch p.thumbnails as thumb left outer join fetch p.pixelsFileMaps as map left outer join fetch map.parent as ofile left outer join fetch p.settings as setting where i.id = :id";
    public static final String SETTINGSID_QUERY = "select r.id, q.id from RenderingDef r join r.quantization q join r.pixels pix join pix.image img where img.id = :id";
    public static final String CHANNELID_QUERY = "select ch.id, si.id, lc.id from Channel ch join ch.statsInfo si join ch.logicalChannel lc join ch.pixels.image img where img.id = :id";
    public static final String PLATEIMAGES_QUERY = "select i.id from Image i join i.wellSamples ws join ws.well w join w.plate p where p.id = :id";
    protected final LocalAdmin admin;
    protected final SessionFactory sf;

    public final Class<? extends ServiceInterface> getServiceInterface() {
        return IDelete.class;
    }

    public DeleteBean(LocalAdmin admin, SessionFactory sf) {
        this.admin = admin;
        this.sf = sf;
    }

    @RolesAllowed(value={"user"})
    public List<IObject> checkImageDelete(long id, boolean force) {
        QueryConstraints constraints = new QueryConstraints(this.admin, this.iQuery, id, force);
        this.sec.runAsAdmin(constraints);
        return constraints.getResults();
    }

    @RolesAllowed(value={"user"})
    public List<IObject> previewImageDelete(long id, boolean force) {
        UnloadedCollector delete = new UnloadedCollector(this.iQuery, this.admin, false);
        Image[] holder = new Image[1];
        this.getImageAndCount(holder, id, delete);
        return delete.list;
    }

    @RolesAllowed(value={"user"})
    public void deleteImage(long id, boolean force) throws SecurityViolation, ValidationException {
        List<IObject> constraints = this.checkImageDelete(id, force);
        if (constraints.size() > 0) {
            throw new ApiUsageException("Image has following constraints and cannot be deleted:" + constraints + "\nIt is possible to check for a non-empty constraints list via checkImageDelete.");
        }
        final Image i = (Image)this.iQuery.get(Image.class, id);
        this.throwSecurityViolationIfNotAllowed((IObject)i);
        final Session session = this.sf.getSession();
        session.clear();
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                DeleteBean.this.clearRois(session, i);
            }
        });
        this.execute(session, id, "update Pixels set relatedTo = null where id in(select p.id from Pixels p where p.relatedTo.image.id = :id)");
        this.execute(session, id, "delete PixelsOriginalFileMap where id in(select m.id from PixelsOriginalFileMap m where m.child.image.id = :id)");
        this.execute(session, id, "delete PlaneInfo where id in (select pi.id from PlaneInfo pi where pi.pixels.image.id = :id)");
        this.deleteSettings(id);
        this.deleteChannels(id);
        this.execute(session, id, "delete Thumbnail where id in (select tb.id from Thumbnail tb where tb.pixels.image.id = :id)");
        this.execute(session, id, "delete Pixels where id in (select pix.id from Pixels pix where pix.image.id = :id)");
        this.execute(session, id, "delete ImageAnnotationLink where id in (select link.id from ImageAnnotationLink link where link.parent.id = :id)");
        this.execute(session, id, "delete DatasetImageLink where id in (select link.id from DatasetImageLink link where link.child.id = :id)");
        this.execute(session, id, "delete Image img where img.id = :id");
        session.clear();
    }

    private int execute(Session session, long id, String str) {
        Query q = session.createQuery(str);
        q.setParameter("id", (Object)id);
        return q.executeUpdate();
    }

    @RolesAllowed(value={"user"})
    public void deleteImages(Set<Long> ids, boolean force) throws SecurityViolation, ValidationException, ApiUsageException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        for (Long id : ids) {
            try {
                this.deleteImage(id, force);
            }
            catch (SecurityViolation sv) {
                throw new SecurityViolation("Error while deleting image " + id + "\n" + sv.getMessage());
            }
            catch (ValidationException ve) {
                throw new ValidationException("Error while deleting image " + id + "\n" + ve.getMessage());
            }
            catch (ApiUsageException aue) {
                throw new ApiUsageException("Error while deleting image " + id + "\n" + aue.getMessage());
            }
        }
    }

    @RolesAllowed(value={"user"})
    public void deleteImagesByDataset(long datasetId, boolean force) throws SecurityViolation, ValidationException, ApiUsageException {
        List links = this.iQuery.projection("select link.id, c.id from DatasetImageLink link join link.parent p join link.child c where p.id = :id", new Parameters().addId(Long.valueOf(datasetId)));
        HashSet<Long> ids = new HashSet<Long>();
        for (Object[] link_child : links) {
            ids.add((Long)link_child[1]);
            this.iUpdate.deleteObject((IObject)new DatasetImageLink((Long)link_child[0], false));
        }
        this.deleteImages(ids, force);
    }

    @RolesAllowed(value={"user"})
    public void deleteSettings(final long imageId) {
        Image i = (Image)this.iQuery.get(Image.class, imageId);
        this.throwSecurityViolationIfNotAllowed((IObject)i);
        final Session session = this.sf.getSession();
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                List rdefs = DeleteBean.this.iQuery.projection(DeleteBean.SETTINGSID_QUERY, new Parameters().addId(Long.valueOf(imageId)));
                for (Object[] rv : rdefs) {
                    Long rid = (Long)rv[0];
                    Long qid = (Long)rv[1];
                    Query q = session.createQuery("delete ChannelBinding cb where cb.renderingDef.id = :rid");
                    q.setParameter("rid", (Object)rid);
                    q.executeUpdate();
                    q = session.createQuery("delete RenderingDef r where r.id = :rid");
                    q.setParameter("rid", (Object)rid);
                    q.executeUpdate();
                    q = session.createQuery("delete QuantumDef q where q.id = :qid");
                    q.setParameter("qid", (Object)qid);
                    q.executeUpdate();
                }
            }
        });
    }

    @RolesAllowed(value={"user"})
    public void deleteChannels(final long imageId) {
        Image i = (Image)this.iQuery.get(Image.class, imageId);
        this.throwSecurityViolationIfNotAllowed((IObject)i);
        final Session session = this.sf.getSession();
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                List channels = DeleteBean.this.iQuery.projection(DeleteBean.CHANNELID_QUERY, new Parameters().addId(Long.valueOf(imageId)));
                for (Object[] rv : channels) {
                    Long chid = (Long)rv[0];
                    Long siid = (Long)rv[1];
                    Long lcid = (Long)rv[2];
                    DeleteBean.this.execute(session, chid, "delete Channel ch where ch.id = :id");
                    DeleteBean.this.execute(session, siid, "delete StatsInfo si where si.id = :id");
                    List remainingChannels = DeleteBean.this.iQuery.projection("select ch.id from LogicalChannel lc join lc.channels ch where lc.id = :id", new Parameters().addId(lcid));
                    if (remainingChannels.size() != 0) continue;
                    DeleteBean.this.execute(session, lcid, "delete LogicalChannel lc where lc.id = :id");
                }
            }
        });
    }

    @RolesAllowed(value={"user"})
    public void deletePlate(final long plateId) {
        Plate p = (Plate)this.iQuery.get(Plate.class, plateId);
        this.throwSecurityViolationIfNotAllowed((IObject)p);
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                int count;
                Query q;
                List imagesOnPlate = DeleteBean.this.iQuery.projection(DeleteBean.PLATEIMAGES_QUERY, new Parameters().addId(Long.valueOf(plateId)));
                Session session = DeleteBean.this.sf.getSession();
                StringBuilder sb = new StringBuilder();
                sb.append("Delete for plate ");
                sb.append(plateId);
                sb.append(" : ");
                if (imagesOnPlate.size() > 0) {
                    HashSet<Long> imageIdsForPlate = new HashSet<Long>();
                    for (Object[] objs : imagesOnPlate) {
                        imageIdsForPlate.add((Long)objs[0]);
                    }
                    sb.append(imageIdsForPlate.size());
                    sb.append(" Image(s); ");
                    q = session.createQuery("delete WellSample where image.id in (:ids)");
                    q.setParameterList("ids", imageIdsForPlate);
                    count = q.executeUpdate();
                    sb.append(count);
                    sb.append(" WellSample(s); ");
                    DeleteBean.this.deleteImages(imageIdsForPlate, true);
                }
                q = session.createQuery("delete WellAnnotationLink where parent.id in (select id from Well where plate.id = :id)");
                q.setParameter("id", (Object)plateId);
                count = q.executeUpdate();
                sb.append(count);
                sb.append(" WellAnnotationLink(s);");
                q = session.createQuery("delete Well where plate.id = :id");
                q.setParameter("id", (Object)plateId);
                count = q.executeUpdate();
                sb.append(count);
                sb.append(" Well(s);");
                q = session.createQuery("delete PlateAnnotationLink where parent.id = :id");
                q.setParameter("id", (Object)plateId);
                count = q.executeUpdate();
                sb.append(count);
                sb.append(" PlateAnnotationLink(s);");
                q = session.createQuery("delete ScreenPlateLink where child.id = :id");
                q.setParameter("id", (Object)plateId);
                count = q.executeUpdate();
                sb.append(count);
                sb.append(" ScreenPlateLink(s);");
                q = session.createQuery("delete Plate where id = :id");
                q.setParameter("id", (Object)plateId);
                q.executeUpdate();
                DeleteBean.this.iUpdate.flush();
                log.info(sb.toString());
            }
        });
    }

    protected void getImageAndCount(final Image[] images, final long id, final UnloadedCollector delete) {
        this.sec.runAsAdmin(new AdminAction(){

            @Override
            public void runAsAdmin() {
                images[0] = (Image)DeleteBean.this.iQuery.findByQuery(DeleteBean.IMAGE_QUERY, new Parameters().addId(Long.valueOf(id)));
                if (images[0] == null) {
                    throw new ApiUsageException("Cannot find image: " + id);
                }
                DeleteBean.this.collect(delete, images[0]);
            }
        });
    }

    protected void collect(final UnloadedCollector delete, Image i) {
        i.collectPixels((CBlock)new CBlock<Pixels>(){

            public Pixels call(IObject object) {
                if (object == null) {
                    return null;
                }
                Pixels p = (Pixels)object;
                p.eachLinkedOriginalFile((CBlock)delete);
                p.collectPlaneInfo((CBlock)delete);
                for (RenderingDef rdef : p.collectSettings((CBlock)null)) {
                    for (ChannelBinding binding : rdef.unmodifiableWaveRendering()) {
                        delete.call((IObject)binding);
                    }
                    delete.call((IObject)rdef);
                    delete.call((IObject)rdef.getQuantization());
                }
                p.collectThumbnails((CBlock)delete);
                List channels = p.collectChannels((CBlock)null);
                for (int i = 0; i < channels.size(); ++i) {
                    Channel channel = channels.set(i, null);
                    delete.call((IObject)channel);
                    delete.call((IObject)channel.getStatsInfo());
                    LogicalChannel lc = channel.getLogicalChannel();
                    if (lc.sizeOfChannels() >= 2) continue;
                    delete.call((IObject)lc);
                }
                delete.call((IObject)p);
                return null;
            }
        });
        for (DatasetImageLink link : i.collectDatasetLinks((CBlock)null)) {
            i.removeDatasetImageLink(link, true);
            delete.call((IObject)link);
        }
        for (DatasetImageLink link : i.collectAnnotationLinks((CBlock)null)) {
            i.removeImageAnnotationLink((ImageAnnotationLink)link, true);
            delete.call((IObject)link);
        }
        delete.call((IObject)i);
    }

    private void throwSecurityViolationIfNotAllowed(IObject i) {
        String type = i.getClass().getName();
        Details d = i.getDetails();
        long user = d.getOwner().getId();
        long group = d.getGroup().getId();
        EventContext ec = this.getSecuritySystem().getEventContext();
        boolean root = ec.isCurrentUserAdmin();
        List leaderof = ec.getLeaderOfGroupsList();
        boolean pi = leaderof.contains(group);
        boolean own = ec.getCurrentUserId().equals(user);
        if (!(own || root || pi)) {
            if (log.isWarnEnabled()) {
                log.warn(String.format("User %d attempted to delete " + type + " %d belonging to User %d", ec.getCurrentUserId(), i.getId(), user));
            }
            throw new SecurityViolation(String.format("User %s cannot delete %s %d ", ec.getCurrentUserName(), type, i.getId()));
        }
    }

    private void clearRois(Session session, Image i) {
        int shapeCount = this.execute(session, i.getId(), "delete from Shape where roi.id in (select id from Roi roi where roi.image.id = :id)");
        int roiAnnCount = this.execute(session, i.getId(), "delete from RoiAnnotationLink where parent.id in (select id from Roi roi where roi.image.id = :id)");
        int roiCount = this.execute(session, i.getId(), "delete from Roi where image.id = :id");
        if (shapeCount > 0 || roiAnnCount > 0 || roiCount > 0) {
            log.info(String.format("Roi delete for image %s : %s rois, %s shapes, %s annotations", i.getId(), roiCount, shapeCount, roiAnnCount));
        }
    }
}

