/*
 * Decompiled with CFR 0.152.
 */
package ome.services.delete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ome.api.local.LocalAdmin;
import ome.api.local.LocalQuery;
import ome.model.IObject;
import ome.util.CBlock;
import ome.util.Utils;

class UnloadedCollector
implements CBlock {
    protected final boolean count;
    protected final LocalQuery query;
    protected final LocalAdmin admin;
    final List<IObject> list = new ArrayList<IObject>();
    final Map<String, Map<Long, Map<String, Long>>> map = new HashMap<String, Map<Long, Map<String, Long>>>();

    public UnloadedCollector(LocalQuery query, LocalAdmin admin, boolean count) {
        this.query = query;
        this.admin = admin;
        this.count = count;
    }

    public void addAll(List<IObject> list) {
        for (IObject object : list) {
            this.call(object);
        }
    }

    public Object call(IObject object) {
        if (object == null) {
            return null;
        }
        IObject copy = Utils.trueInstance(object.getClass());
        copy.setId(object.getId());
        copy.unload();
        this.list.add(copy);
        if (this.count) {
            this.count(object);
        }
        return null;
    }

    void count(IObject object) {
        Map<Long, Map<String, Long>> id_class_id = this.map.get(object.getClass().getName());
        if (id_class_id == null) {
            id_class_id = new HashMap<Long, Map<String, Long>>();
            this.map.put(object.getClass().getName(), id_class_id);
        }
        if (!id_class_id.containsKey(object.getId())) {
            id_class_id.put(object.getId(), this.admin.getLockingIds(object.getClass(), object.getId(), null));
        }
    }
}

