/*
 * Decompiled with CFR 0.152.
 */
package ome.services.graphs;

import com.google.common.collect.ImmutableMap;
import ome.model.IObject;
import ome.services.graphs.GraphException;
import ome.services.graphs.GraphPolicy;
import ome.services.graphs.GraphPolicyRulePredicate;
import ome.system.Roles;
import org.hibernate.Session;

public class GroupPredicate
implements GraphPolicyRulePredicate {
    private static ImmutableMap<String, GroupMarker> groupsByName = ImmutableMap.of((Object)"system", (Object)((Object)GroupMarker.SYSTEM), (Object)"user", (Object)((Object)GroupMarker.USER), (Object)"guest", (Object)((Object)GroupMarker.GUEST));
    private final ImmutableMap<Long, GroupMarker> groupsById;

    public GroupPredicate(Roles securityRoles) {
        this.groupsById = ImmutableMap.of((Object)securityRoles.getSystemGroupId(), (Object)((Object)GroupMarker.SYSTEM), (Object)securityRoles.getUserGroupId(), (Object)((Object)GroupMarker.USER), (Object)securityRoles.getGuestGroupId(), (Object)((Object)GroupMarker.GUEST));
    }

    @Override
    public String getName() {
        return "group";
    }

    @Override
    public void noteDetails(Session session, IObject object, String realClass, long id) {
    }

    @Override
    public boolean isMatch(GraphPolicy.Details object, String parameter) throws GraphException {
        boolean isInvert;
        if (object.groupId == null) {
            return false;
        }
        if (parameter.startsWith("!")) {
            parameter = parameter.substring(1);
            isInvert = true;
        } else {
            isInvert = false;
        }
        GroupMarker sought = (GroupMarker)((Object)groupsByName.get((Object)parameter));
        if (sought == null) {
            throw new GraphException("unknown group: " + parameter);
        }
        GroupMarker actual = (GroupMarker)((Object)this.groupsById.get((Object)object.groupId));
        return isInvert != (sought == actual);
    }

    private static enum GroupMarker {
        SYSTEM,
        USER,
        GUEST;

    }
}

