/*
 * Decompiled with CFR 0.152.
 */
package ome.tools.hibernate;

import java.sql.DatabaseMetaData;
import java.util.List;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlDialectFactoryImpl;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.DatabaseMetaDataCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public class SqlQueryTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlQueryTransformer.class);
    private static final String MARKER_COMMENT = "securestring*/";
    private static final Pattern WHERE_PATTERN = Pattern.compile("\\bWHERE\\b", 2);
    private final SqlParser.Config parserConfiguration;
    private final ThreadLocal<String> transformFrom = new ThreadLocal();
    private final ThreadLocal<String> transformTo = new ThreadLocal();

    public SqlQueryTransformer() {
        this(AnsiSqlDialect.DEFAULT);
    }

    public SqlQueryTransformer(DataSource dataSource) throws MetaDataAccessException {
        this((SqlDialect)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (DatabaseMetaDataCallback)new DatabaseMetaDataCallback(){

            public Object processMetaData(DatabaseMetaData metadata) {
                return SqlDialectFactoryImpl.INSTANCE.create(metadata);
            }
        }));
    }

    private SqlQueryTransformer(SqlDialect dialect) {
        this.parserConfiguration = dialect.configureParser(SqlParser.configBuilder()).build();
    }

    public String transformQuery(String sql) {
        int markerIndex = sql.lastIndexOf(MARKER_COMMENT);
        if (markerIndex == -1 || !WHERE_PATTERN.matcher(sql).region(0, markerIndex).find()) {
            return sql;
        }
        if (sql.equals(this.transformFrom.get())) {
            LOGGER.debug("SQL cache hit");
            return this.transformTo.get();
        }
        this.transformFrom.set(sql);
        LOGGER.debug("SQL to parse: {}", (Object)sql);
        sql = sql.replaceAll("_\\.([a-z]+) as\\b", "_.\"$1\" as");
        try {
            SqlParser parser = SqlParser.create((String)sql, (SqlParser.Config)this.parserConfiguration);
            Transformer transformer = new Transformer(sql);
            parser.parseQuery().accept((SqlVisitor)transformer);
            sql = transformer.toString();
            LOGGER.debug("SQL transformed: {}", (Object)sql);
        }
        catch (SqlParseException spe) {
            LOGGER.warn("failed to parse SQL", (Throwable)spe);
        }
        this.transformTo.set(sql);
        return sql;
    }

    private class Transformer
    extends SqlBasicVisitor<SqlNode> {
        private final String original;
        private final StringBuilder transformed;

        Transformer(String sql) {
            this.original = sql;
            this.transformed = new StringBuilder(sql);
        }

        private int getIndex(SqlNode node) {
            SqlParserPos parserPosition = node.getParserPosition();
            return SqlParserUtil.lineColToIndex((String)this.original, (int)parserPosition.getLineNum(), (int)parserPosition.getColumnNum());
        }

        public SqlNode visit(SqlCall call) {
            int secondIndex;
            int matchIndex;
            SqlBasicCall basicCall;
            List operands;
            if (call instanceof SqlSelect) {
                SqlSelect selectCall = (SqlSelect)call;
                if (selectCall.hasWhere()) {
                    selectCall.getWhere().accept((SqlVisitor)this);
                }
                return null;
            }
            if (call instanceof SqlBasicCall && (operands = (basicCall = (SqlBasicCall)call).getOperandList()).size() == 2 && (matchIndex = (secondIndex = this.getIndex((SqlNode)operands.get(1))) - SqlQueryTransformer.MARKER_COMMENT.length() - 1) >= 0 && this.original.startsWith(SqlQueryTransformer.MARKER_COMMENT, matchIndex)) {
                int index = this.getIndex((SqlNode)operands.get(0));
                this.transformed.setCharAt(index, '/');
                while (++index < matchIndex) {
                    this.transformed.setCharAt(index, '*');
                }
                return null;
            }
            return (SqlNode)super.visit(call);
        }

        public String toString() {
            return this.transformed.toString();
        }
    }
}

