/*
 * Decompiled with CFR 0.152.
 */
package ome.model.enums;

import java.util.HashMap;
import java.util.Map;
import ome.model.units.UnitEnum;

public enum UnitsTime implements UnitEnum
{
    YOTTASECOND("Ys"),
    ZETTASECOND("Zs"),
    EXASECOND("Es"),
    PETASECOND("Ps"),
    TERASECOND("Ts"),
    GIGASECOND("Gs"),
    MEGASECOND("Ms"),
    KILOSECOND("ks"),
    HECTOSECOND("hs"),
    DECASECOND("das"),
    SECOND("s"),
    DECISECOND("ds"),
    CENTISECOND("cs"),
    MILLISECOND("ms"),
    MICROSECOND("\u00b5s"),
    NANOSECOND("ns"),
    PICOSECOND("ps"),
    FEMTOSECOND("fs"),
    ATTOSECOND("as"),
    ZEPTOSECOND("zs"),
    YOCTOSECOND("ys"),
    MINUTE("min"),
    HOUR("h"),
    DAY("d");

    private static final Map<String, UnitsTime> bySymbol;
    protected String symbol;

    private UnitsTime(String symbol) {
        this.symbol = symbol;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public static UnitsTime bySymbol(String symbol) {
        return bySymbol.get(symbol);
    }

    static {
        bySymbol = new HashMap<String, UnitsTime>();
        for (UnitsTime t : UnitsTime.values()) {
            bySymbol.put(t.symbol, t);
        }
    }
}

