/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v3.Array;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.Group;
import dev.zarr.zarrjava.v3.GroupMetadata;
import dev.zarr.zarrjava.v3.codec.CodecRegistry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface Node
extends dev.zarr.zarrjava.core.Node {
    public static ObjectMapper makeObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerSubtypes(CodecRegistry.getNamedTypes());
        return objectMapper;
    }

    public static Node open(StoreHandle storeHandle) throws IOException, ZarrException {
        String nodeType;
        ObjectMapper objectMapper = Node.makeObjectMapper();
        ByteBuffer metadataBytes = storeHandle.resolve("zarr.json").readNonNull();
        byte[] metadataBytearray = Utils.toArray(metadataBytes);
        switch (nodeType = objectMapper.readTree(metadataBytearray).get("node_type").asText()) {
            case "array": {
                return new Array(storeHandle, (ArrayMetadata)objectMapper.readValue(metadataBytearray, ArrayMetadata.class));
            }
            case "group": {
                return new Group(storeHandle, (GroupMetadata)objectMapper.readValue(metadataBytearray, GroupMetadata.class));
            }
        }
        throw new ZarrException("Unsupported node_type '" + nodeType + "' at " + storeHandle);
    }

    public static Node open(Path path) throws IOException, ZarrException {
        return Node.open(new StoreHandle(new FilesystemStore(path), new String[0]));
    }

    public static Node open(String path) throws IOException, ZarrException {
        return Node.open(Paths.get(path, new String[0]));
    }
}

