/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.GeneralPath;
import org.jhotdraw.draw.AbstractLineDecoration;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class ArrowTip
extends AbstractLineDecoration
implements DOMStorable {
    private double angle;
    private double outerRadius;
    private double innerRadius;

    public ArrowTip() {
        this(0.35, 12.0, 11.3);
    }

    public ArrowTip(double angle, double outerRadius, double innerRadius) {
        this(angle, outerRadius, innerRadius, true, false, true);
    }

    public ArrowTip(double angle, double outerRadius, double innerRadius, boolean isFilled, boolean isStroked, boolean isSolid) {
        super(isFilled, isStroked, isSolid);
        this.angle = angle;
        this.outerRadius = outerRadius;
        this.innerRadius = innerRadius;
    }

    protected GeneralPath getDecoratorPath(Figure f) {
        double offset = this.isStroked() ? 1.0 : 0.0;
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(this.outerRadius * Math.sin(-this.angle)), (float)(offset + this.outerRadius * Math.cos(-this.angle)));
        path.lineTo(0.0f, (float)offset);
        path.lineTo((float)(this.outerRadius * Math.sin(this.angle)), (float)(offset + this.outerRadius * Math.cos(this.angle)));
        if (this.innerRadius != 0.0) {
            path.lineTo(0.0f, (float)(this.innerRadius + offset));
            path.closePath();
        }
        return path;
    }

    protected double getDecoratorPathRadius(Figure f) {
        double offset = this.isStroked() ? 0.5 : -0.1;
        return this.innerRadius + offset;
    }

    public void read(DOMInput in) {
        this.angle = in.getAttribute("angle", 0.35f);
        this.innerRadius = in.getAttribute("innerRadius", 12.0);
        this.outerRadius = in.getAttribute("outerRadius", 12.0);
        this.setFilled(in.getAttribute("isFilled", false));
        this.setStroked(in.getAttribute("isStroked", false));
        this.setSolid(in.getAttribute("isSolid", false));
    }

    public void write(DOMOutput out) {
        out.addAttribute("angle", this.angle);
        out.addAttribute("innerRadius", this.innerRadius);
        out.addAttribute("outerRadius", this.outerRadius);
        out.addAttribute("isFilled", this.isFilled());
        out.addAttribute("isStroked", this.isStroked());
        out.addAttribute("isSolid", this.isSolid());
    }
}

