/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.CallGraph;
import edu.umd.cs.findbugs.CallGraphEdge;
import edu.umd.cs.findbugs.CallGraphNode;
import edu.umd.cs.findbugs.CallSite;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MONITOREXIT;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfCalls {
    private static final boolean DEBUG = SystemProperties.getBoolean("selfcalls.debug");
    private ClassContext classContext;
    private CallGraph callGraph;
    private HashSet<Method> calledMethodSet;
    private boolean hasSynchronization;

    public SelfCalls(ClassContext classContext) {
        this.classContext = classContext;
        this.callGraph = new CallGraph();
        this.calledMethodSet = new HashSet();
        this.hasSynchronization = false;
    }

    public void execute() throws CFGBuilderException {
        JavaClass jclass = this.classContext.getJavaClass();
        Method[] methods = jclass.getMethods();
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Class has ").append(methods.length).append(" methods").toString());
        }
        for (Method method : methods) {
            this.callGraph.addNode(method);
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Added ").append(this.callGraph.getNumVertices()).append(" nodes to graph").toString());
        }
        for (Method method : methods) {
            MethodGen mg = this.classContext.getMethodGen(method);
            if (mg == null) continue;
            this.scan(this.callGraph.getNodeForMethod(method));
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("Found ").append(this.callGraph.getNumEdges()).append(" self calls").toString());
        }
    }

    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public Iterator<Method> calledMethodIterator() {
        return this.calledMethodSet.iterator();
    }

    public boolean wantCallsFor(Method method) {
        return true;
    }

    public Iterator<CallSite> callSiteIterator() {
        return new Iterator<CallSite>(){
            private Iterator<CallGraphEdge> iter;
            {
                this.iter = SelfCalls.this.callGraph.edgeIterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public CallSite next() {
                return this.iter.next().getCallSite();
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.next();
            }
        };
    }

    public boolean hasSynchronization() {
        return this.hasSynchronization;
    }

    private void scan(CallGraphNode node) throws CFGBuilderException {
        Method method = node.getMethod();
        CFG cfg = this.classContext.getCFG(method);
        if (method.isSynchronized()) {
            this.hasSynchronization = true;
        }
        Iterator<BasicBlock> i = cfg.blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            BasicBlock.InstructionIterator j = block.instructionIterator();
            while (j.hasNext()) {
                InstructionHandle handle = (InstructionHandle)j.next();
                Instruction ins = handle.getInstruction();
                if (ins instanceof InvokeInstruction) {
                    InvokeInstruction inv = (InvokeInstruction)ins;
                    Method called = this.isSelfCall(inv);
                    if (called == null) continue;
                    CallSite callSite = new CallSite(method, block, handle);
                    this.callGraph.createEdge(node, this.callGraph.getNodeForMethod(called), callSite);
                    this.calledMethodSet.add(called);
                    continue;
                }
                if (!(ins instanceof MONITORENTER) && !(ins instanceof MONITOREXIT)) continue;
                this.hasSynchronization = true;
            }
        }
    }

    private Method isSelfCall(InvokeInstruction inv) {
        Method[] methods;
        ConstantPoolGen cpg = this.classContext.getConstantPoolGen();
        JavaClass jclass = this.classContext.getJavaClass();
        String calledClassName = inv.getClassName(cpg);
        if (!calledClassName.equals(jclass.getClassName())) {
            return null;
        }
        String calledMethodName = inv.getMethodName(cpg);
        String calledMethodSignature = inv.getSignature(cpg);
        boolean isStaticCall = inv instanceof INVOKESTATIC;
        for (Method method : methods = jclass.getMethods()) {
            String methodName = method.getName();
            String signature = method.getSignature();
            boolean isStatic = method.isStatic();
            if (!methodName.equals(calledMethodName) || !signature.equals(calledMethodSignature) || isStatic != isStaticCall) continue;
            return this.wantCallsFor(method) ? method : null;
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("No method found for ").append(calledClassName).append(".").append(calledMethodName).append(" : ").append(calledMethodSignature).toString());
        }
        return null;
    }
}

