/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeTypes;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.npe.IsNullConditionDecision;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysisFeatures;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.npe.LocationWhereValueBecomesNull;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsNullValueAnalysis
extends FrameDataflowAnalysis<IsNullValue, IsNullValueFrame>
implements EdgeTypes,
IsNullValueAnalysisFeatures {
    static final boolean DEBUG;
    private MethodGen methodGen;
    private IsNullValueFrameModelingVisitor visitor;
    private ValueNumberDataflow vnaDataflow;
    private int[] numNonExceptionSuccessorMap;
    private Set<LocationWhereValueBecomesNull> locationWhereValueBecomesNullSet;
    private final boolean trackValueNumbers = AnalysisContext.currentAnalysisContext().getBoolProperty(6);
    private IsNullValueFrame lastFrame;
    private IsNullValueFrame instanceOfFrame;
    private IsNullValueFrame cachedEntryFact;
    private JavaClassAndMethod classAndMethod;
    private static final BitSet nullComparisonInstructionSet;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$npe$IsNullValueAnalysis;

    public IsNullValueAnalysis(MethodGen methodGen, CFG cfg, ValueNumberDataflow vnaDataflow, DepthFirstSearch dfs, AssertionMethods assertionMethods) {
        super(dfs);
        this.methodGen = methodGen;
        this.visitor = new IsNullValueFrameModelingVisitor(methodGen.getConstantPool(), assertionMethods, vnaDataflow, this.trackValueNumbers);
        this.vnaDataflow = vnaDataflow;
        this.numNonExceptionSuccessorMap = new int[cfg.getNumBasicBlocks()];
        this.locationWhereValueBecomesNullSet = new HashSet<LocationWhereValueBecomesNull>();
        Iterator i = cfg.edgeIterator();
        while (i.hasNext()) {
            int srcBlockId;
            Edge edge = (Edge)i.next();
            if (edge.isExceptionEdge()) continue;
            int n = srcBlockId = ((BasicBlock)edge.getSource()).getId();
            this.numNonExceptionSuccessorMap[n] = this.numNonExceptionSuccessorMap[n] + 1;
        }
        if (DEBUG) {
            System.out.println(new StringBuffer().append("IsNullValueAnalysis for ").append(methodGen.getClassName()).append(".").append(methodGen.getName()).append(" : ").append(methodGen.getSignature()).toString());
        }
    }

    public void setClassAndMethod(JavaClassAndMethod classAndMethod) {
        this.classAndMethod = classAndMethod;
    }

    public JavaClassAndMethod getClassAndMethod() {
        return this.classAndMethod;
    }

    @Override
    public IsNullValueFrame createFact() {
        return new IsNullValueFrame(this.methodGen.getMaxLocals(), this.trackValueNumbers);
    }

    @Override
    public void initEntryFact(IsNullValueFrame result) {
        if (this.cachedEntryFact == null) {
            this.cachedEntryFact = this.createFact();
            this.cachedEntryFact.setValid();
            int numLocals = this.methodGen.getMaxLocals();
            boolean instanceMethod = !this.methodGen.isStatic();
            XMethod xm = XFactory.createXMethod(this.methodGen.getClassName(), this.methodGen.getName(), this.methodGen.getSignature(), this.methodGen.isStatic());
            NullnessAnnotationDatabase db = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
            int paramShift = instanceMethod ? 1 : 0;
            for (int i = 0; i < numLocals; ++i) {
                XMethodParameter methodParameter;
                NullnessAnnotation n;
                int paramIndex = i - paramShift;
                IsNullValue value = instanceMethod && i == 0 ? IsNullValue.nonNullValue() : (paramIndex >= this.methodGen.getArgumentTypes().length ? IsNullValue.nonReportingNotNullValue() : ((n = db.getResolvedAnnotation(methodParameter = new XMethodParameter(xm, paramIndex), false)) == NullnessAnnotation.CHECK_FOR_NULL ? IsNullValue.parameterMarkedAsMightBeNull(methodParameter) : (n == NullnessAnnotation.NONNULL ? IsNullValue.nonNullValue() : IsNullValue.nonReportingNotNullValue())));
                this.cachedEntryFact.setValue(i, value);
            }
        }
        this.copy(this.cachedEntryFact, result);
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, IsNullValueFrame start, IsNullValueFrame result) throws DataflowAnalysisException {
        this.startTransfer();
        super.transfer(basicBlock, end, start, result);
        this.endTransfer(basicBlock, end, result);
        ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(Location.getLastLocation(basicBlock));
        if (!vnaFrameAfter.isTop()) {
            result.cleanStaleKnowledge(vnaFrameAfter);
        }
    }

    public void startTransfer() throws DataflowAnalysisException {
        this.lastFrame = null;
        this.instanceOfFrame = null;
    }

    public void endTransfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, IsNullValueFrame result) throws DataflowAnalysisException {
        if (end == null) {
            if (this.lastFrame == null) {
                result.setDecision(null);
            } else {
                IsNullConditionDecision decision = this.getDecision(basicBlock, this.lastFrame);
                result.setDecision(decision);
            }
        }
        this.lastFrame = null;
        this.instanceOfFrame = null;
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, IsNullValueFrame fact) throws DataflowAnalysisException {
        if (handle == basicBlock.getLastInstruction()) {
            this.lastFrame = this.createFact();
            this.lastFrame.copyFrom(fact);
        }
        if (handle.getInstruction().getOpcode() == 193) {
            this.instanceOfFrame = this.createFact();
            this.instanceOfFrame.copyFrom(fact);
        }
        this.visitor.setFrameAndLocation(fact, new Location(handle, basicBlock));
        Instruction ins = handle.getInstruction();
        this.visitor.analyzeInstruction(ins);
        int numProduced = ins.produceStack(this.methodGen.getConstantPool());
        if (numProduced == -2) {
            throw new DataflowAnalysisException("Unpredictable stack production", this.methodGen, handle);
        }
        int start = fact.getNumSlots() - numProduced;
        Location location = new Location(handle, basicBlock);
        ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(location);
        for (int i = start; i < fact.getNumSlots(); ++i) {
            ValueNumber value = (ValueNumber)vnaFrameAfter.getValue(i);
            IsNullValue isNullValue = (IsNullValue)fact.getValue(i);
            for (int j = 0; j < start; ++j) {
                ValueNumber otherValue = (ValueNumber)vnaFrameAfter.getValue(j);
                if (!value.equals(otherValue)) continue;
                fact.setValue(j, isNullValue);
            }
        }
        if (this.visitor.getSlotContainingNewNullValue() >= 0) {
            ValueNumber newNullValue = (ValueNumber)vnaFrameAfter.getValue(this.visitor.getSlotContainingNewNullValue());
            this.addLocationWhereValueBecomesNull(new LocationWhereValueBecomesNull(location, newNullValue));
        }
    }

    @Override
    public void meetInto(IsNullValueFrame fact, Edge edge, IsNullValueFrame result) throws DataflowAnalysisException {
        this.meetInto(fact, edge, result, true);
    }

    public void meetInto(IsNullValueFrame fact, Edge edge, IsNullValueFrame result, boolean propagatePhiNodeInformation) throws DataflowAnalysisException {
        if (fact.isValid()) {
            BasicBlock destBlock;
            IsNullValueFrame tmpFact = null;
            if (!NO_SPLIT_DOWNGRADE_NSP && !edge.isExceptionEdge() && this.numNonExceptionSuccessorMap[((BasicBlock)edge.getSource()).getId()] > 1) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.downgradeOnControlSplit();
            }
            if (!NO_SWITCH_DEFAULT_AS_EXCEPTION && edge.getType() == 3) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.toExceptionValues();
            }
            if ((destBlock = (BasicBlock)edge.getTarget()).isExceptionHandler()) {
                String catchClass;
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.clearStack();
                CodeExceptionGen handler = destBlock.getExceptionGen();
                ObjectType catchType = handler.getCatchType();
                if (catchType != null && ((catchClass = catchType.getClassName()).equals("java.lang.CloneNotSupportedException") || catchClass.equals("java.lang.InterruptedException"))) {
                    for (int i = 0; i < tmpFact.getNumSlots(); ++i) {
                        IsNullValue value = (IsNullValue)tmpFact.getValue(i);
                        if (!value.isDefinitelyNull() && !value.isNullOnSomePath()) continue;
                        tmpFact.setValue(i, IsNullValue.nullOnComplexPathValue());
                    }
                }
                tmpFact.toExceptionValues();
                tmpFact.pushValue(IsNullValue.nonNullValue());
            } else {
                IsNullConditionDecision decision;
                int edgeType = edge.getType();
                BasicBlock sourceBlock = (BasicBlock)edge.getSource();
                BasicBlock targetBlock = (BasicBlock)edge.getTarget();
                ValueNumberFrame targetVnaFrame = (ValueNumberFrame)this.vnaDataflow.getStartFact(destBlock);
                ValueNumberFrame sourceVnaFrame = (ValueNumberFrame)this.vnaDataflow.getResultFact(sourceBlock);
                if (!$assertionsDisabled && targetVnaFrame == null) {
                    throw new AssertionError();
                }
                if ((edgeType == 1 || edgeType == 0) && (decision = ((IsNullValueFrame)this.getResultFact((BasicBlock)edge.getSource())).getDecision()) != null) {
                    if (!decision.isEdgeFeasible(edgeType)) {
                        tmpFact = this.createFact();
                        tmpFact.setTop();
                    } else if (decision.getValue() != null) {
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("Updating edge information for ").append(decision.getValue()).toString());
                        }
                        Location atIf = new Location(sourceBlock.getLastInstruction(), sourceBlock);
                        IsNullValueFrame prevIsNullValueFrame = (IsNullValueFrame)this.getFactAtLocation(atIf);
                        ValueNumberFrame prevVnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(atIf);
                        IsNullValue decisionValue = decision.getDecision(edgeType);
                        if (decisionValue != null) {
                            if (decisionValue.isDefinitelyNull()) {
                                this.addLocationWhereValueBecomesNull(new LocationWhereValueBecomesNull(atIf, decision.getValue()));
                            }
                            if (DEBUG) {
                                System.out.println("Set decision information");
                                System.out.println(new StringBuffer().append("  ").append(decision.getValue()).append(" becomes ").append(decisionValue).toString());
                                System.out.println(new StringBuffer().append("  prev available loads: ").append(prevVnaFrame.availableLoadMapAsString()).toString());
                                System.out.println(new StringBuffer().append("  target available loads: ").append(targetVnaFrame.availableLoadMapAsString()).toString());
                            }
                            tmpFact = this.replaceValues(fact, tmpFact, decision.getValue(), prevVnaFrame, targetVnaFrame, decisionValue);
                        }
                    }
                }
                if (sourceBlock.isNullCheck() && edgeType == 0) {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getStartFact(destBlock);
                    if (vnaFrame == null) {
                        throw new IllegalStateException("no vna frame at block entry?");
                    }
                    Instruction firstInDest = ((BasicBlock)edge.getTarget()).getFirstInstruction().getInstruction();
                    IsNullValue instance = (IsNullValue)fact.getInstance(firstInDest, this.methodGen.getConstantPool());
                    if (instance.isDefinitelyNull()) {
                        tmpFact = this.createFact();
                        tmpFact.setTop();
                    } else if (!instance.isDefinitelyNotNull()) {
                        InstructionHandle kaBoomLocation = targetBlock.getFirstInstruction();
                        ValueNumber replaceMe = (ValueNumber)vnaFrame.getInstance(firstInDest, this.methodGen.getConstantPool());
                        IsNullValue noKaboomNonNullValue = IsNullValue.noKaboomNonNullValue(new Location(kaBoomLocation, targetBlock));
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("Start vna fact: ").append(vnaFrame).toString());
                            System.out.println(new StringBuffer().append("inva fact: ").append(fact).toString());
                            System.out.println(new StringBuffer().append("\nGenerated NoKaboom value for location ").append(kaBoomLocation).toString());
                            System.out.println(new StringBuffer().append("Dereferenced ").append(instance).toString());
                            System.out.println(new StringBuffer().append("On fall through from source block ").append(sourceBlock).toString());
                        }
                        tmpFact = this.replaceValues(fact, tmpFact, replaceMe, vnaFrame, targetVnaFrame, noKaboomNonNullValue);
                    }
                }
                if (propagatePhiNodeInformation && targetVnaFrame.phiNodeForLoads) {
                    if (DEBUG) {
                        System.out.println("Is phi node for loads");
                    }
                    for (ValueNumber v : fact.getKnownValues()) {
                        ValueNumber[] matchingValueNumbers;
                        AvailableLoad loadForV = sourceVnaFrame.getLoad(v);
                        if (DEBUG) {
                            System.out.println(new StringBuffer().append("  ").append(v).append(" for ").append(loadForV).toString());
                        }
                        if (loadForV == null || (matchingValueNumbers = targetVnaFrame.getAvailableLoad(loadForV)) == null) continue;
                        for (ValueNumber v2 : matchingValueNumbers) {
                            tmpFact = this.modifyFrame(fact, tmpFact);
                            tmpFact.useNewValueNumberForLoad(v, v2);
                            if (!DEBUG) continue;
                            System.out.println(new StringBuffer().append("For ").append(loadForV).append(" switch from ").append(v).append(" to ").append(v2).toString());
                        }
                    }
                }
            }
            if (tmpFact != null) {
                fact = tmpFact;
            }
        }
        this.mergeInto(fact, result);
    }

    @Override
    protected void mergeInto(IsNullValueFrame other, IsNullValueFrame result) throws DataflowAnalysisException {
        if (other.isTop()) {
            return;
        }
        if (result.isTop()) {
            result.copyFrom(other);
            return;
        }
        super.mergeInto(other, result);
        if (this.trackValueNumbers) {
            result.mergeKnownValuesWith(other);
        }
    }

    @Override
    public void startIteration() {
        this.locationWhereValueBecomesNullSet.clear();
    }

    public void addLocationWhereValueBecomesNull(LocationWhereValueBecomesNull locationWhereValueBecomesNull) {
        this.locationWhereValueBecomesNullSet.add(locationWhereValueBecomesNull);
    }

    public Set<LocationWhereValueBecomesNull> getLocationWhereValueBecomesNullSet() {
        return this.locationWhereValueBecomesNullSet;
    }

    @Override
    protected void mergeValues(IsNullValueFrame otherFrame, IsNullValueFrame resultFrame, int slot) throws DataflowAnalysisException {
        IsNullValue value = IsNullValue.merge((IsNullValue)resultFrame.getValue(slot), (IsNullValue)otherFrame.getValue(slot));
        resultFrame.setValue(slot, value);
    }

    private IsNullConditionDecision getDecision(BasicBlock basicBlock, IsNullValueFrame lastFrame) throws DataflowAnalysisException {
        if (!$assertionsDisabled && lastFrame == null) {
            throw new AssertionError();
        }
        InstructionHandle lastInSourceHandle = basicBlock.getLastInstruction();
        if (lastInSourceHandle == null) {
            return null;
        }
        short lastInSourceOpcode = lastInSourceHandle.getInstruction().getOpcode();
        if (lastInSourceOpcode == 153 || lastInSourceOpcode == 154) {
            InstructionHandle prev = lastInSourceHandle.getPrev();
            if (prev == null) {
                return null;
            }
            short secondToLastOpcode = prev.getInstruction().getOpcode();
            if (secondToLastOpcode != 193) {
                return null;
            }
            if (this.instanceOfFrame == null) {
                return null;
            }
            IsNullValue tos = (IsNullValue)this.instanceOfFrame.getTopValue();
            boolean isNotInstanceOf = lastInSourceOpcode != 154;
            Location atInstanceOf = new Location(prev, basicBlock);
            ValueNumberFrame instanceOfVnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(atInstanceOf);
            IsNullValue ifcmpDecision = null;
            IsNullValue fallThroughDecision = null;
            if (tos.isDefinitelyNull()) {
                if (isNotInstanceOf) {
                    ifcmpDecision = tos;
                } else {
                    fallThroughDecision = tos;
                }
            } else {
                if (tos.isDefinitelyNotNull()) {
                    return null;
                }
                ifcmpDecision = isNotInstanceOf ? tos : IsNullValue.pathSensitiveNonNullValue();
                IsNullValue isNullValue = fallThroughDecision = isNotInstanceOf ? IsNullValue.pathSensitiveNonNullValue() : tos;
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append("Checking...").append(tos).append(" -> ").append(ifcmpDecision).append(" or ").append(fallThroughDecision).toString());
            }
            return new IsNullConditionDecision((ValueNumber)instanceOfVnaFrame.getTopValue(), ifcmpDecision, fallThroughDecision);
        }
        if (!nullComparisonInstructionSet.get(lastInSourceOpcode)) {
            return null;
        }
        Location atIf = new Location(lastInSourceHandle, basicBlock);
        ValueNumberFrame prevVnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(atIf);
        switch (lastInSourceOpcode) {
            case 198: 
            case 199: {
                IsNullValue tos = (IsNullValue)lastFrame.getTopValue();
                boolean ifnull = lastInSourceOpcode == 198;
                IsNullValue ifcmpDecision = null;
                IsNullValue fallThroughDecision = null;
                if (tos.isDefinitelyNull()) {
                    if (ifnull) {
                        ifcmpDecision = IsNullValue.pathSensitiveNullValue();
                    } else {
                        fallThroughDecision = IsNullValue.pathSensitiveNullValue();
                    }
                } else if (tos.isDefinitelyNotNull()) {
                    if (ifnull) {
                        fallThroughDecision = IsNullValue.pathSensitiveNonNullValue();
                    } else {
                        ifcmpDecision = IsNullValue.pathSensitiveNonNullValue();
                    }
                } else {
                    ifcmpDecision = ifnull ? IsNullValue.pathSensitiveNullValue() : IsNullValue.pathSensitiveNonNullValue();
                    fallThroughDecision = ifnull ? IsNullValue.pathSensitiveNonNullValue() : IsNullValue.pathSensitiveNullValue();
                }
                return new IsNullConditionDecision((ValueNumber)prevVnaFrame.getTopValue(), ifcmpDecision, fallThroughDecision);
            }
            case 165: 
            case 166: {
                ValueNumber value;
                IsNullValue tos = (IsNullValue)lastFrame.getStackValue(0);
                IsNullValue nextToTos = (IsNullValue)lastFrame.getStackValue(1);
                boolean tosNull = tos.isDefinitelyNull();
                boolean nextToTosNull = nextToTos.isDefinitelyNull();
                boolean cmpeq = lastInSourceOpcode == 165;
                IsNullValue ifcmpDecision = null;
                IsNullValue fallThroughDecision = null;
                if (tosNull && nextToTosNull) {
                    value = null;
                    if (cmpeq) {
                        ifcmpDecision = IsNullValue.pathSensitiveNullValue();
                    } else {
                        fallThroughDecision = IsNullValue.pathSensitiveNullValue();
                    }
                } else if (tosNull || nextToTosNull) {
                    value = (ValueNumber)prevVnaFrame.getStackValue(tosNull ? 1 : 0);
                    ifcmpDecision = cmpeq ? IsNullValue.pathSensitiveNullValue() : IsNullValue.pathSensitiveNonNullValue();
                    fallThroughDecision = cmpeq ? IsNullValue.pathSensitiveNonNullValue() : IsNullValue.pathSensitiveNullValue();
                } else if (tos.isDefinitelyNotNull() && !nextToTos.isDefinitelyNotNull()) {
                    value = (ValueNumber)prevVnaFrame.getStackValue(1);
                    if (cmpeq) {
                        ifcmpDecision = tos;
                        fallThroughDecision = nextToTos;
                    } else {
                        fallThroughDecision = tos;
                        ifcmpDecision = nextToTos;
                    }
                } else {
                    if (tos.isDefinitelyNotNull() || !nextToTos.isDefinitelyNotNull()) break;
                    value = (ValueNumber)prevVnaFrame.getStackValue(0);
                    if (cmpeq) {
                        ifcmpDecision = nextToTos;
                        fallThroughDecision = tos;
                    } else {
                        fallThroughDecision = nextToTos;
                        ifcmpDecision = tos;
                    }
                }
                return new IsNullConditionDecision(value, ifcmpDecision, fallThroughDecision);
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return null;
    }

    private IsNullValueFrame replaceValues(IsNullValueFrame origFrame, IsNullValueFrame frame, ValueNumber replaceMe, ValueNumberFrame prevVnaFrame, ValueNumberFrame targetVnaFrame, IsNullValue replacementValue) {
        frame = this.modifyFrame(origFrame, frame);
        if (!$assertionsDisabled && frame.getNumSlots() != targetVnaFrame.getNumSlots()) {
            throw new AssertionError();
        }
        int targetNumSlots = targetVnaFrame.getNumSlots();
        int prefixNumSlots = Math.min(frame.getNumSlots(), prevVnaFrame.getNumSlots());
        if (this.trackValueNumbers) {
            ValueNumber[] matchingValueNumbers;
            AvailableLoad loadForV = prevVnaFrame.getLoad(replaceMe);
            if (DEBUG && loadForV != null) {
                System.out.println(new StringBuffer().append("For ").append(replaceMe).append(" availableLoad is ").append(loadForV).toString());
                matchingValueNumbers = targetVnaFrame.getAvailableLoad(loadForV);
                if (matchingValueNumbers != null) {
                    for (ValueNumber v2 : matchingValueNumbers) {
                        System.out.println(new StringBuffer().append("  matches ").append(v2).toString());
                    }
                }
            }
            if (loadForV != null && (matchingValueNumbers = targetVnaFrame.getAvailableLoad(loadForV)) != null) {
                for (ValueNumber v2 : matchingValueNumbers) {
                    if (replaceMe.equals(v2)) continue;
                    frame.setKnownValue(v2, replacementValue);
                    if (!DEBUG) continue;
                    System.out.println(new StringBuffer().append("For ").append(loadForV).append(" switch from ").append(replaceMe).append(" to ").append(v2).toString());
                }
            }
            frame.setKnownValue(replaceMe, replacementValue);
        }
        for (int i = 0; i < prefixNumSlots; ++i) {
            if (!((ValueNumber)prevVnaFrame.getValue(i)).equals(replaceMe)) continue;
            ValueNumber corresponding = (ValueNumber)targetVnaFrame.getValue(i);
            for (int j = 0; j < targetNumSlots; ++j) {
                if (!((ValueNumber)targetVnaFrame.getValue(j)).equals(corresponding)) continue;
                frame.setValue(j, replacementValue);
            }
        }
        return frame;
    }

    public IsNullValueFrame getFactAtMidEdge(Edge edge) throws DataflowAnalysisException {
        BasicBlock block = this.isForwards() ? (BasicBlock)edge.getSource() : (BasicBlock)edge.getTarget();
        IsNullValueFrame predFact = this.createFact();
        this.copy((Frame)this.getResultFact(block), predFact);
        this.edgeTransfer(edge, predFact);
        IsNullValueFrame result = this.createFact();
        this.makeFactTop(result);
        this.meetInto(predFact, edge, result, false);
        return result;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$npe$IsNullValueAnalysis == null ? (class$edu$umd$cs$findbugs$ba$npe$IsNullValueAnalysis = IsNullValueAnalysis.class$("edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis")) : class$edu$umd$cs$findbugs$ba$npe$IsNullValueAnalysis).getName()).append(" <class file>").toString());
            System.exit(1);
        }
        DataflowTestDriver<IsNullValueFrame, IsNullValueAnalysis> driver = new DataflowTestDriver<IsNullValueFrame, IsNullValueAnalysis>(){

            @Override
            public Dataflow<IsNullValueFrame, IsNullValueAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return classContext.getIsNullValueDataflow(method);
            }
        };
        driver.execute(argv[0]);
    }

    @Override
    protected /* synthetic */ void mergeValues(Frame x0, Frame x1, int x2) throws DataflowAnalysisException {
        this.mergeValues((IsNullValueFrame)x0, (IsNullValueFrame)x1, x2);
    }

    @Override
    protected /* synthetic */ void mergeInto(Frame x0, Frame x1) throws DataflowAnalysisException {
        this.mergeInto((IsNullValueFrame)x0, (IsNullValueFrame)x1);
    }

    @Override
    public /* synthetic */ void transfer(BasicBlock x0, InstructionHandle x1, Object x2, Object x3) throws DataflowAnalysisException {
        this.transfer(x0, x1, (IsNullValueFrame)x2, (IsNullValueFrame)x3);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (IsNullValueFrame)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((IsNullValueFrame)x0, x1, (IsNullValueFrame)x2);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((IsNullValueFrame)x0);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$ba$npe$IsNullValueAnalysis == null ? (class$edu$umd$cs$findbugs$ba$npe$IsNullValueAnalysis = IsNullValueAnalysis.class$("edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis")) : class$edu$umd$cs$findbugs$ba$npe$IsNullValueAnalysis).desiredAssertionStatus();
        DEBUG = SystemProperties.getBoolean("inva.debug");
        if (DEBUG) {
            System.out.println("inva.debug enabled");
        }
        nullComparisonInstructionSet = new BitSet();
        nullComparisonInstructionSet.set(198);
        nullComparisonInstructionSet.set(199);
        nullComparisonInstructionSet.set(165);
        nullComparisonInstructionSet.set(166);
    }
}

