/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.AfterTransactionCompletionProcess;
import org.hibernate.action.BeforeTransactionCompletionProcess;
import org.hibernate.action.Executable;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Queryable;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final String[] affectedTableSpaces;
    private final Set entityCleanups = new HashSet();
    private final Set collectionCleanups = new HashSet();

    public BulkOperationCleanupAction(SessionImplementor session, Queryable[] affectedQueryables) {
        SessionFactoryImplementor factory = session.getFactory();
        ArrayList<Serializable> tmpSpaces = new ArrayList<Serializable>();
        for (int i = 0; i < affectedQueryables.length; ++i) {
            Set roles;
            tmpSpaces.addAll(Arrays.asList(affectedQueryables[i].getQuerySpaces()));
            if (affectedQueryables[i].hasCache()) {
                this.entityCleanups.add(new EntityCleanup(affectedQueryables[i].getCacheAccessStrategy()));
            }
            if ((roles = factory.getCollectionRolesByEntityParticipant(affectedQueryables[i].getEntityName())) == null) continue;
            for (String role : roles) {
                CollectionPersister collectionPersister = factory.getCollectionPersister(role);
                if (!collectionPersister.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionPersister.getCacheAccessStrategy()));
            }
        }
        this.affectedTableSpaces = tmpSpaces.toArray(new String[tmpSpaces.size()]);
    }

    public BulkOperationCleanupAction(SessionImplementor session, Set tableSpaces) {
        HashSet<Serializable> tmpSpaces = new HashSet<Serializable>(tableSpaces);
        SessionFactoryImplementor factory = session.getFactory();
        for (Map.Entry entry : factory.getAllClassMetadata().entrySet()) {
            Set roles;
            String entityName = (String)entry.getKey();
            EntityPersister persister = factory.getEntityPersister(entityName);
            Serializable[] entitySpaces = persister.getQuerySpaces();
            if (!this.affectedEntity(tableSpaces, entitySpaces)) continue;
            tmpSpaces.addAll(Arrays.asList(entitySpaces));
            if (persister.hasCache()) {
                this.entityCleanups.add(new EntityCleanup(persister.getCacheAccessStrategy()));
            }
            if ((roles = session.getFactory().getCollectionRolesByEntityParticipant(persister.getEntityName())) == null) continue;
            for (String role : roles) {
                CollectionPersister collectionPersister = factory.getCollectionPersister(role);
                if (!collectionPersister.hasCache()) continue;
                this.collectionCleanups.add(new CollectionCleanup(collectionPersister.getCacheAccessStrategy()));
            }
        }
        this.affectedTableSpaces = tmpSpaces.toArray(new String[tmpSpaces.size()]);
    }

    private boolean affectedEntity(Set affectedTableSpaces, Serializable[] checkTableSpaces) {
        if (affectedTableSpaces == null || affectedTableSpaces.isEmpty()) {
            return true;
        }
        for (int i = 0; i < checkTableSpaces.length; ++i) {
            if (!affectedTableSpaces.contains(checkTableSpaces[i])) continue;
            return true;
        }
        return false;
    }

    public Serializable[] getPropertySpaces() {
        return this.affectedTableSpaces;
    }

    public BeforeTransactionCompletionProcess getBeforeTransactionCompletionProcess() {
        return null;
    }

    public AfterTransactionCompletionProcess getAfterTransactionCompletionProcess() {
        return new AfterTransactionCompletionProcess(){

            public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
                for (Object cleanup : BulkOperationCleanupAction.this.entityCleanups) {
                    ((EntityCleanup)cleanup).release();
                }
                for (Object cleanup : BulkOperationCleanupAction.this.collectionCleanups) {
                    ((CollectionCleanup)cleanup).release();
                }
            }
        };
    }

    public void beforeExecutions() throws HibernateException {
    }

    public void execute() throws HibernateException {
    }

    private static class CollectionCleanup {
        private final CollectionRegionAccessStrategy cacheAccess;
        private final SoftLock cacheLock;

        private CollectionCleanup(CollectionRegionAccessStrategy cacheAccess) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll();
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }

    private static class EntityCleanup {
        private final EntityRegionAccessStrategy cacheAccess;
        private final SoftLock cacheLock;

        private EntityCleanup(EntityRegionAccessStrategy cacheAccess) {
            this.cacheAccess = cacheAccess;
            this.cacheLock = cacheAccess.lockRegion();
            cacheAccess.removeAll();
        }

        private void release() {
            this.cacheAccess.unlockRegion(this.cacheLock);
        }
    }
}

