/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;

public class NumberConstructor
extends BytecodeScanningDetector {
    private static final Map<String, Info> boxClasses = new HashMap<String, Info>();
    private final BugReporter bugReporter;
    private boolean constantArgument;

    public NumberConstructor(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        int majorVersion = classContext.getJavaClass().getMajor();
        if (majorVersion >= 49) {
            super.visitClassContext(classContext);
        }
    }

    public void sawOpcode(int seen) {
        String type;
        int prio;
        if (seen == 3 || seen == 9 || seen == 4 || seen == 10 || seen == 5 || seen == 6 || seen == 7 || seen == 8 || seen == 16 || seen == 18) {
            this.constantArgument = true;
            return;
        }
        if (seen != 183) {
            this.constantArgument = false;
            return;
        }
        if (!"<init>".equals(this.getNameConstantOperand())) {
            return;
        }
        String cls = this.getClassConstantOperand();
        Info info = boxClasses.get(cls);
        if (info == null) {
            return;
        }
        if (!info.constrArgs.equals(this.getSigConstantOperand())) {
            return;
        }
        if (info.isRealNumber) {
            prio = 3;
            type = "DM_FP_NUMBER_CTOR";
        } else {
            prio = 2;
            type = "DM_NUMBER_CTOR";
        }
        cls = cls.substring(cls.lastIndexOf(47) + 1);
        this.bugReporter.reportBug(new BugInstance((Detector)this, type, prio).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(cls + "(" + info.argName + ")").addString(cls + ".valueOf(" + info.argName + ")"));
    }

    static {
        boxClasses.put("java/lang/Byte", new Info(false, "byte", "(B)V"));
        boxClasses.put("java/lang/Character", new Info(false, "char", "(C)V"));
        boxClasses.put("java/lang/Short", new Info(false, "short", "(S)V"));
        boxClasses.put("java/lang/Integer", new Info(false, "int", "(I)V"));
        boxClasses.put("java/lang/Long", new Info(false, "long", "(J)V"));
        boxClasses.put("java/lang/Float", new Info(true, "float", "(F)V"));
        boxClasses.put("java/lang/Double", new Info(true, "double", "(D)V"));
    }

    static class Info {
        public final boolean isRealNumber;
        public final String argName;
        public final String constrArgs;

        public Info(boolean isRealNumber, String argName, String constrArgs) {
            this.isRealNumber = isRealNumber;
            this.argName = argName;
            this.constrArgs = constrArgs;
        }
    }
}

