/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.lang.reflect.Array;
import java.rmi.dgc.VMID;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import loci.common.ByteArrayHandle;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.CompressionType;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.codec.JPEGCodec;
import loci.formats.dicom.DicomAttribute;
import loci.formats.dicom.DicomJSONProvider;
import loci.formats.dicom.DicomTag;
import loci.formats.dicom.DicomVR;
import loci.formats.dicom.ITagProvider;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.IPyramidStore;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.IExtraMetadataWriter;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffCompression;
import loci.formats.tiff.TiffRational;
import loci.formats.tiff.TiffSaver;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.enums.DimensionOrder;
import org.perf4j.slf4j.Slf4JStopWatch;

public class DicomWriter
extends FormatWriter
implements IExtraMetadataWriter {
    public static final String UID_ROOT_KEY = "dicom.uid_root";
    public static final String UID_DEFAULT_ROOT = "1";
    public static final String TIFF_KEY = "dicom.dual_personality";
    private static final String SOP_CLASS_UID_VALUE = "1.2.840.10008.5.1.4.1.1.77.1.6";
    private long[] pixelDataLengthPointer;
    private int[] pixelDataSize;
    private long[] transferSyntaxPointer;
    private long[] compressionMethodPointer;
    private long[] nextIFDPointer;
    private IFD[][] ifds;
    private long fileMetaLengthPointer;
    private int baseTileWidth = 256;
    private int baseTileHeight = 256;
    private int[] tileWidth;
    private int[] tileHeight;
    private long[] tileWidthPointer;
    private long[] tileHeightPointer;
    private long[] tileCountPointer;
    private PlaneOffset[][] planeOffsets;
    private Integer currentPlane = null;
    private UIDCreator uids;
    private String instanceUIDValue;
    private String implementationUID;
    private ArrayList<ITagProvider> tagProviders = new ArrayList();
    private boolean bigTiff = false;
    private TiffSaver tiffSaver;
    private Boolean validPixelCount = null;

    public DicomWriter() {
        super("DICOM", "dcm");
        this.compressionTypes = new String[]{CompressionType.UNCOMPRESSED.getCompression(), CompressionType.JPEG.getCompression(), CompressionType.J2K.getCompression()};
    }

    @Override
    public void setExtraMetadata(Object tagSource) {
        FormatTools.assertId((String)this.currentId, (boolean)false, (int)1);
        Slf4JStopWatch metadataWatch = this.stopWatch();
        if (tagSource != null) {
            ITagProvider provider = null;
            if (tagSource instanceof ITagProvider) {
                provider = (ITagProvider)tagSource;
            } else if (tagSource instanceof String && DicomWriter.checkSuffix((String)((String)tagSource), (String)"json")) {
                provider = new DicomJSONProvider();
                try {
                    provider.readTagSource((String)tagSource);
                }
                catch (IOException e) {
                    LOGGER.error("Could not parse extra metadata: " + tagSource, (Throwable)e);
                }
            } else {
                throw new IllegalArgumentException("Unknown tag format: " + tagSource);
            }
            this.tagProviders.add(provider);
        }
        metadataWatch.stop("parsed extra metadata from " + tagSource);
    }

    public void setBigTiff(boolean bigTiff) {
        FormatTools.assertId((String)this.currentId, (boolean)false, (int)1);
        this.bigTiff = bigTiff;
    }

    public boolean writeDualPersonality() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            return ((DynamicMetadataOptions)options).getBoolean(TIFF_KEY, Boolean.valueOf(true));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSeries(int s) throws FormatException {
        super.setSeries(s);
        Slf4JStopWatch seriesWatch = this.stopWatch();
        try {
            this.openFile(this.series, this.resolution);
        }
        catch (IOException e) {
            LOGGER.error("Could not open file for series #" + s, (Throwable)e);
        }
        finally {
            seriesWatch.stop("setSeries(" + s + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResolution(int r) {
        super.setResolution(r);
        Slf4JStopWatch resolutionWatch = this.stopWatch();
        try {
            this.openFile(this.series, this.resolution);
        }
        catch (IOException e) {
            LOGGER.error("Could not open file for series #" + this.series + ", resolution #" + r, (Throwable)e);
        }
        finally {
            resolutionWatch.stop("setResolution(" + r + ")");
        }
    }

    public Codec getCodec() {
        if (CompressionType.JPEG.getCompression().equals(this.compression)) {
            return new JPEGCodec();
        }
        if (CompressionType.J2K.getCompression().equals(this.compression)) {
            return new JPEG2000Codec();
        }
        return null;
    }

    public void saveCompressedBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        boolean pad;
        this.checkPrecompressedSupport();
        LOGGER.debug("savePrecompressedBytes(series={}, resolution={}, no={}, x={}, y={})", new Object[]{this.series, this.resolution, no, x, y});
        MetadataRetrieve r = this.getMetadataRetrieve();
        Slf4JStopWatch precompressedWatch = this.stopWatch();
        int bytesPerPixel = FormatTools.getBytesPerPixel((int)FormatTools.pixelTypeFromString((String)r.getPixelsType(this.series).toString()));
        int resolutionIndex = this.getIndex(this.series, this.resolution);
        if (buf.length == 0) {
            LOGGER.warn("Zero-length tile encountered (series={}, resolution={}, no={}, x={}, y={}; creating blank tile", new Object[]{this.series, this.resolution, no, x, y});
            int thisTileWidth = this.tileWidth[resolutionIndex];
            int thisTileHeight = this.tileHeight[resolutionIndex];
            byte[] emptyTile = new byte[thisTileWidth * thisTileHeight * bytesPerPixel * this.getSamplesPerPixel()];
            if (this.compression == null || this.compression.equals(CompressionType.UNCOMPRESSED.getCompression())) {
                buf = emptyTile;
            } else {
                Codec codec = this.getCodec();
                CodecOptions options = new CodecOptions();
                options.width = w;
                options.height = h;
                options.channels = this.getSamplesPerPixel();
                options.bitsPerSample = bytesPerPixel * 8;
                options.littleEndian = this.out.isLittleEndian();
                options.interleaved = true;
                if (codec instanceof JPEG2000Codec) {
                    options = JPEG2000CodecOptions.getDefaultOptions(options);
                    ((JPEG2000CodecOptions)options).numDecompositionLevels = 0;
                }
                buf = codec.compress(emptyTile, options);
            }
        }
        boolean first = x == 0 && y == 0;
        boolean last = x + w == this.getSizeX() && y + h == this.getSizeY();
        int width = this.getSizeX();
        int height = this.getSizeY();
        int sizeZ = (Integer)r.getPixelsSizeZ(this.series).getValue();
        int tileCountX = (int)Math.ceil((double)width / (double)this.tileWidth[resolutionIndex]);
        int tileCountY = (int)Math.ceil((double)height / (double)this.tileHeight[resolutionIndex]);
        if (first) {
            this.out.seek(this.transferSyntaxPointer[resolutionIndex]);
            this.out.writeBytes(this.getTransferSyntax());
            this.out.seek(this.compressionMethodPointer[resolutionIndex]);
            this.out.writeBytes(this.getCompressionMethod());
            this.ifds[resolutionIndex][no].put(259, this.getTIFFCompression().getCode());
            if (this.getTIFFCompression() == TiffCompression.JPEG) {
                this.ifds[resolutionIndex][no].put(262, PhotoInterp.Y_CB_CR.getCode());
            }
            this.out.seek(this.tileWidthPointer[resolutionIndex]);
            this.out.writeShort((short)this.getTileSizeX());
            this.out.seek(this.tileHeightPointer[resolutionIndex]);
            this.out.writeShort((short)this.getTileSizeY());
            this.out.seek(this.tileCountPointer[resolutionIndex]);
            this.out.writeBytes(this.padString(String.valueOf(tileCountX * tileCountY * sizeZ * r.getChannelCount(this.series))));
        }
        precompressedWatch.stop("precompressed tile setup");
        precompressedWatch.start();
        this.out.seek(this.out.length());
        long start = this.out.getFilePointer();
        boolean bl = pad = buf.length % 2 == 1;
        if (first) {
            DicomTag bot = new DicomTag(DicomAttribute.ITEM, DicomVR.IMPLICIT);
            bot.elementLength = 0;
            this.writeTag(bot);
        }
        DicomTag item = new DicomTag(DicomAttribute.ITEM, DicomVR.IMPLICIT);
        item.elementLength = buf.length;
        if (pad) {
            ++item.elementLength;
        }
        item.value = buf;
        this.writeTag(item);
        if (pad) {
            this.out.writeByte(0);
        }
        precompressedWatch.stop("wrote precompressed tile");
        precompressedWatch.start();
        int xTiles = (int)Math.ceil((double)this.getSizeX() / (double)this.tileWidth[resolutionIndex]);
        int xTile = x / this.tileWidth[resolutionIndex];
        int yTile = y / this.tileHeight[resolutionIndex];
        int tileIndex = yTile * xTiles + xTile;
        long[] tileByteCounts = null;
        long[] tileOffsets = null;
        if (this.ifds[resolutionIndex][no] != null) {
            tileByteCounts = (long[])this.ifds[resolutionIndex][no].getIFDValue(325);
            tileOffsets = (long[])this.ifds[resolutionIndex][no].getIFDValue(324);
            if (tileByteCounts.length < tileCountX * tileCountY) {
                long[] newTileByteCounts = new long[tileCountX * tileCountY];
                long[] newTileOffsets = new long[tileCountX * tileCountY];
                System.arraycopy(tileByteCounts, 0, newTileByteCounts, 0, tileByteCounts.length);
                System.arraycopy(tileOffsets, 0, newTileOffsets, 0, tileOffsets.length);
                tileByteCounts = newTileByteCounts;
                tileOffsets = newTileOffsets;
                this.ifds[resolutionIndex][no].put(325, tileByteCounts);
                this.ifds[resolutionIndex][no].put(324, tileOffsets);
            }
        }
        if (tileByteCounts != null) {
            tileByteCounts[tileIndex] = buf.length;
        }
        if (tileOffsets != null) {
            tileOffsets[tileIndex] = this.out.getFilePointer() - (long)buf.length;
            if (pad) {
                int n = tileIndex;
                tileOffsets[n] = tileOffsets[n] - 1L;
            }
        }
        if (last) {
            DicomTag end = new DicomTag(DicomAttribute.SEQUENCE_DELIMITATION_ITEM, DicomVR.IMPLICIT);
            end.elementLength = 0;
            this.writeTag(end);
        }
        precompressedWatch.stop("updated IFD");
    }

    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h);
        int resolutionIndex = this.getIndex(this.series, this.resolution);
        int thisTileWidth = this.tileWidth[resolutionIndex];
        int thisTileHeight = this.tileHeight[resolutionIndex];
        MetadataRetrieve r = this.getMetadataRetrieve();
        if (x % thisTileWidth != 0 || y % thisTileHeight != 0 || w != thisTileWidth && x + w != this.getSizeX() || h != thisTileHeight && y + h != this.getSizeY()) {
            throw new FormatException("Tile too small, expected " + thisTileWidth + "x" + thisTileHeight + ". Setting the tile size to " + this.getSizeX() + "x" + this.getSizeY() + " or smaller may work.");
        }
        Slf4JStopWatch tileWatch = this.stopWatch();
        this.checkPixelCount(false);
        boolean first = x == 0 && y == 0;
        boolean last = x + w == this.getSizeX() && y + h == this.getSizeY();
        int xTiles = (int)Math.ceil((double)this.getSizeX() / (double)thisTileWidth);
        int yTiles = (int)Math.ceil((double)this.getSizeY() / (double)thisTileHeight);
        int sizeZ = (Integer)r.getPixelsSizeZ(this.series).getValue();
        if (first) {
            this.out.seek(this.transferSyntaxPointer[resolutionIndex]);
            this.out.writeBytes(this.getTransferSyntax());
            this.out.seek(this.compressionMethodPointer[resolutionIndex]);
            this.out.writeBytes(this.getCompressionMethod());
            if (this.writeDualPersonality()) {
                this.ifds[resolutionIndex][no].put(259, this.getTIFFCompression().getCode());
                if (this.getTIFFCompression() == TiffCompression.JPEG) {
                    this.ifds[resolutionIndex][no].put(262, PhotoInterp.Y_CB_CR.getCode());
                }
            }
            this.out.seek(this.tileWidthPointer[resolutionIndex]);
            this.out.writeShort((short)this.getTileSizeX());
            this.out.seek(this.tileHeightPointer[resolutionIndex]);
            this.out.writeShort((short)this.getTileSizeY());
            this.out.seek(this.tileCountPointer[resolutionIndex]);
            this.out.writeBytes(this.padString(String.valueOf(xTiles * yTiles * sizeZ * r.getChannelCount(this.series))));
        }
        if (!this.isReallySequential()) {
            Length physicalX = r.getPixelsPhysicalSizeX(this.series);
            Length physicalY = r.getPixelsPhysicalSizeY(this.series);
            for (int p = 0; p < this.planeOffsets[resolutionIndex].length; ++p) {
                if (this.planeOffsets[resolutionIndex][p].written) continue;
                PlaneOffset offset = this.planeOffsets[resolutionIndex][p];
                offset.written = true;
                int[] zct = this.getZCTCoords(no);
                this.out.seek(offset.cOffset);
                this.out.writeBytes(this.padString(String.valueOf(zct[1])));
                this.out.seek(offset.xOffset);
                this.out.writeInt(x + 1);
                this.out.seek(offset.yOffset);
                this.out.writeInt(y + 1);
                this.out.seek(offset.dimensionIndex);
                this.out.writeInt(x + 1);
                this.out.writeInt(y + 1);
                this.out.seek(offset.zOffset);
                this.out.writeBytes(this.padString(String.valueOf(zct[0])));
                break;
            }
        }
        tileWatch.stop("setup tile writing");
        tileWatch.start();
        int bytesPerPixel = FormatTools.getBytesPerPixel((int)FormatTools.pixelTypeFromString((String)r.getPixelsType(this.series).toString()));
        int samplesPerPixel = this.getSamplesPerPixel();
        this.out.seek(this.out.length());
        long start = this.out.getFilePointer();
        byte[] paddedBuf = null;
        int thisTilePixels = thisTileWidth * thisTileHeight;
        if (x + w == this.getSizeX() && w < thisTileWidth || y + h == this.getSizeY() && h < thisTileHeight) {
            int destRowLen;
            int srcRowLen;
            if (this.interleaved || samplesPerPixel == 1) {
                srcRowLen = w * bytesPerPixel * samplesPerPixel;
                destRowLen = thisTileWidth * bytesPerPixel * samplesPerPixel;
                paddedBuf = new byte[thisTileHeight * destRowLen];
                for (int row = 0; row < h; ++row) {
                    System.arraycopy(buf, row * srcRowLen, paddedBuf, row * destRowLen, srcRowLen);
                }
            } else {
                srcRowLen = w * bytesPerPixel;
                destRowLen = thisTileWidth * bytesPerPixel;
                paddedBuf = new byte[thisTileHeight * destRowLen * samplesPerPixel];
                for (int c = 0; c < samplesPerPixel; ++c) {
                    for (int row = 0; row < h; ++row) {
                        int src = srcRowLen * (c * h + row);
                        int dest = destRowLen * (c * thisTileHeight + row);
                        System.arraycopy(buf, src, paddedBuf, dest, srcRowLen);
                    }
                }
            }
        } else {
            paddedBuf = buf;
        }
        if (!this.isInterleaved()) {
            byte[] interleavedBuf = new byte[paddedBuf.length];
            for (int c = 0; c < samplesPerPixel; ++c) {
                int channelIndex = c * bytesPerPixel;
                int splitChannelIndex = thisTilePixels * channelIndex;
                int px = 0;
                int pixelIndex = 0;
                while (px < thisTilePixels) {
                    int interleavedPixelIndex = pixelIndex * samplesPerPixel;
                    for (int b = 0; b < bytesPerPixel; ++b) {
                        interleavedBuf[interleavedPixelIndex + channelIndex + b] = paddedBuf[splitChannelIndex + pixelIndex + b];
                    }
                    ++px;
                    pixelIndex += bytesPerPixel;
                }
            }
            paddedBuf = interleavedBuf;
        }
        tileWatch.stop("repacked tile for compression");
        tileWatch.start();
        int xTile = x / this.tileWidth[resolutionIndex];
        int yTile = y / this.tileHeight[resolutionIndex];
        int tileIndex = yTile * xTiles + xTile;
        long[] tileByteCounts = null;
        long[] tileOffsets = null;
        if (this.ifds[resolutionIndex][no] != null) {
            tileByteCounts = (long[])this.ifds[resolutionIndex][no].getIFDValue(325);
            tileOffsets = (long[])this.ifds[resolutionIndex][no].getIFDValue(324);
            if (tileByteCounts.length < xTiles * yTiles) {
                long[] newTileByteCounts = new long[xTiles * yTiles];
                long[] newTileOffsets = new long[xTiles * yTiles];
                System.arraycopy(tileByteCounts, 0, newTileByteCounts, 0, tileByteCounts.length);
                System.arraycopy(tileOffsets, 0, newTileOffsets, 0, tileOffsets.length);
                tileByteCounts = newTileByteCounts;
                tileOffsets = newTileOffsets;
                this.ifds[resolutionIndex][no].put(325, tileByteCounts);
                this.ifds[resolutionIndex][no].put(324, tileOffsets);
            }
        }
        if (this.compression == null || this.compression.equals(CompressionType.UNCOMPRESSED.getCompression())) {
            long tileOffset = this.out.getFilePointer();
            this.out.write(paddedBuf);
            if (paddedBuf.length % 2 == 1) {
                this.out.writeByte(0);
            }
            long length = this.out.getFilePointer() - start;
            int n = resolutionIndex;
            this.pixelDataSize[n] = this.pixelDataSize[n] + (int)length;
            this.out.seek(this.pixelDataLengthPointer[resolutionIndex]);
            this.out.writeInt(this.pixelDataSize[resolutionIndex]);
            if (tileByteCounts != null) {
                tileByteCounts[tileIndex] = length;
            }
            if (tileOffsets != null) {
                tileOffsets[tileIndex] = tileOffset;
            }
        } else {
            byte[] compressed;
            boolean pad;
            Codec codec = this.getCodec();
            CodecOptions options = new CodecOptions(this.getCodecOptions());
            options.width = this.tileWidth[resolutionIndex];
            options.height = this.tileHeight[resolutionIndex];
            options.channels = samplesPerPixel;
            options.bitsPerSample = bytesPerPixel * 8;
            options.littleEndian = this.out.isLittleEndian();
            options.interleaved = true;
            if (codec instanceof JPEG2000Codec) {
                options = JPEG2000CodecOptions.getDefaultOptions(options);
                ((JPEG2000CodecOptions)options).numDecompositionLevels = 0;
            }
            boolean bl = pad = (compressed = codec.compress(paddedBuf, options)).length % 2 == 1;
            if (first) {
                DicomTag bot = new DicomTag(DicomAttribute.ITEM, DicomVR.IMPLICIT);
                bot.elementLength = 0;
                this.writeTag(bot);
            }
            if (tileByteCounts != null) {
                tileByteCounts[tileIndex] = compressed.length;
            }
            DicomTag item = new DicomTag(DicomAttribute.ITEM, DicomVR.IMPLICIT);
            item.elementLength = compressed.length;
            if (pad) {
                ++item.elementLength;
            }
            item.value = compressed;
            this.writeTag(item);
            if (tileOffsets != null) {
                tileOffsets[tileIndex] = this.out.getFilePointer() - (long)compressed.length;
            }
            if (pad) {
                this.out.writeByte(0);
            }
            if (last) {
                DicomTag end = new DicomTag(DicomAttribute.SEQUENCE_DELIMITATION_ITEM, DicomVR.IMPLICIT);
                end.elementLength = 0;
                this.writeTag(end);
            }
        }
        tileWatch.stop("compressed and wrote tile");
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes(String codec) {
        if (this.compression != null && !this.compression.equals(CompressionType.UNCOMPRESSED.getCompression())) {
            return new int[]{0, 1, 2, 3};
        }
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public void setId(String id) throws FormatException, IOException {
        if (id.equals(this.currentId)) {
            return;
        }
        this.currentId = id;
        if (this.out != null) {
            if (this.out.length() != 0L) {
                return;
            }
            this.out.close();
        }
        Slf4JStopWatch initWatch = this.stopWatch();
        this.checkPixelCount(true);
        this.uids = new UIDCreator();
        MetadataRetrieve r = this.getMetadataRetrieve();
        this.resolution = 0;
        boolean hasPyramid = r instanceof IPyramidStore;
        int totalFiles = 0;
        for (int pyramid = 0; pyramid < r.getImageCount(); ++pyramid) {
            if ((Integer)r.getPixelsSizeT(pyramid).getValue() > 1) {
                throw new FormatException("Multiple timepoints not supported");
            }
            if (hasPyramid) {
                totalFiles += ((IPyramidStore)r).getResolutionCount(pyramid);
                continue;
            }
            ++totalFiles;
        }
        this.pixelDataLengthPointer = new long[totalFiles];
        this.pixelDataSize = new int[totalFiles];
        this.transferSyntaxPointer = new long[totalFiles];
        this.compressionMethodPointer = new long[totalFiles];
        this.nextIFDPointer = new long[totalFiles];
        this.ifds = new IFD[totalFiles][];
        this.planeOffsets = new PlaneOffset[totalFiles][];
        this.tileWidth = new int[totalFiles];
        this.tileHeight = new int[totalFiles];
        this.tileWidthPointer = new long[totalFiles];
        this.tileHeightPointer = new long[totalFiles];
        this.tileCountPointer = new long[totalFiles];
        String specimenUIDValue = this.uids.getUID();
        this.implementationUID = this.uids.getUID();
        String seriesInstanceUID = this.uids.getUID();
        String studyInstanceUID = this.uids.getUID();
        initWatch.stop("setup data structures");
        initWatch.start();
        for (int pyramid = 0; pyramid < r.getImageCount(); ++pyramid) {
            this.series = pyramid;
            int resolutionCount = 1;
            if (hasPyramid) {
                resolutionCount = ((IPyramidStore)r).getResolutionCount(pyramid);
            }
            for (int res = 0; res < resolutionCount; ++res) {
                Slf4JStopWatch resolutionWatch = this.stopWatch();
                this.instanceUIDValue = this.uids.getUID();
                this.resolution = res;
                int resolutionIndex = this.getIndex(this.series, this.resolution);
                this.ifds[resolutionIndex] = new IFD[this.getPlaneCount(pyramid)];
                ArrayList<DicomTag> tags = new ArrayList<DicomTag>();
                DicomTag imageType = new DicomTag(DicomAttribute.IMAGE_TYPE, DicomVR.CS);
                String pyramidName = r.getImageName(pyramid);
                String type = this.getImageType(pyramidName, res, hasPyramid, resolutionCount);
                imageType.value = this.padString(type);
                tags.add(imageType);
                boolean fullImage = type.indexOf("VOLUME") < 0;
                int width = 0;
                int height = 0;
                if (hasPyramid && this.resolution > 0) {
                    width = (Integer)((IPyramidStore)r).getResolutionSizeX(pyramid, this.resolution).getValue();
                    height = (Integer)((IPyramidStore)r).getResolutionSizeY(pyramid, this.resolution).getValue();
                } else {
                    width = (Integer)r.getPixelsSizeX(pyramid).getValue();
                    height = (Integer)r.getPixelsSizeY(pyramid).getValue();
                }
                int sizeZ = (Integer)r.getPixelsSizeZ(pyramid).getValue();
                String pixelType = r.getPixelsType(pyramid).toString();
                int bytesPerPixel = FormatTools.getBytesPerPixel((String)pixelType);
                int nChannels = this.getSamplesPerPixel();
                int sizeC = (Integer)r.getPixelsSizeC(pyramid).getValue();
                int sizeT = (Integer)r.getPixelsSizeT(pyramid).getValue();
                long rawPixelBytes = (long)width * (long)height * (long)bytesPerPixel * (long)sizeZ * (long)sizeC * (long)sizeT;
                if (rawPixelBytes >= 4183818240L) {
                    this.bigTiff = true;
                }
                this.openFile(this.series, this.resolution);
                this.tileWidth[resolutionIndex] = this.getTileSizeX();
                if (fullImage || this.tileWidth[resolutionIndex] <= 0) {
                    this.tileWidth[resolutionIndex] = width;
                }
                this.tileHeight[resolutionIndex] = this.getTileSizeY();
                if (fullImage || this.tileHeight[resolutionIndex] <= 0) {
                    this.tileHeight[resolutionIndex] = height;
                }
                if (nChannels > 1) {
                    DicomTag planarConfig = new DicomTag(DicomAttribute.PLANAR_CONFIGURATION, DicomVR.US);
                    planarConfig.value = new short[]{0};
                    tags.add(planarConfig);
                }
                DicomTag rows = new DicomTag(DicomAttribute.ROWS, DicomVR.US);
                rows.value = new short[]{(short)this.tileHeight[resolutionIndex]};
                tags.add(rows);
                DicomTag columns = new DicomTag(DicomAttribute.COLUMNS, DicomVR.US);
                columns.value = new short[]{(short)this.tileWidth[resolutionIndex]};
                tags.add(columns);
                DicomTag matrixRows = new DicomTag(DicomAttribute.TOTAL_PIXEL_MATRIX_ROWS, DicomVR.UL);
                matrixRows.value = new long[]{height};
                tags.add(matrixRows);
                DicomTag matrixColumns = new DicomTag(DicomAttribute.TOTAL_PIXEL_MATRIX_COLUMNS, DicomVR.UL);
                matrixColumns.value = new long[]{width};
                tags.add(matrixColumns);
                int tileCountX = (int)Math.ceil((double)width / (double)this.tileWidth[resolutionIndex]);
                int tileCountY = (int)Math.ceil((double)height / (double)this.tileHeight[resolutionIndex]);
                DicomTag numberOfFrames = new DicomTag(DicomAttribute.NUMBER_OF_FRAMES, DicomVR.IS);
                numberOfFrames.value = this.padString(String.valueOf(tileCountX * tileCountY * sizeZ * r.getChannelCount(pyramid)), " ", 10);
                tags.add(numberOfFrames);
                DicomTag matrixFrames = new DicomTag(DicomAttribute.TOTAL_PIXEL_MATRIX_FOCAL_PLANES, DicomVR.UL);
                matrixFrames.value = new long[]{sizeZ};
                tags.add(matrixFrames);
                DicomTag edf = new DicomTag(DicomAttribute.EXTENDED_DEPTH_OF_FIELD, DicomVR.CS);
                edf.value = this.padString("NO");
                tags.add(edf);
                DicomTag bits = new DicomTag(DicomAttribute.BITS_ALLOCATED, DicomVR.US);
                bits.value = new short[]{(short)(bytesPerPixel * 8)};
                tags.add(bits);
                DicomTag bitsStored = new DicomTag(DicomAttribute.BITS_STORED, DicomVR.US);
                bitsStored.value = bits.value;
                tags.add(bitsStored);
                DicomTag highBit = new DicomTag(DicomAttribute.HIGH_BIT, DicomVR.US);
                highBit.value = new short[]{(short)(this.out.isLittleEndian() ? bytesPerPixel * 8 - 1 : 0)};
                tags.add(highBit);
                DicomTag pixelRepresentation = new DicomTag(DicomAttribute.PIXEL_REPRESENTATION, DicomVR.US);
                int pixelTypeCode = FormatTools.pixelTypeFromString((String)pixelType);
                boolean isSigned = FormatTools.isSigned((int)pixelTypeCode);
                pixelRepresentation.value = new short[]{(short)(isSigned ? 1 : 0)};
                tags.add(pixelRepresentation);
                DicomTag samplesPerPixel = new DicomTag(DicomAttribute.SAMPLES_PER_PIXEL, DicomVR.US);
                samplesPerPixel.value = new short[]{(short)nChannels};
                tags.add(samplesPerPixel);
                DicomTag lossy = new DicomTag(DicomAttribute.LOSSY_IMAGE_COMPRESSION, DicomVR.CS);
                lossy.value = "01";
                tags.add(lossy);
                DicomTag lossyRatio = new DicomTag(DicomAttribute.LOSSY_IMAGE_COMPRESSION_RATIO, DicomVR.DS);
                lossyRatio.value = this.padString(UID_DEFAULT_ROOT);
                tags.add(lossyRatio);
                DicomTag lossyMethod = new DicomTag(DicomAttribute.LOSSY_IMAGE_COMPRESSION_METHOD, DicomVR.CS);
                lossyMethod.elementLength = 12;
                tags.add(lossyMethod);
                DicomTag dimensionOrganization = new DicomTag(DicomAttribute.DIMENSION_ORGANIZATION_TYPE, DicomVR.CS);
                dimensionOrganization.value = this.padString(this.isReallySequential() ? "TILED_FULL" : "TILED_SPARSE");
                tags.add(dimensionOrganization);
                DicomTag dimensionOrganizationSequence = new DicomTag(DicomAttribute.DIMENSION_ORGANIZATION_SEQUENCE, DicomVR.SQ);
                DicomTag xDimensionUID = new DicomTag(DicomAttribute.DIMENSION_ORGANIZATION_UID, DicomVR.UI);
                xDimensionUID.value = this.padUID(this.uids.getUID());
                dimensionOrganizationSequence.children.add(xDimensionUID);
                DicomTag yDimensionUID = new DicomTag(DicomAttribute.DIMENSION_ORGANIZATION_UID, DicomVR.UI);
                yDimensionUID.value = this.padUID(this.uids.getUID());
                dimensionOrganizationSequence.children.add(yDimensionUID);
                tags.add(dimensionOrganizationSequence);
                if (!this.isReallySequential()) {
                    DicomTag dimensionIndexSequence = new DicomTag(DicomAttribute.DIMENSION_INDEX_SEQUENCE, DicomVR.SQ);
                    dimensionIndexSequence.children.add(this.makeItem());
                    DicomTag xuid = new DicomTag(DicomAttribute.DIMENSION_ORGANIZATION_UID, DicomVR.UI);
                    xuid.value = xDimensionUID.value;
                    dimensionIndexSequence.children.add(xuid);
                    DicomTag xPointer = new DicomTag(DicomAttribute.DIMENSION_INDEX_POINTER, DicomVR.AT);
                    xPointer.value = this.makeShortArray(DicomAttribute.COLUMN_POSITION_IN_MATRIX.getTag());
                    dimensionIndexSequence.children.add(xPointer);
                    DicomTag groupPointer = new DicomTag(DicomAttribute.FUNCTIONAL_GROUP_POINTER, DicomVR.AT);
                    groupPointer.value = this.makeShortArray(DicomAttribute.PLANE_POSITION_SLIDE_SEQUENCE.getTag());
                    dimensionIndexSequence.children.add(groupPointer);
                    dimensionIndexSequence.children.add(this.makeItemDelimitation());
                    dimensionIndexSequence.children.add(this.makeItem());
                    DicomTag yuid = new DicomTag(DicomAttribute.DIMENSION_ORGANIZATION_UID, DicomVR.UI);
                    yuid.value = yDimensionUID.value;
                    dimensionIndexSequence.children.add(yuid);
                    DicomTag yPointer = new DicomTag(DicomAttribute.DIMENSION_INDEX_POINTER, DicomVR.AT);
                    yPointer.value = this.makeShortArray(DicomAttribute.ROW_POSITION_IN_MATRIX.getTag());
                    dimensionIndexSequence.children.add(yPointer);
                    dimensionIndexSequence.children.add(groupPointer);
                    dimensionIndexSequence.children.add(this.makeItemDelimitation());
                    tags.add(dimensionIndexSequence);
                }
                DicomTag modality = new DicomTag(DicomAttribute.MODALITY, DicomVR.CS);
                modality.value = this.padString("SM");
                tags.add(modality);
                DicomTag seriesNumber = new DicomTag(DicomAttribute.SERIES_NUMBER, DicomVR.IS);
                seriesNumber.value = this.padString(UID_DEFAULT_ROOT);
                tags.add(seriesNumber);
                DicomTag instanceNumber = new DicomTag(DicomAttribute.INSTANCE_NUMBER, DicomVR.IS);
                instanceNumber.value = this.padString(String.valueOf(resolutionIndex + 1));
                tags.add(instanceNumber);
                DicomTag instanceUID = new DicomTag(DicomAttribute.SOP_INSTANCE_UID, DicomVR.UI);
                instanceUID.value = this.padUID(this.instanceUIDValue);
                tags.add(instanceUID);
                DicomTag sopClassUID = new DicomTag(DicomAttribute.SOP_CLASS_UID, DicomVR.UI);
                sopClassUID.value = this.padUID(SOP_CLASS_UID_VALUE);
                tags.add(sopClassUID);
                DicomTag studyUID = new DicomTag(DicomAttribute.STUDY_INSTANCE_UID, DicomVR.UI);
                studyUID.value = this.padUID(studyInstanceUID);
                tags.add(studyUID);
                DicomTag seriesInstance = new DicomTag(DicomAttribute.SERIES_INSTANCE_UID, DicomVR.UI);
                seriesInstance.value = this.padUID(seriesInstanceUID);
                tags.add(seriesInstance);
                DicomTag photoInterp = new DicomTag(DicomAttribute.PHOTOMETRIC_INTERPRETATION, DicomVR.CS);
                photoInterp.value = this.padString(nChannels == 3 ? "RGB" : "MONOCHROME2");
                tags.add(photoInterp);
                if (nChannels != 3) {
                    DicomTag rescaleSlope = new DicomTag(DicomAttribute.RESCALE_SLOPE, DicomVR.DS);
                    rescaleSlope.value = this.padString(UID_DEFAULT_ROOT);
                    tags.add(rescaleSlope);
                    DicomTag rescaleIntercept = new DicomTag(DicomAttribute.RESCALE_INTERCEPT, DicomVR.DS);
                    rescaleIntercept.value = this.padString("0");
                    tags.add(rescaleIntercept);
                    DicomTag presentationLutShape = new DicomTag(DicomAttribute.PRESENTATION_LUT_SHAPE, DicomVR.CS);
                    presentationLutShape.value = this.padString("IDENTITY");
                    tags.add(presentationLutShape);
                }
                long timestamp = System.currentTimeMillis();
                DicomTag date = new DicomTag(DicomAttribute.ACQUISITION_DATE, DicomVR.DA);
                date.value = DateTools.convertDate(timestamp, 0, "yyyyMMdd");
                tags.add(date);
                DicomTag time = new DicomTag(DicomAttribute.ACQUISITION_TIME, DicomVR.TM);
                time.value = DateTools.convertDate(timestamp, 0, "HHmmss");
                tags.add(time);
                DicomTag contentDate = new DicomTag(DicomAttribute.CONTENT_DATE, DicomVR.DA);
                contentDate.value = date.value;
                tags.add(contentDate);
                DicomTag contentTime = new DicomTag(DicomAttribute.CONTENT_TIME, DicomVR.TM);
                contentTime.value = time.value;
                tags.add(contentTime);
                DicomTag dateTime = new DicomTag(DicomAttribute.ACQUISITION_TIMESTAMP, DicomVR.DT);
                dateTime.value = this.padString(DateTools.convertDate(timestamp, 0, "yyyyMMddHHmmss"));
                tags.add(dateTime);
                DicomTag specimenLabelInImage = new DicomTag(DicomAttribute.SPECIMEN_LABEL_IN_IMAGE, DicomVR.CS);
                boolean specimenLabel = type.indexOf("OVERVIEW") > 0 || type.indexOf("LABEL") > 0;
                specimenLabelInImage.value = this.padString(specimenLabel ? "YES" : "NO");
                tags.add(specimenLabelInImage);
                DicomTag volumetricProps = new DicomTag(DicomAttribute.VOLUMETRIC_PROPERTIES, DicomVR.CS);
                volumetricProps.value = this.padString("VOLUME");
                tags.add(volumetricProps);
                DicomTag opticalPathCount = new DicomTag(DicomAttribute.NUMBER_OPTICAL_PATHS, DicomVR.UL);
                opticalPathCount.value = new long[]{r.getChannelCount(pyramid)};
                tags.add(opticalPathCount);
                DicomTag opticalSequence = new DicomTag(DicomAttribute.OPTICAL_PATH_SEQUENCE, DicomVR.SQ);
                for (int c = 0; c < r.getChannelCount(pyramid); ++c) {
                    boolean rgb = (Integer)r.getChannelSamplesPerPixel(pyramid, c).getValue() > 1;
                    opticalSequence.children.add(this.makeItem());
                    DicomTag illuminationTypeCodes = new DicomTag(DicomAttribute.ILLUMINATION_TYPE_CODE_SEQUENCE, DicomVR.SQ);
                    illuminationTypeCodes.children.add(this.makeItem());
                    DicomTag illuminationTypeCodeValue = new DicomTag(DicomAttribute.CODE_VALUE, DicomVR.SH);
                    illuminationTypeCodeValue.value = this.padString(rgb ? "111744" : "111743");
                    illuminationTypeCodes.children.add(illuminationTypeCodeValue);
                    DicomTag illuminationTypeCodingScheme = new DicomTag(DicomAttribute.CODING_SCHEME_DESIGNATOR, DicomVR.SH);
                    illuminationTypeCodingScheme.value = this.padString("DCM");
                    illuminationTypeCodes.children.add(illuminationTypeCodingScheme);
                    DicomTag illuminationTypeCodeMeaning = new DicomTag(DicomAttribute.CODE_MEANING, DicomVR.LO);
                    illuminationTypeCodeMeaning.value = this.padString(rgb ? "Brightfield illumination" : "Epifluorescence illumination");
                    illuminationTypeCodes.children.add(illuminationTypeCodeMeaning);
                    illuminationTypeCodes.children.add(this.makeItemDelimitation());
                    opticalSequence.children.add(illuminationTypeCodes);
                    DicomTag wavelength = new DicomTag(DicomAttribute.ILLUMINATION_WAVELENGTH, DicomVR.FL);
                    Length wave = this.fixUnits(r.getChannelEmissionWavelength(pyramid, c));
                    wavelength.value = new float[]{wave == null ? 1.0f : wave.value(UNITS.NM).floatValue()};
                    opticalSequence.children.add(wavelength);
                    if (rgb) {
                        DicomTag iccProfile = new DicomTag(DicomAttribute.ICC_PROFILE, DicomVR.OB);
                        iccProfile.value = ICC_Profile.getInstance(1000).getData();
                        opticalSequence.children.add(iccProfile);
                    }
                    DicomTag opticalID = new DicomTag(DicomAttribute.OPTICAL_PATH_ID, DicomVR.SH);
                    opticalID.value = this.padString(String.valueOf(c));
                    opticalSequence.children.add(opticalID);
                    DicomTag opticalDescription = new DicomTag(DicomAttribute.OPTICAL_PATH_DESCRIPTION, DicomVR.ST);
                    opticalDescription.value = this.padString(r.getChannelName(pyramid, c));
                    opticalSequence.children.add(opticalDescription);
                    opticalSequence.children.add(this.makeItemDelimitation());
                }
                tags.add(opticalSequence);
                DicomTag sharedGroupsSequence = new DicomTag(DicomAttribute.SHARED_FUNCTIONAL_GROUPS_SEQUENCE, DicomVR.SQ);
                sharedGroupsSequence.children.add(this.makeItem());
                DicomTag pixelMeasuresSequence = new DicomTag(DicomAttribute.PIXEL_MEASURES_SEQUENCE, DicomVR.SQ);
                pixelMeasuresSequence.children.add(this.makeItem());
                DicomTag sliceThickness = new DicomTag(DicomAttribute.SLICE_THICKNESS, DicomVR.DS);
                DicomTag sliceSpace = new DicomTag(DicomAttribute.SLICE_SPACING, DicomVR.DS);
                Length physicalZ = this.fixUnits(r.getPixelsPhysicalSizeZ(pyramid));
                if (physicalZ != null) {
                    double pz = physicalZ.value(UNITS.MM).doubleValue();
                    sliceThickness.value = this.padString(this.formatFixedWidth(pz, 16));
                } else {
                    sliceThickness.value = this.padString(UID_DEFAULT_ROOT);
                }
                sliceSpace.value = sliceThickness.value;
                pixelMeasuresSequence.children.add(sliceThickness);
                pixelMeasuresSequence.children.add(sliceSpace);
                DicomTag pixelSpacing = new DicomTag(DicomAttribute.PIXEL_SPACING, DicomVR.DS);
                Length physicalX = this.fixUnits(r.getPixelsPhysicalSizeX(pyramid));
                Length physicalY = this.fixUnits(r.getPixelsPhysicalSizeY(pyramid));
                double px = physicalX == null ? 1.0 : physicalX.value(UNITS.MM).doubleValue();
                double py = physicalY == null ? 1.0 : physicalY.value(UNITS.MM).doubleValue();
                pixelSpacing.value = this.padString(this.formatFixedWidth(px, 15) + "\\" + this.formatFixedWidth(py, 15));
                pixelMeasuresSequence.children.add(pixelSpacing);
                pixelMeasuresSequence.children.add(this.makeItemDelimitation());
                sharedGroupsSequence.children.add(pixelMeasuresSequence);
                DicomTag wsiFrameType = new DicomTag(DicomAttribute.WHOLE_SLIDE_FRAME_TYPE_SEQUENCE, DicomVR.SQ);
                DicomTag frameType = new DicomTag(DicomAttribute.FRAME_TYPE, DicomVR.CS);
                frameType.value = imageType.value;
                wsiFrameType.children.add(frameType);
                sharedGroupsSequence.children.add(wsiFrameType);
                sharedGroupsSequence.children.add(this.makeItemDelimitation());
                tags.add(sharedGroupsSequence);
                DicomTag volumeWidth = new DicomTag(DicomAttribute.IMAGED_VOLUME_WIDTH, DicomVR.FL);
                volumeWidth.value = new float[]{physicalX == null ? 1.0f : physicalX.value(UNITS.MM).floatValue() * (float)width};
                tags.add(volumeWidth);
                DicomTag volumeHeight = new DicomTag(DicomAttribute.IMAGED_VOLUME_HEIGHT, DicomVR.FL);
                volumeHeight.value = new float[]{physicalY == null ? 1.0f : physicalY.value(UNITS.MM).floatValue() * (float)height};
                tags.add(volumeHeight);
                DicomTag volumeDepth = new DicomTag(DicomAttribute.IMAGED_VOLUME_DEPTH, DicomVR.FL);
                volumeDepth.value = new float[]{physicalZ == null ? 1.0f : physicalZ.value(UNITS.MM).floatValue() * (float)sizeZ};
                tags.add(volumeDepth);
                DicomTag originSequence = new DicomTag(DicomAttribute.TOTAL_PIXEL_MATRIX_ORIGIN_SEQUENCE, DicomVR.SQ);
                originSequence.children.add(this.makeItem());
                DicomTag xOffset = new DicomTag(DicomAttribute.X_OFFSET_IN_SLIDE, DicomVR.DS);
                xOffset.value = this.padString("0");
                originSequence.children.add(xOffset);
                DicomTag yOffset = new DicomTag(DicomAttribute.Y_OFFSET_IN_SLIDE, DicomVR.DS);
                yOffset.value = this.padString("0");
                originSequence.children.add(yOffset);
                originSequence.children.add(this.makeItemDelimitation());
                tags.add(originSequence);
                DicomTag imageOrientation = new DicomTag(DicomAttribute.SLIDE_IMAGE_ORIENTATION, DicomVR.DS);
                imageOrientation.value = this.padString("1\\0\\0\\0\\1\\0");
                tags.add(imageOrientation);
                if (!this.isReallySequential()) {
                    this.planeOffsets[resolutionIndex] = new PlaneOffset[this.getPlaneCount(pyramid) * tileCountX * tileCountY];
                    DicomTag perFrameSequence = new DicomTag(DicomAttribute.PER_FRAME_FUNCTIONAL_GROUPS_SEQUENCE, DicomVR.SQ);
                    for (int p = 0; p < this.planeOffsets[resolutionIndex].length; ++p) {
                        perFrameSequence.children.add(this.makeItem());
                        DicomTag frameContentSequence = new DicomTag(DicomAttribute.FRAME_CONTENT_SEQUENCE, DicomVR.SQ);
                        frameContentSequence.children.add(this.makeItem());
                        DicomTag dimensionIndexValues = new DicomTag(DicomAttribute.DIMENSION_INDEX_VALUES, DicomVR.UL);
                        dimensionIndexValues.value = new long[]{1L, 1L};
                        frameContentSequence.children.add(dimensionIndexValues);
                        frameContentSequence.children.add(this.makeItemDelimitation());
                        perFrameSequence.children.add(frameContentSequence);
                        DicomTag opticalPath = new DicomTag(DicomAttribute.OPTICAL_PATH_ID_SEQUENCE, DicomVR.SQ);
                        DicomTag opticalPathID = new DicomTag(DicomAttribute.OPTICAL_PATH_ID, DicomVR.SH);
                        opticalPathID.value = this.padString("0");
                        opticalPath.children.add(opticalPathID);
                        perFrameSequence.children.add(opticalPath);
                        DicomTag plane = new DicomTag(DicomAttribute.PLANE_POSITION_SLIDE_SEQUENCE, DicomVR.SQ);
                        plane.children.add(this.makeItem());
                        DicomTag offsetX = new DicomTag(DicomAttribute.X_OFFSET_IN_SLIDE, DicomVR.DS);
                        double ox = physicalX.value(UNITS.MM).floatValue() * (float)width;
                        offsetX.value = this.padString(physicalX == null ? "0" : this.padString(this.formatFixedWidth(ox, 16)));
                        plane.children.add(offsetX);
                        DicomTag offsetY = new DicomTag(DicomAttribute.Y_OFFSET_IN_SLIDE, DicomVR.DS);
                        double oy = physicalY.value(UNITS.MM).floatValue() * (float)height;
                        offsetY.value = this.padString(physicalY == null ? "0" : this.padString(this.formatFixedWidth(oy, 16)));
                        plane.children.add(offsetY);
                        DicomTag positionZ = new DicomTag(DicomAttribute.Z_OFFSET_IN_SLIDE, DicomVR.DS);
                        positionZ.value = this.padString("0");
                        plane.children.add(positionZ);
                        DicomTag positionX = new DicomTag(DicomAttribute.COLUMN_POSITION_IN_MATRIX, DicomVR.SL);
                        positionX.value = new int[]{1};
                        plane.children.add(positionX);
                        DicomTag positionY = new DicomTag(DicomAttribute.ROW_POSITION_IN_MATRIX, DicomVR.SL);
                        positionY.value = new int[]{1};
                        plane.children.add(positionY);
                        plane.children.add(this.makeItemDelimitation());
                        perFrameSequence.children.add(plane);
                        perFrameSequence.children.add(this.makeItemDelimitation());
                    }
                    tags.add(perFrameSequence);
                }
                DicomTag patientName = new DicomTag(DicomAttribute.PATIENT_NAME, DicomVR.PN);
                patientName.value = this.padString("");
                tags.add(patientName);
                DicomTag patientID = new DicomTag(DicomAttribute.PATIENT_ID, DicomVR.LO);
                patientID.value = this.padString("");
                tags.add(patientID);
                DicomTag patientBirthDate = new DicomTag(DicomAttribute.PATIENT_BIRTH_DATE, DicomVR.DA);
                patientBirthDate.value = this.padString("");
                tags.add(patientBirthDate);
                DicomTag patientSex = new DicomTag(DicomAttribute.PATIENT_SEX, DicomVR.CS);
                patientSex.value = this.padString("");
                tags.add(patientSex);
                DicomTag studyID = new DicomTag(DicomAttribute.STUDY_ID, DicomVR.SH);
                studyID.value = this.padString("");
                tags.add(studyID);
                DicomTag studyDate = new DicomTag(DicomAttribute.STUDY_DATE, DicomVR.DA);
                studyDate.value = this.padString("");
                tags.add(studyDate);
                DicomTag studyTime = new DicomTag(DicomAttribute.STUDY_TIME, DicomVR.TM);
                studyTime.value = this.padString("");
                tags.add(studyTime);
                DicomTag accessionNumber = new DicomTag(DicomAttribute.ACCESSION_NUMBER, DicomVR.SH);
                accessionNumber.value = this.padString("");
                tags.add(accessionNumber);
                DicomTag manufacturer = new DicomTag(DicomAttribute.MANUFACTURER, DicomVR.LO);
                manufacturer.value = this.padString("UNKNOWN");
                tags.add(manufacturer);
                DicomTag manufacturerModelName = new DicomTag(DicomAttribute.MANUFACTURER_MODEL_NAME, DicomVR.LO);
                manufacturerModelName.value = this.padString("UNKNOWN");
                tags.add(manufacturerModelName);
                DicomTag deviceSerialNumber = new DicomTag(DicomAttribute.DEVICE_SERIAL_NUMBER, DicomVR.LO);
                deviceSerialNumber.value = this.padString("UNKNOWN");
                tags.add(deviceSerialNumber);
                DicomTag softwareVersion = new DicomTag(DicomAttribute.SOFTWARE_VERSION, DicomVR.LO);
                softwareVersion.value = this.padString("UNKNOWN");
                tags.add(softwareVersion);
                DicomTag focus = new DicomTag(DicomAttribute.FOCUS_METHOD, DicomVR.CS);
                focus.value = this.padString("MANUAL");
                tags.add(focus);
                DicomTag burnedAnnotation = new DicomTag(DicomAttribute.BURNED_IN_ANNOTATION, DicomVR.CS);
                burnedAnnotation.value = this.padString("YES");
                tags.add(burnedAnnotation);
                DicomTag referringPhysician = new DicomTag(DicomAttribute.REFERRING_PHYSICIAN_NAME, DicomVR.PN);
                referringPhysician.value = this.padString("");
                tags.add(referringPhysician);
                DicomTag containerID = new DicomTag(DicomAttribute.CONTAINER_ID, DicomVR.LO);
                containerID.value = this.padString("UNKNOWN");
                tags.add(containerID);
                DicomTag containerIDSequence = new DicomTag(DicomAttribute.CONTAINER_ID_ISSUER_SEQUENCE, DicomVR.SQ);
                tags.add(containerIDSequence);
                DicomTag containerTypeCodeSequence = new DicomTag(DicomAttribute.CONTAINER_TYPE_CODE_SEQUENCE, DicomVR.SQ);
                tags.add(containerTypeCodeSequence);
                DicomTag specimenDescription = new DicomTag(DicomAttribute.SPECIMEN_DESCRIPTION_SEQUENCE, DicomVR.SQ);
                specimenDescription.children.add(this.makeItem());
                DicomTag specimenID = new DicomTag(DicomAttribute.SPECIMEN_ID, DicomVR.LO);
                specimenID.value = containerID.value;
                specimenDescription.children.add(specimenID);
                DicomTag specimenUID = new DicomTag(DicomAttribute.SPECIMEN_UID, DicomVR.UI);
                specimenUID.value = this.padUID(specimenUIDValue);
                specimenDescription.children.add(specimenUID);
                DicomTag specimenIDIssuer = new DicomTag(DicomAttribute.SPECIMEN_ID_ISSUER_SEQUENCE, DicomVR.SQ);
                specimenDescription.children.add(specimenIDIssuer);
                DicomTag specimenPrep = new DicomTag(DicomAttribute.SPECIMEN_PREP_SEQUENCE, DicomVR.SQ);
                specimenDescription.children.add(specimenPrep);
                specimenDescription.children.add(this.makeItemDelimitation());
                tags.add(specimenDescription);
                DicomTag acquisitionContext = new DicomTag(DicomAttribute.ACQUISITION_CONTEXT_SEQUENCE, DicomVR.SQ);
                tags.add(acquisitionContext);
                if (type.indexOf("LABEL") > 0) {
                    Iterator barcode = new DicomTag(DicomAttribute.BARCODE_VALUE, DicomVR.LT);
                    ((DicomTag)((Object)barcode)).value = this.padString("");
                    tags.add((DicomTag)((Object)barcode));
                    DicomTag labelText = new DicomTag(DicomAttribute.LABEL_TEXT, DicomVR.UT);
                    labelText.value = this.padString("");
                    tags.add(labelText);
                }
                for (ITagProvider provider : this.tagProviders) {
                    for (DicomTag t : provider.getTags()) {
                        boolean validTag = t.validate(tags);
                        if (validTag) {
                            this.padTagValues(t);
                            LOGGER.trace("handling supplemental tag ({}) with strategy {}", (Object)t, (Object)t.strategy);
                            switch (t.strategy) {
                                case APPEND: {
                                    if (t.vr == DicomVR.SQ) {
                                        DicomTag existingSequence = this.lookupTag(tags, t);
                                        if (existingSequence == null) {
                                            tags.add(t);
                                            break;
                                        }
                                        existingSequence.children.add(this.makeItem());
                                        for (DicomTag child : t.children) {
                                            existingSequence.children.add(child);
                                        }
                                        existingSequence.children.add(this.makeItemDelimitation());
                                        break;
                                    }
                                    tags.add(t);
                                    break;
                                }
                                case IGNORE: {
                                    DicomTag existing = this.lookupTag(tags, t);
                                    if (existing != null) break;
                                    tags.add(t);
                                    break;
                                }
                                case REPLACE: {
                                    DicomTag replace = this.lookupTag(tags, t);
                                    if (replace != null) {
                                        tags.remove(replace);
                                    }
                                    tags.add(t);
                                }
                            }
                            continue;
                        }
                        LOGGER.warn("Ignoring tag {} from provider {}", (Object)t, (Object)provider);
                    }
                }
                tags.sort(null);
                for (DicomTag tag : tags) {
                    this.writeTag(tag);
                }
                DicomTag pixelData = new DicomTag(DicomAttribute.PIXEL_DATA, DicomVR.OB);
                pixelData.elementLength = -1;
                this.writeTag(pixelData);
                this.pixelDataLengthPointer[resolutionIndex] = this.out.getFilePointer() - 4L;
                if (this.writeDualPersonality()) {
                    for (int plane = 0; plane < this.ifds[resolutionIndex].length; ++plane) {
                        int c = this.getZCTCoords(plane)[1];
                        boolean rgb = nChannels > 1;
                        IFD ifd = new IFD();
                        ifd.put(0, this.out.isLittleEndian());
                        ifd.put(256, Long.valueOf(width));
                        ifd.put(257, Long.valueOf(height));
                        ifd.put(322, this.tileWidth[resolutionIndex]);
                        ifd.put(323, this.tileHeight[resolutionIndex]);
                        ifd.put(259, this.getTIFFCompression().getCode());
                        ifd.put(284, 1);
                        int sampleFormat = 1;
                        if (FormatTools.isFloatingPoint((int)pixelTypeCode)) {
                            sampleFormat = 3;
                        } else if (FormatTools.isSigned((int)pixelTypeCode)) {
                            sampleFormat = 2;
                        }
                        ifd.put(339, sampleFormat);
                        int[] bps = new int[rgb ? nChannels : 1];
                        Arrays.fill(bps, FormatTools.getBytesPerPixel((int)pixelTypeCode) * 8);
                        ifd.put(258, bps);
                        ifd.put(262, rgb ? PhotoInterp.RGB.getCode() : PhotoInterp.BLACK_IS_ZERO.getCode());
                        ifd.put(277, bps.length);
                        ifd.put(305, FormatTools.CREATOR);
                        int tileCount = tileCountX * tileCountY;
                        ifd.put(325, new long[tileCount]);
                        ifd.put(324, new long[tileCount]);
                        ifd.put(296, 3);
                        ifd.put(282, this.getPhysicalSize(physicalX));
                        ifd.put(283, this.getPhysicalSize(physicalY));
                        this.ifds[resolutionIndex][plane] = ifd;
                    }
                }
                resolutionWatch.stop("wrote metadata for series=" + pyramid + ", resolution=" + res);
            }
        }
        this.setSeries(0);
        initWatch.stop("finished initialization");
    }

    public void close() throws IOException {
        if (this.writeDualPersonality()) {
            Slf4JStopWatch ifdWatch = this.stopWatch();
            MetadataRetrieve r = this.getMetadataRetrieve();
            for (int pyramid = 0; pyramid < r.getImageCount(); ++pyramid) {
                int resolutionCount = 1;
                if (r instanceof IPyramidStore) {
                    resolutionCount = ((IPyramidStore)r).getResolutionCount(pyramid);
                }
                for (int res = 0; res < resolutionCount; ++res) {
                    this.resolution = res;
                    this.openFile(pyramid, this.resolution);
                    if (this.out == null) continue;
                    int resolutionIndex = this.getIndex(pyramid, this.resolution);
                    this.out.seek(this.out.length());
                    DicomTag trailingPadding = new DicomTag(DicomAttribute.TRAILING_PADDING, DicomVR.OB);
                    trailingPadding.elementLength = -1;
                    this.writeTag(trailingPadding);
                    this.out.seek(this.out.length());
                    long fp = this.out.getFilePointer();
                    this.writeIFDs(resolutionIndex);
                    long length = this.out.getFilePointer() - fp;
                    if (length % 2L == 1L) {
                        this.out.writeByte(0);
                        ++length;
                    }
                    this.out.seek(fp - 4L);
                    this.out.writeInt((int)length);
                }
            }
            ifdWatch.stop("wrote final IFDs");
        }
        super.close();
        this.uids = null;
        this.pixelDataSize = null;
        this.pixelDataLengthPointer = null;
        this.transferSyntaxPointer = null;
        this.compressionMethodPointer = null;
        this.fileMetaLengthPointer = 0L;
        this.nextIFDPointer = null;
        this.ifds = null;
        this.tiffSaver = null;
        this.validPixelCount = null;
        this.tileWidthPointer = null;
        this.tileHeightPointer = null;
        this.tileCountPointer = null;
        this.tagProviders.clear();
    }

    public int setTileSizeX(int tileSize) throws FormatException {
        if (this.currentId == null) {
            this.baseTileWidth = tileSize;
            return this.baseTileWidth;
        }
        int resolutionIndex = this.getIndex(this.series, this.resolution);
        this.tileWidth[resolutionIndex] = tileSize;
        return this.tileWidth[resolutionIndex];
    }

    public int getTileSizeX() {
        if (this.currentId == null) {
            return this.baseTileWidth;
        }
        int resolutionIndex = this.getIndex(this.series, this.resolution);
        return this.tileWidth[resolutionIndex];
    }

    public int setTileSizeY(int tileSize) throws FormatException {
        if (this.currentId == null) {
            this.baseTileHeight = tileSize;
            return this.baseTileHeight;
        }
        int resolutionIndex = this.getIndex(this.series, this.resolution);
        this.tileHeight[resolutionIndex] = tileSize;
        return this.tileHeight[resolutionIndex];
    }

    public int getTileSizeY() {
        if (this.currentId == null) {
            return this.baseTileHeight;
        }
        int resolutionIndex = this.getIndex(this.series, this.resolution);
        return this.tileHeight[resolutionIndex];
    }

    public String getUIDRoot() {
        MetadataOptions options = this.getMetadataOptions();
        if (options instanceof DynamicMetadataOptions) {
            String string = ((DynamicMetadataOptions)options).get(UID_ROOT_KEY, UID_DEFAULT_ROOT);
        }
        return UID_DEFAULT_ROOT;
    }

    private int getStoredLength(DicomTag tag) {
        if (tag.vr == DicomVR.SQ) {
            return -1;
        }
        if (tag.elementLength != 0) {
            return tag.elementLength;
        }
        if (tag.value != null) {
            if (tag.value instanceof String) {
                return ((String)tag.value).length();
            }
            return tag.vr.getWidth() * Array.getLength(tag.value);
        }
        int length = 0;
        for (DicomTag child : tag.children) {
            length += this.getStoredLength(child);
        }
        return length;
    }

    private void writeTag(DicomTag tag) throws IOException {
        this.writeTag(tag, this.out);
    }

    private void writeTag(DicomTag tag, RandomAccessOutputStream output) throws IOException {
        Slf4JStopWatch tagWatch = this.stopWatch();
        int tagCode = tag.attribute == null ? tag.tag : tag.attribute.getTag();
        output.writeShort((short)((tagCode & 0xFFFF0000) >> 16));
        output.writeShort((short)(tagCode & 0xFFFF));
        if (tag.vr == DicomVR.IMPLICIT) {
            output.writeInt(this.getStoredLength(tag));
        } else {
            boolean order = output.isLittleEndian();
            output.order(false);
            output.writeShort(tag.vr.getCode());
            output.order(order);
            if (tag.vr == DicomVR.OB || tag.vr == DicomVR.OW || tag.vr == DicomVR.SQ || tag.vr == DicomVR.UN || tag.vr == DicomVR.UT || tag.vr == DicomVR.UC) {
                output.writeShort(0);
                output.writeInt(this.getStoredLength(tag));
            } else {
                output.writeShort((short)this.getStoredLength(tag));
            }
            int resolutionIndex = this.getIndex(this.series, this.resolution);
            if (tag.attribute == DicomAttribute.TRANSFER_SYNTAX_UID) {
                this.transferSyntaxPointer[resolutionIndex] = output.getFilePointer();
            } else if (tag.attribute == DicomAttribute.LOSSY_IMAGE_COMPRESSION_METHOD) {
                this.compressionMethodPointer[resolutionIndex] = output.getFilePointer();
            } else if (tag.attribute == DicomAttribute.FILE_META_INFO_GROUP_LENGTH) {
                this.fileMetaLengthPointer = output.getFilePointer();
            } else if (tag.attribute == DicomAttribute.ROWS) {
                this.tileHeightPointer[resolutionIndex] = this.out.getFilePointer();
            } else if (tag.attribute == DicomAttribute.COLUMNS) {
                this.tileWidthPointer[resolutionIndex] = this.out.getFilePointer();
            } else if (tag.attribute == DicomAttribute.NUMBER_OF_FRAMES) {
                this.tileCountPointer[resolutionIndex] = this.out.getFilePointer();
            }
            if (tag.children.size() == 0 && tag.value == null && tag.vr != DicomVR.SQ) {
                if (tag.attribute != DicomAttribute.PIXEL_DATA) {
                    output.skipBytes(tag.elementLength);
                }
                return;
            }
        }
        if (this.currentPlane != null && tag.attribute == DicomAttribute.DIMENSION_INDEX_VALUES) {
            Integer order = this.currentPlane;
            this.currentPlane = this.currentPlane + 1;
        }
        if (tag.children.size() > 0 || tag.value == null && tag.vr == DicomVR.SQ) {
            if (tag.attribute == DicomAttribute.PER_FRAME_FUNCTIONAL_GROUPS_SEQUENCE) {
                this.currentPlane = -1;
            }
            if (tag.children.size() > 0 && tag.children.get((int)0).attribute == DicomAttribute.ITEM) {
                for (DicomTag child : tag.children) {
                    this.writeTag(child);
                }
            } else {
                for (DicomTag child : tag.children) {
                    if (tag.vr == DicomVR.SQ) {
                        this.writeTag(this.makeItem());
                    }
                    this.writeTag(child);
                    if (tag.vr != DicomVR.SQ) continue;
                    this.writeTag(this.makeItemDelimitation());
                }
            }
            if (tag.vr == DicomVR.SQ) {
                DicomTag finalItem = new DicomTag(DicomAttribute.SEQUENCE_DELIMITATION_ITEM, DicomVR.IMPLICIT);
                finalItem.elementLength = 0;
                this.writeTag(finalItem);
            }
            if (tag.attribute == DicomAttribute.PER_FRAME_FUNCTIONAL_GROUPS_SEQUENCE) {
                this.currentPlane = null;
            }
        } else if (tag.value != null) {
            if (this.currentPlane != null && this.currentPlane >= 0) {
                int resolutionIndex = this.getIndex(this.series, this.resolution);
                if (this.planeOffsets[resolutionIndex][this.currentPlane] == null) {
                    this.planeOffsets[resolutionIndex][this.currentPlane.intValue()] = new PlaneOffset();
                }
                switch (tag.attribute) {
                    case OPTICAL_PATH_ID: {
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].cOffset = output.getFilePointer();
                        break;
                    }
                    case ROW_POSITION_IN_MATRIX: {
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].yOffset = output.getFilePointer();
                        break;
                    }
                    case COLUMN_POSITION_IN_MATRIX: {
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].xOffset = output.getFilePointer();
                        break;
                    }
                    case DIMENSION_INDEX_VALUES: {
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].dimensionIndex = output.getFilePointer();
                        break;
                    }
                    case X_OFFSET_IN_SLIDE: {
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].xOffsetReal = output.getFilePointer();
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].xOffsetSize = tag.elementLength;
                        break;
                    }
                    case Y_OFFSET_IN_SLIDE: {
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].yOffsetReal = output.getFilePointer();
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].yOffsetSize = tag.elementLength;
                        break;
                    }
                    case Z_OFFSET_IN_SLIDE: {
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].zOffset = output.getFilePointer();
                        this.planeOffsets[resolutionIndex][this.currentPlane.intValue()].zOffsetSize = tag.elementLength;
                    }
                }
            }
            switch (tag.vr) {
                case AE: 
                case AS: 
                case CS: 
                case DA: 
                case DS: 
                case DT: 
                case IS: 
                case LO: 
                case LT: 
                case PN: 
                case SH: 
                case ST: 
                case TM: 
                case UC: 
                case UI: 
                case UR: 
                case UT: {
                    output.writeBytes(tag.value.toString());
                    break;
                }
                case AT: {
                    for (short s : (short[])tag.value) {
                        output.writeShort(s);
                    }
                    break;
                }
                case FL: {
                    for (float f : (float[])tag.value) {
                        output.writeFloat(f);
                    }
                    break;
                }
                case FD: {
                    for (double d : (double[])tag.value) {
                        output.writeDouble(d);
                    }
                    break;
                }
                case OB: {
                    output.write((byte[])tag.value);
                    break;
                }
                case SL: {
                    for (int v : (int[])tag.value) {
                        output.writeInt(v);
                    }
                    break;
                }
                case SS: {
                    for (short s : (short[])tag.value) {
                        output.writeShort(s);
                    }
                    break;
                }
                case SV: {
                    for (long v : (long[])tag.value) {
                        output.writeLong(v);
                    }
                    break;
                }
                case UL: {
                    for (long v : (long[])tag.value) {
                        output.writeInt((int)(v & 0xFFFFFFFFFFFFFFFFL));
                    }
                    break;
                }
                case US: {
                    for (short s : (short[])tag.value) {
                        output.writeShort(s);
                    }
                    break;
                }
                case IMPLICIT: {
                    output.write((byte[])tag.value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(tag.vr.getCode()));
                }
            }
        }
        tagWatch.stop("wrote single tag: " + tag);
    }

    private String padString(String value) {
        return this.padString(value, " ");
    }

    private String padUID(String value) {
        return this.padString(value, "\u0000");
    }

    private String padString(String value, String append) {
        if (value == null) {
            return "";
        }
        if (value.length() % 2 == 0) {
            return value;
        }
        return value + append;
    }

    private String padString(String value, String append, int length) {
        String rtn = "";
        if (value != null) {
            rtn = rtn + value;
        }
        while (rtn.length() < length) {
            rtn = rtn + append;
        }
        return rtn;
    }

    private String getTransferSyntax() {
        String transferSyntax = null;
        if (this.compression == null || this.compression.equals(CompressionType.UNCOMPRESSED.getCompression())) {
            transferSyntax = this.out.isLittleEndian() ? "1.2.840.10008.1.2.1" : "1.2.840.10008.1.2.2";
        } else if (this.compression.equals(CompressionType.J2K.getCompression())) {
            transferSyntax = "1.2.840.10008.1.2.4.91";
        } else if (this.compression.equals(CompressionType.JPEG.getCompression())) {
            transferSyntax = "1.2.840.10008.1.2.4.50";
        }
        return this.padString(transferSyntax);
    }

    private String getCompressionMethod() {
        if (this.compression != null) {
            if (this.compression.equals(CompressionType.J2K.getCompression())) {
                return this.padString("ISO_15444_1");
            }
            if (this.compression.equals(CompressionType.JPEG.getCompression())) {
                return this.padString("ISO_10918_1");
            }
        }
        return this.padString("NOT_DEFINED");
    }

    private void openFile(int pyramid, int res) throws IOException {
        if (this.pixelDataLengthPointer == null) {
            return;
        }
        Slf4JStopWatch openWatch = this.stopWatch();
        if (this.out != null) {
            this.out.close();
        }
        String filename = this.getFilename(pyramid, res);
        this.out = new RandomAccessOutputStream(filename);
        this.tiffSaver = new TiffSaver(this.out, filename);
        this.tiffSaver.setBigTiff(this.bigTiff);
        MetadataRetrieve r = this.getMetadataRetrieve();
        boolean littleEndian = false;
        if (r.getPixelsBigEndian(pyramid) != null) {
            littleEndian = r.getPixelsBigEndian(pyramid) == false;
        } else if (r.getPixelsBinDataCount(pyramid) == 0) {
            littleEndian = r.getPixelsBinDataBigEndian(pyramid, 0) == false;
        }
        this.out.order(littleEndian);
        if (this.out.length() == 0L) {
            this.writeHeader();
        }
        openWatch.stop("opened " + filename);
    }

    private void writeHeader() throws IOException {
        Slf4JStopWatch headerWatch = this.stopWatch();
        ByteArrayHandle buffer = new ByteArrayHandle();
        RandomAccessOutputStream headerBuffer = new RandomAccessOutputStream(buffer);
        boolean littleEndian = this.out.isLittleEndian();
        headerBuffer.order(littleEndian);
        if (this.writeDualPersonality()) {
            if (littleEndian) {
                headerBuffer.writeByte(73);
                headerBuffer.writeByte(73);
            } else {
                headerBuffer.writeByte(77);
                headerBuffer.writeByte(77);
            }
            if (this.bigTiff) {
                headerBuffer.writeShort(43);
                headerBuffer.writeShort(8);
                headerBuffer.writeShort(0);
                this.nextIFDPointer[this.getIndex((int)this.series, (int)this.resolution)] = headerBuffer.getFilePointer();
                headerBuffer.writeLong(-1L);
            } else {
                headerBuffer.writeShort(42);
                this.nextIFDPointer[this.getIndex((int)this.series, (int)this.resolution)] = headerBuffer.getFilePointer();
                headerBuffer.writeInt(-1);
            }
        } else {
            byte[] preamble = new byte[128];
            headerBuffer.write(preamble);
        }
        headerBuffer.seek(128L);
        headerBuffer.order(true);
        headerBuffer.writeBytes("DICM");
        DicomTag fileMetaLength = new DicomTag(DicomAttribute.FILE_META_INFO_GROUP_LENGTH, DicomVR.UL);
        fileMetaLength.value = new long[]{0L};
        this.writeTag(fileMetaLength, headerBuffer);
        DicomTag fileMetaVersion = new DicomTag(DicomAttribute.FILE_META_INFO_VERSION, DicomVR.OB);
        fileMetaVersion.value = new byte[]{0, 1};
        this.writeTag(fileMetaVersion, headerBuffer);
        DicomTag mediaStorageClassUID = new DicomTag(DicomAttribute.MEDIA_SOP_CLASS_UID, DicomVR.UI);
        mediaStorageClassUID.value = this.padUID(SOP_CLASS_UID_VALUE);
        this.writeTag(mediaStorageClassUID, headerBuffer);
        DicomTag mediaStorageInstanceUID = new DicomTag(DicomAttribute.MEDIA_SOP_INSTANCE_UID, DicomVR.UI);
        mediaStorageInstanceUID.value = this.padUID(this.instanceUIDValue);
        this.writeTag(mediaStorageInstanceUID, headerBuffer);
        DicomTag transferSyntaxUID = new DicomTag(DicomAttribute.TRANSFER_SYNTAX_UID, DicomVR.UI);
        transferSyntaxUID.elementLength = 22;
        this.writeTag(transferSyntaxUID, headerBuffer);
        DicomTag implementationClassUID = new DicomTag(DicomAttribute.IMPLEMENTATION_UID, DicomVR.UI);
        implementationClassUID.value = this.padUID(this.implementationUID);
        this.writeTag(implementationClassUID, headerBuffer);
        DicomTag implementationVersionName = new DicomTag(DicomAttribute.IMPLEMENTATION_VERSION, DicomVR.SH);
        implementationVersionName.value = this.padString(FormatTools.VERSION);
        this.writeTag(implementationVersionName, headerBuffer);
        int bufferBytes = (int)headerBuffer.getFilePointer();
        this.out.order(headerBuffer.isLittleEndian());
        headerBuffer.close();
        this.out.write(buffer.getBytes(), 0, bufferBytes);
        int fileMetaBytes = (int)(this.out.getFilePointer() - this.fileMetaLengthPointer - 4L);
        this.out.seek(this.fileMetaLengthPointer);
        this.out.writeInt(fileMetaBytes);
        this.fileMetaLengthPointer = 0L;
        this.out.skipBytes(fileMetaBytes);
        this.out.order(littleEndian);
        headerWatch.stop("wrote header for series = " + this.series + ", resolution = " + this.resolution);
    }

    private String getFilename(int pyramid, int res) {
        if (this.pixelDataLengthPointer.length == 1) {
            return this.currentId;
        }
        String base = new Location(this.currentId).getAbsolutePath();
        base = base.substring(0, base.lastIndexOf("."));
        return String.format("%s_%d_%d.dcm", base, pyramid, res);
    }

    private int getIndex(int pyramid, int res) {
        MetadataRetrieve r = this.getMetadataRetrieve();
        if (r instanceof IPyramidStore) {
            int index = 0;
            for (int i = 0; i < r.getImageCount(); ++i) {
                int resCount = ((IPyramidStore)r).getResolutionCount(i);
                if (i < pyramid) {
                    index += resCount;
                    continue;
                }
                return index + res;
            }
        }
        return pyramid;
    }

    private int[] getZCTCoords(int no) {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        DimensionOrder order = retrieve.getPixelsDimensionOrder(this.series);
        int sizeC = retrieve.getChannelCount(this.series);
        int sizeT = (Integer)retrieve.getPixelsSizeT(this.series).getValue();
        int sizeZ = (Integer)retrieve.getPixelsSizeZ(this.series).getValue();
        return FormatTools.getZCTCoords((String)order.getValue(), (int)sizeZ, (int)sizeC, (int)sizeT, (int)(sizeZ * sizeC * sizeT), (int)no);
    }

    private boolean isReallySequential() {
        MetadataRetrieve retrieve = this.getMetadataRetrieve();
        int sizeC = retrieve.getChannelCount(this.series);
        int sizeT = (Integer)retrieve.getPixelsSizeT(this.series).getValue();
        int sizeZ = (Integer)retrieve.getPixelsSizeZ(this.series).getValue();
        if (retrieve instanceof IPyramidStore && ((IPyramidStore)retrieve).getResolutionCount(this.series) == 1) {
            return sizeC * sizeZ * sizeT == 1;
        }
        DimensionOrder order = retrieve.getPixelsDimensionOrder(this.series);
        return this.sequential && (sizeC == 1 || sizeZ == 1 || order == DimensionOrder.XYZCT || order == DimensionOrder.XYZTC || order == DimensionOrder.XYTZC);
    }

    private String getImageType(String pyramidName, int res, boolean hasPyramid, int resolutionCount) {
        String type = "DERIVED\\PRIMARY\\";
        type = !hasPyramid || resolutionCount > 1 ? type + "VOLUME\\" : (pyramidName != null ? ((pyramidName = pyramidName.toLowerCase()).indexOf("label") >= 0 ? type + "LABEL\\" : (pyramidName.indexOf("macro") >= 0 || pyramidName.indexOf("overview") >= 0 ? type + "OVERVIEW\\" : type + "OVERVIEW\\")) : type + "OVERVIEW\\");
        type = res > 0 ? type + "RESAMPLED" : type + "NONE";
        return type;
    }

    private void writeIFDs(int resIndex) throws IOException {
        long ifdStart = this.out.getFilePointer();
        this.out.seek(this.nextIFDPointer[resIndex]);
        if (this.bigTiff) {
            this.out.writeLong(ifdStart);
        } else {
            this.out.writeInt((int)ifdStart);
        }
        this.out.seek(ifdStart);
        for (int no = 0; no < this.ifds[resIndex].length; ++no) {
            this.ifds[resIndex][no].put(322, this.tileWidth[resIndex]);
            this.ifds[resIndex][no].put(323, this.tileHeight[resIndex]);
            try {
                this.tiffSaver.writeIFD(this.ifds[resIndex][no], 0L, no < this.ifds[resIndex].length - 1);
                continue;
            }
            catch (FormatException e) {
                throw new IOException("Failed to write IFD for coreIndex=" + resIndex + ", plane=" + no, e);
            }
        }
    }

    private TiffCompression getTIFFCompression() {
        if (CompressionType.J2K.getCompression().equals(this.compression)) {
            return TiffCompression.JPEG_2000;
        }
        if (CompressionType.JPEG.getCompression().equals(this.compression)) {
            return TiffCompression.JPEG;
        }
        return TiffCompression.UNCOMPRESSED;
    }

    private DicomTag makeItem() {
        DicomTag item = new DicomTag(DicomAttribute.ITEM, DicomVR.IMPLICIT);
        item.elementLength = -1;
        return item;
    }

    private DicomTag makeItemDelimitation() {
        DicomTag item = new DicomTag(DicomAttribute.ITEM_DELIMITATION_ITEM, DicomVR.IMPLICIT);
        item.elementLength = 0;
        return item;
    }

    private DicomTag lookupTag(List<DicomTag> tags, DicomTag compare) {
        for (DicomTag t : tags) {
            if (t.tag != compare.tag) continue;
            return t;
        }
        return null;
    }

    private void padTagValues(DicomTag t) {
        if (t.value instanceof String) {
            t.value = t.vr == DicomVR.UI ? this.padUID((String)t.value) : this.padString((String)t.value);
        }
        for (DicomTag child : t.children) {
            this.padTagValues(child);
        }
    }

    private short[] makeShortArray(int v) {
        short[] s = new short[]{(short)(v >> 16 & 0xFFFF), (short)(v & 0xFFFF)};
        return s;
    }

    private Length fixUnits(Length size) {
        if (size == null) {
            return null;
        }
        if (size.unit() == UNITS.PIXEL || size.unit() == UNITS.REFERENCEFRAME) {
            LOGGER.warn("Found physical length '{}' in relative units '{}'; this value will be lost", (Object)size.value(), (Object)size.unit());
            return null;
        }
        return size;
    }

    private TiffRational getPhysicalSize(Length size) {
        if (size == null || size.value(UNITS.MICROMETER) == null) {
            return new TiffRational(0L, 1000L);
        }
        Double physicalSize = size.value(UNITS.MICROMETER).doubleValue();
        if (physicalSize != 0.0) {
            physicalSize = 1.0 / physicalSize;
        }
        return new TiffRational((long)(physicalSize * 1000.0 * 10000.0), 1000L);
    }

    private void checkPrecompressedSupport() {
        if (this.compression == null || this.compression.equals(CompressionType.UNCOMPRESSED.getCompression())) {
            throw new UnsupportedOperationException("Pre-compressed tiles not supported for compression: " + this.compression);
        }
        if (!this.isReallySequential()) {
            throw new UnsupportedOperationException("Pre-compressed tiles not supported for TILED_SPARSE");
        }
    }

    private void checkPixelCount(boolean warn) throws FormatException {
        if (this.validPixelCount != null && this.validPixelCount.booleanValue() || this.getCodec() != null) {
            return;
        }
        MetadataRetrieve r = this.getMetadataRetrieve();
        for (int pyramid = 0; pyramid < r.getImageCount(); ++pyramid) {
            long pixels = (long)this.getPlaneCount(pyramid) * (long)this.getSamplesPerPixel(pyramid);
            pixels *= (long)((Integer)r.getPixelsSizeX(pyramid).getValue()).intValue();
            pixels *= (long)((Integer)r.getPixelsSizeY(pyramid).getValue()).intValue();
            int pixelType = FormatTools.pixelTypeFromString((String)r.getPixelsType(pyramid).toString());
            int bpp = FormatTools.getBytesPerPixel((int)pixelType);
            if (!((double)(pixels *= (long)bpp) > Math.pow(2.0, 32.0))) continue;
            this.validPixelCount = false;
            if (warn) {
                LOGGER.warn("More than 4GB of pixel data, compression will need to be used");
                continue;
            }
            throw new FormatException("Cannot write more than 4GB of uncompressed pixel data. Specify a compression type instead.");
        }
        if (this.validPixelCount == null) {
            this.validPixelCount = true;
        }
    }

    private String formatFixedWidth(double v, int width) {
        String formattedFloat = String.format("%." + (width - 1) + "f", v);
        return String.format("%." + width + "s", formattedFloat);
    }

    protected Slf4JStopWatch stopWatch() {
        return new Slf4JStopWatch(LOGGER, 10000);
    }

    class PlaneOffset {
        public long xOffset;
        public long yOffset;
        public long zOffset;
        public long cOffset;
        public long xOffsetReal;
        public long yOffsetReal;
        public long dimensionIndex;
        public int xOffsetSize;
        public int yOffsetSize;
        public int zOffsetSize;
        public boolean written = false;

        PlaneOffset() {
        }
    }

    class UIDCreator {
        private static final int MAX_LEN = 64;
        private String vmid = String.valueOf((long)new VMID().hashCode() & 0xFFFFFFFFL);

        UIDCreator() {
        }

        public String getUID() {
            UID uid = new UID();
            String[] tokens = uid.toString().split(":");
            StringBuffer thisUID = new StringBuffer(DicomWriter.this.getUIDRoot());
            thisUID.append(".");
            thisUID.append(this.vmid);
            for (String token : tokens) {
                thisUID.append(".");
                long v = Long.parseLong(token, 16) & 0xFFFFFFFFL;
                String s = String.valueOf(v);
                while (thisUID.length() + s.length() > 64) {
                    s = String.valueOf(v /= 8L);
                }
                thisUID.append(s);
            }
            return thisUID.toString();
        }
    }
}

