/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.Ptg;

public class BoolPtg
extends Ptg {
    public static final int SIZE = 2;
    public static final byte sid = 29;
    private boolean field_1_value;

    private BoolPtg() {
    }

    public BoolPtg(RecordInputStream in) {
        this.field_1_value = in.readByte() == 1;
    }

    public BoolPtg(String formulaToken) {
        this.field_1_value = formulaToken.equals("TRUE");
    }

    public void setValue(boolean value) {
        this.field_1_value = value;
    }

    public boolean getValue() {
        return this.field_1_value;
    }

    @Override
    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 29;
        array[offset + 1] = (byte)(this.field_1_value ? 1 : 0);
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public String toFormulaString(Workbook book) {
        return this.field_1_value ? "TRUE" : "FALSE";
    }

    @Override
    public byte getDefaultOperandClass() {
        return 32;
    }

    @Override
    public Object clone() {
        BoolPtg ptg = new BoolPtg();
        ptg.field_1_value = this.field_1_value;
        return ptg;
    }
}

