/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.Editor;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.AdminView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;

public abstract class EditorLoader
extends DSCallAdapter {
    protected final Editor viewer;
    protected final Registry registry;
    protected final MetadataHandlerView mhView;
    protected final DataManagerView dmView;
    protected final ImageDataView imView;
    protected final AdminView adminView;
    protected final SecurityContext ctx;

    public EditorLoader(Editor viewer, SecurityContext ctx) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (ctx == null) {
            throw new NullPointerException("No security context.");
        }
        this.ctx = ctx;
        this.viewer = viewer;
        this.registry = MetadataViewerAgent.getRegistry();
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
        this.imView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
        this.adminView = (AdminView)this.registry.getDataServicesView(AdminView.class);
    }

    protected long getCurrentUser() {
        return MetadataViewerAgent.getUserDetails().getId();
    }

    @Override
    public void handleNullResult() {
        this.viewer.setStatus(false);
        LogMessage msg = new LogMessage();
        msg.print("No data returned.");
        this.registry.getLogger().error((Object)this, msg);
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    @Override
    public void handleException(Throwable exc) {
        this.viewer.setStatus(false);
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
    }

    public abstract void load();

    public abstract void cancel();
}

