/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata;

import omero.gateway.SecurityContext;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.browser.TreeBrowserDisplay;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewer;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.AdminView;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.MetadataHandlerView;

public abstract class MetadataLoader
extends DSCallAdapter {
    protected final TreeBrowserDisplay refNode;
    protected final MetadataViewer viewer;
    protected final Registry registry;
    protected final MetadataHandlerView mhView;
    protected final DataManagerView dmView;
    protected final ImageDataView ivView;
    protected final AdminView adminView;
    protected final SecurityContext ctx;
    protected int loaderID;

    protected void handleException(Throwable exc, boolean notify) {
        int state = this.viewer.getState();
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print("State: " + state);
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        if (notify && state != 4) {
            this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        }
        this.viewer.cancel(this.loaderID);
    }

    public MetadataLoader(MetadataViewer viewer, SecurityContext ctx, int loaderID) {
        this(viewer, ctx, null, loaderID);
    }

    public MetadataLoader(MetadataViewer viewer, SecurityContext ctx, TreeBrowserDisplay refNode, int loaderID) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (ctx == null) {
            throw new NullPointerException("No security context.");
        }
        this.ctx = ctx;
        this.viewer = viewer;
        this.refNode = refNode;
        this.loaderID = loaderID;
        this.registry = MetadataViewerAgent.getRegistry();
        this.mhView = (MetadataHandlerView)this.registry.getDataServicesView(MetadataHandlerView.class);
        this.dmView = (DataManagerView)this.registry.getDataServicesView(DataManagerView.class);
        this.ivView = (ImageDataView)this.registry.getDataServicesView(ImageDataView.class);
        this.adminView = (AdminView)this.registry.getDataServicesView(AdminView.class);
    }

    @Override
    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    @Override
    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
    }

    @Override
    public void handleException(Throwable exc) {
        this.handleException(exc, true);
    }

    public abstract void load();

    public abstract void cancel();
}

