/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class AgentsEntry
extends Entry {
    private static final String AGENT_TAG = "agent";
    private static final String AGENT_NAME_TAG = "name";
    private static final String AGENT_CLASS_TAG = "class";
    private static final String AGENT_CONFIG_TAG = "config";
    private static final String AGENT_ACTIVE_TAG = "active";
    private static final String AGENT_NUMBER_TAG = "number";
    private static final int TAGS_NUMBER = 3;
    private List<AgentInfo> agentsList = new ArrayList<AgentInfo>();

    private Map<String, String> extractValues(Node agent) throws DOMException, ConfigException {
        if (!AGENT_TAG.equals(agent.getNodeName())) {
            throw new ConfigException("Unrecognized tag within the agents tag: " + agent.getNodeName());
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        if (agent.hasChildNodes()) {
            NodeList children = agent.getChildNodes();
            int n = children.getLength();
            while (0 < n) {
                Node child;
                if ((child = children.item(--n)).getNodeType() != 1) continue;
                this.extractAgentTag(child, tags);
            }
        }
        if (tags.keySet().size() < 3) {
            throw new ConfigException("Missing tags within agent tag.");
        }
        return tags;
    }

    private void extractAgentTag(Node tag, Map<String, String> values) throws ConfigException {
        String tagName = tag.getNodeName();
        String tagValue = tag.getFirstChild().getNodeValue();
        if (AGENT_NAME_TAG.equals(tagName) || AGENT_CLASS_TAG.equals(tagName) || AGENT_CONFIG_TAG.equals(tagName) || AGENT_ACTIVE_TAG.equals(tagName) || AGENT_NUMBER_TAG.equals(tagName)) {
            values.put(tagName, tagValue);
            return;
        }
        throw new ConfigException("Unrecognized tag within the agent tag: " + tagName);
    }

    AgentsEntry() {
    }

    @Override
    Object getValue() {
        return this.agentsList;
    }

    @Override
    protected void setContent(Node node) throws ConfigException {
        try {
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                int n = children.getLength();
                while (0 < n) {
                    Node child;
                    if ((child = children.item(--n)).getNodeType() != 1) continue;
                    Map<String, String> childTags = this.extractValues(child);
                    AgentInfo info = new AgentInfo();
                    info.setName(childTags.get(AGENT_NAME_TAG));
                    info.setAgentClass(childTags.get(AGENT_CLASS_TAG));
                    info.setConfigPath(childTags.get(AGENT_CONFIG_TAG));
                    info.setActive(childTags.get(AGENT_ACTIVE_TAG));
                    info.setNumber(childTags.get(AGENT_NUMBER_TAG));
                    this.agentsList.add(info);
                }
            }
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse agents entry.", dex);
        }
    }
}

