/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.GroupData;
import omero.gateway.util.PojoMapper;
import omero.model.Experimenter;
import omero.model.ExperimenterGroup;
import omero.model.IObject;
import omero.sys.Roles;
import org.apache.commons.collections4.CollectionUtils;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.AdminService;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.RequestCallback;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.AdminObject;
import org.openmicroscopy.shoola.env.data.model.DiskQuota;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

class AdminServiceImpl
implements AdminService {
    private Registry context;
    private OMEROGateway gateway;

    private ExperimenterData updateExperimenter(SecurityContext ctx, ExperimenterData exp, GroupData group, boolean asAdmin) throws DSOutOfServiceException, DSAccessException {
        ExperimenterData currentUser = (ExperimenterData)this.context.lookup("/current_user/details");
        if (!asAdmin && exp.getId() != currentUser.getId()) {
            return exp;
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        this.gateway.updateExperimenter(ctx, exp.asExperimenter(), currentUser.getId());
        if (group != null && exp.getDefaultGroup().getId() != group.getId()) {
            this.gateway.changeCurrentGroup(ctx, exp, group.getId());
        }
        String userName = uc.getUser().getUsername();
        if (asAdmin) {
            userName = exp.getUserName();
        }
        ExperimenterData data = this.gateway.getUserDetails(ctx, userName, true);
        if (currentUser.getId() != exp.getId()) {
            return data;
        }
        this.context.bind("/current_user/details", data);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            if (!agentInfo.isActive()) continue;
            agentInfo.getRegistry().bind("/current_user/details", data);
        }
        return data;
    }

    AdminServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public String getServerName() {
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        if (uc == null) {
            return "";
        }
        return uc.getServer().getHostname();
    }

    @Override
    public int getPort() {
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        if (uc == null) {
            return -1;
        }
        return uc.getServer().getPort();
    }

    @Override
    public String getServerVersion() {
        try {
            return this.gateway.getServerVersion();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String getLoggingName() {
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        return uc.getUser().getUsername();
    }

    @Override
    public DiskQuota getQuota(SecurityContext ctx, Class type, long id) throws DSOutOfServiceException, DSAccessException {
        long v = 1000L;
        long used = 0L;
        long available = this.gateway.getFreeSpace(ctx, type, id);
        int t = 1;
        if (GroupData.class.equals((Object)type)) {
            t = 0;
        }
        return new DiskQuota(t, id, used * v, available * v);
    }

    @Override
    public Boolean changePassword(SecurityContext ctx, String oldPassword, String newPassword) throws DSOutOfServiceException, DSAccessException {
        if (CommonsLangUtils.isBlank(newPassword)) {
            throw new IllegalArgumentException("Password not valid.");
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        if (!uc.getUser().getPassword().equals(oldPassword)) {
            return false;
        }
        this.gateway.changePassword(ctx, newPassword, oldPassword);
        uc.resetPassword(newPassword);
        return true;
    }

    @Override
    public ExperimenterData changeExperimenterGroup(SecurityContext ctx, ExperimenterData exp, long groupID) throws DSOutOfServiceException, DSAccessException {
        if (!this.gateway.isServerRunning(ctx)) {
            return null;
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        if (exp == null) {
            exp = this.gateway.getUserDetails(ctx, uc.getUser().getUsername(), false);
        }
        if (groupID < 0L) {
            throw new DSAccessException("No group specified.");
        }
        if (exp.getDefaultGroup().getId() != groupID) {
            this.gateway.changeCurrentGroup(ctx, exp, groupID);
        }
        ExperimenterData data = this.gateway.getUserDetails(ctx, uc.getUser().getUsername(), true);
        this.context.bind("/current_user/details", data);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            if (!agentInfo.isActive()) continue;
            agentInfo.getRegistry().bind("/current_user/details", data);
        }
        return data;
    }

    @Override
    public ExperimenterData updateExperimenter(SecurityContext ctx, ExperimenterData exp, GroupData group) throws DSOutOfServiceException, DSAccessException {
        return this.updateExperimenter(ctx, exp, group, false);
    }

    @Override
    public List<ExperimenterData> createExperimenters(SecurityContext ctx, AdminObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object.");
        }
        Map<ExperimenterData, UserCredentials> m = object.getExperimenters();
        if (m == null || m.size() == 0) {
            throw new IllegalArgumentException("No experimenters to create.");
        }
        Roles roles = (Roles)this.context.lookup("/system/roles");
        return this.gateway.createExperimenters(ctx, object, roles);
    }

    @Override
    public void addExperimenters(SecurityContext ctx, GroupData group, List<ExperimenterData> experimenters) throws DSOutOfServiceException, DSAccessException {
        if (group == null) {
            throw new IllegalArgumentException("No group to add the experimenters to.");
        }
        if (experimenters == null || experimenters.size() == 0) {
            throw new IllegalArgumentException("No experimenters to add.");
        }
        this.gateway.addExperimenters(ctx, group, experimenters);
    }

    @Override
    public GroupData createGroup(SecurityContext ctx, AdminObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No object.");
        }
        if (object.getGroup() == null) {
            throw new IllegalArgumentException("No group.");
        }
        Roles roles = (Roles)this.context.lookup("/system/roles");
        return this.gateway.createGroup(ctx, object, roles);
    }

    @Override
    public List<ExperimenterData> loadExperimenters(SecurityContext ctx, long groupID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadExperimenters(ctx, groupID);
    }

    @Override
    public List<GroupData> loadGroups(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadGroups(ctx, id);
    }

    @Override
    public List<GroupData> loadGroupsForExperimenter(SecurityContext ctx, long id) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.loadGroupsForExperimenter(ctx, id);
    }

    @Override
    public List<ExperimenterData> deleteExperimenters(SecurityContext ctx, List<ExperimenterData> experimenters) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(experimenters)) {
            throw new IllegalArgumentException("No experimenters to delete.");
        }
        return this.gateway.deleteExperimenters(ctx, experimenters);
    }

    @Override
    public List<GroupData> deleteGroups(SecurityContext ctx, List<GroupData> groups) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(groups)) {
            throw new IllegalArgumentException("No groups to delete.");
        }
        return this.gateway.deleteGroups(ctx, groups);
    }

    @Override
    public GroupData updateGroup(SecurityContext ctx, GroupData group) throws DSOutOfServiceException, DSAccessException {
        if (group == null) {
            throw new IllegalArgumentException("No group to update.");
        }
        this.gateway.updateGroup(ctx, group);
        return this.reloadGroup(ctx, group);
    }

    @Override
    public void updateGroupPermissions(SecurityContext ctx, GroupData group, int permissions, DSCallAdapter adapter) throws DSOutOfServiceException, DSAccessException {
        if (group == null) {
            throw new IllegalArgumentException("No group to update.");
        }
        RequestCallback cb = this.gateway.updateGroupPermissions(ctx, group, permissions);
        if (cb != null) {
            cb.setAdapter(adapter);
        }
    }

    @Override
    public GroupData reloadGroup(SecurityContext ctx, GroupData group) throws DSOutOfServiceException, DSAccessException {
        group = this.gateway.loadGroups(ctx, group.getGroupId()).get(0);
        Collection groups = (Collection)this.context.lookup("/userGroup/details");
        Iterator j = groups.iterator();
        HashSet<GroupData> available = new HashSet<GroupData>();
        while (j.hasNext()) {
            GroupData g = (GroupData)j.next();
            if (g.getId() == group.getId()) {
                available.add(group);
                continue;
            }
            available.add(g);
        }
        this.context.bind("/userGroup/details", available);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            if (!agentInfo.isActive()) continue;
            agentInfo.getRegistry().bind("/userGroup/details", available);
        }
        return group;
    }

    @Override
    public List<ExperimenterData> copyExperimenters(SecurityContext ctx, GroupData group, Collection experimenters) throws DSOutOfServiceException, DSAccessException {
        if (group == null) {
            throw new IllegalArgumentException("No group specified.");
        }
        if (CollectionUtils.isEmpty((Collection)experimenters)) {
            return new ArrayList<ExperimenterData>();
        }
        return this.gateway.copyExperimenters(ctx, group, experimenters);
    }

    @Override
    public List<ExperimenterData> cutAndPasteExperimenters(SecurityContext ctx, Map toPaste, Map toCut) throws DSOutOfServiceException, DSAccessException {
        Object parent;
        if (toPaste == null) {
            toPaste = new HashMap();
        }
        if (toCut == null) {
            toCut = new HashMap();
        }
        ArrayList<ExperimenterData> r = new ArrayList<ExperimenterData>();
        for (Map.Entry entry : toCut.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof GroupData)) continue;
            r.addAll(this.gateway.removeExperimenters(ctx, (GroupData)parent, (Set)entry.getValue()));
        }
        for (Map.Entry entry : toPaste.entrySet()) {
            parent = entry.getKey();
            if (!(parent instanceof GroupData)) continue;
            r.addAll(this.copyExperimenters(ctx, (GroupData)parent, (Set)entry.getValue()));
        }
        return r;
    }

    @Override
    public Map<Long, Long> countExperimenters(SecurityContext ctx, List<Long> ids) throws DSOutOfServiceException, DSAccessException {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap<Long, Long>();
        }
        return this.gateway.countExperimenters(ctx, ids);
    }

    @Override
    public Map<ExperimenterData, Exception> updateExperimenters(SecurityContext ctx, GroupData group, Map<ExperimenterData, UserCredentials> experimenters) throws DSOutOfServiceException, DSAccessException {
        if (experimenters == null) {
            throw new IllegalArgumentException("No experimenters to update");
        }
        Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = experimenters.entrySet().iterator();
        HashMap<ExperimenterData, Exception> l = new HashMap<ExperimenterData, Exception>();
        ArrayList<Experimenter> ownersToAdd = new ArrayList<Experimenter>();
        ArrayList<Experimenter> ownersToRemove = new ArrayList<Experimenter>();
        ArrayList<ExperimenterData> administratorsToAdd = new ArrayList<ExperimenterData>();
        ArrayList<ExperimenterData> administratorsToRemove = new ArrayList<ExperimenterData>();
        ArrayList<ExperimenterData> toActivate = new ArrayList<ExperimenterData>();
        ArrayList<ExperimenterData> toDeactivate = new ArrayList<ExperimenterData>();
        boolean reset = false;
        while (i.hasNext()) {
            Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
            ExperimenterData exp = entry.getKey();
            UserCredentials uc = entry.getValue();
            try {
                this.updateExperimenter(ctx, exp, group, true);
                group = uc.getGroupToHandle();
                Boolean b = uc.isGroupOwner(group);
                if (b != null) {
                    if (b.booleanValue()) {
                        ownersToAdd.add(exp.asExperimenter());
                    } else {
                        ownersToRemove.add(exp.asExperimenter());
                    }
                }
                if ((b = uc.isAdministrator()) != null) {
                    if (b.booleanValue()) {
                        administratorsToAdd.add(exp);
                    } else {
                        administratorsToRemove.add(exp);
                    }
                }
                if ((b = uc.isActive()) != null) {
                    if (b.booleanValue()) {
                        toActivate.add(exp);
                    } else {
                        toDeactivate.add(exp);
                    }
                }
                if (exp.getUserName().equals(uc.getUser().getUsername()) || (reset = this.gateway.resetUserName(ctx, uc.getUser().getUsername(), exp))) continue;
                l.put(exp, new Exception("The selected User Name is already taken."));
            }
            catch (Exception e) {
                l.put(exp, e);
            }
        }
        if (group != null) {
            if (ownersToAdd.size() > 0) {
                this.gateway.handleGroupOwners(ctx, true, group.asGroup(), ownersToAdd);
            }
            if (ownersToRemove.size() > 0) {
                this.gateway.handleGroupOwners(ctx, false, group.asGroup(), ownersToRemove);
            }
        }
        if (toActivate.size() > 0) {
            this.gateway.modifyExperimentersRoles(ctx, true, toActivate, "user");
        }
        if (toDeactivate.size() > 0) {
            this.gateway.modifyExperimentersRoles(ctx, false, toDeactivate, "user");
        }
        if (administratorsToAdd.size() > 0) {
            this.gateway.modifyExperimentersRoles(ctx, true, administratorsToAdd, "system");
        }
        if (administratorsToRemove.size() > 0) {
            this.gateway.modifyExperimentersRoles(ctx, false, administratorsToRemove, "system");
        }
        return l;
    }

    @Override
    public List<ExperimenterData> resetExperimentersPassword(SecurityContext ctx, AdminObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No experimenters specified");
        }
        if (4 != object.getIndex()) {
            throw new IllegalArgumentException("Index not valid");
        }
        Map<ExperimenterData, UserCredentials> map = object.getExperimenters();
        if (map == null) {
            throw new IllegalArgumentException("No experimenters specified");
        }
        ArrayList<ExperimenterData> l = new ArrayList<ExperimenterData>();
        for (Map.Entry<ExperimenterData, UserCredentials> entry : map.entrySet()) {
            ExperimenterData exp = entry.getKey();
            UserCredentials uc = entry.getValue();
            try {
                String ldap = this.gateway.lookupLdapAuthExperimenter(ctx, exp.getId());
                if (CommonsLangUtils.isNotBlank(ldap)) {
                    l.add(exp);
                    continue;
                }
                this.gateway.resetPassword(ctx, exp.getUserName(), exp.getId(), uc.getUser().getPassword());
            }
            catch (Exception e) {
                l.add(exp);
            }
        }
        return l;
    }

    @Override
    public List<ExperimenterData> activateExperimenters(SecurityContext ctx, AdminObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new IllegalArgumentException("No experimenters specified");
        }
        if (6 != object.getIndex()) {
            throw new IllegalArgumentException("Index not valid.");
        }
        Map<ExperimenterData, UserCredentials> map = object.getExperimenters();
        if (map == null) {
            throw new IllegalArgumentException("No experimenters specified");
        }
        ArrayList<ExperimenterData> l = new ArrayList<ExperimenterData>();
        Iterator<Map.Entry<ExperimenterData, UserCredentials>> i = map.entrySet().iterator();
        ArrayList<ExperimenterData> toActivate = new ArrayList<ExperimenterData>();
        ArrayList<ExperimenterData> toDeactivate = new ArrayList<ExperimenterData>();
        while (i.hasNext()) {
            Map.Entry<ExperimenterData, UserCredentials> entry = i.next();
            ExperimenterData exp = entry.getKey();
            UserCredentials uc = entry.getValue();
            if (uc.isActive().booleanValue()) {
                toActivate.add(exp);
                continue;
            }
            toDeactivate.add(exp);
        }
        if (toActivate.size() > 0) {
            this.gateway.modifyExperimentersRoles(ctx, true, toActivate, "user");
        }
        if (toDeactivate.size() > 0) {
            this.gateway.modifyExperimentersRoles(ctx, false, toDeactivate, "user");
        }
        return l;
    }

    @Override
    public List<GroupData> reloadPIGroups(SecurityContext ctx, ExperimenterData exp) throws DSOutOfServiceException, DSAccessException {
        GroupData g;
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        ArrayList<ExperimenterData> exps = new ArrayList<ExperimenterData>();
        Set<GroupData> groups = this.gateway.getAvailableGroups(ctx, exp);
        Iterator<GroupData> i = groups.iterator();
        HashSet<GroupData> available = new HashSet<GroupData>();
        Roles roles = (Roles)this.context.lookup("/system/roles");
        while (i.hasNext()) {
            g = i.next();
            if (!this.isSecuritySystemGroup(g.getId())) {
                available.add(g);
                continue;
            }
            if (g.getId() != roles.systemGroupId) continue;
            uc.setAdministrator(true);
        }
        this.context.bind("/userGroup/details", available);
        ArrayList<Long> ids = new ArrayList<Long>();
        i = available.iterator();
        while (i.hasNext()) {
            g = i.next();
            Set<ExperimenterData> set = g.getExperimenters();
            for (ExperimenterData e : set) {
                if (ids.contains(e.getId())) continue;
                ids.add(e.getId());
                exps.add(e);
            }
        }
        this.context.bind("/users/details", exps);
        ArrayList<GroupData> result = new ArrayList<GroupData>();
        Iterator k = available.iterator();
        while (k.hasNext()) {
            result.add((GroupData)k.next());
        }
        List agents = (List)this.context.lookup("/agents");
        Iterator<ExperimenterData> j = agents.iterator();
        while (i.hasNext()) {
            AgentInfo agentInfo = (AgentInfo)((Object)j.next());
            if (!agentInfo.isActive()) continue;
            Registry reg = agentInfo.getRegistry();
            reg.bind("/userGroup/details", available);
            reg.bind("/users/details", exps);
        }
        return result;
    }

    @Override
    public ExperimenterData lookupExperimenter(SecurityContext ctx, String name) throws DSOutOfServiceException, DSAccessException {
        Experimenter value = this.gateway.lookupExperimenter(ctx, name);
        if (value != null) {
            return (ExperimenterData)PojoMapper.asDataObject((IObject)value);
        }
        return null;
    }

    @Override
    public GroupData lookupGroup(SecurityContext ctx, String name) throws DSOutOfServiceException, DSAccessException {
        ExperimenterGroup value = this.gateway.lookupGroup(ctx, name);
        if (value != null) {
            return (GroupData)PojoMapper.asDataObject((IObject)value);
        }
        return null;
    }

    @Override
    public BufferedImage uploadUserPhoto(SecurityContext ctx, File f, String format, ExperimenterData experimenter) throws DSOutOfServiceException, DSAccessException {
        if (experimenter == null) {
            throw new IllegalArgumentException("No experimenter specified.");
        }
        if (f == null) {
            throw new IllegalArgumentException("No photo specified.");
        }
        long id = this.gateway.uploadExperimenterPhoto(ctx, f, format, experimenter.getId());
        if (id < 0L) {
            return null;
        }
        ArrayList<DataObject> exp = new ArrayList<DataObject>();
        exp.add(experimenter);
        Map<DataObject, BufferedImage> map = this.context.getImageService().getExperimenterThumbnailSet(ctx, exp, 0);
        return map.get(experimenter);
    }

    @Override
    public boolean isConnected() {
        return this.gateway.isConnected();
    }

    @Override
    public ExperimenterData getUserDetails() {
        return (ExperimenterData)this.context.lookup("/current_user/details");
    }

    @Override
    public Collection<GroupData> getAvailableUserGroups() {
        return (Collection)this.context.lookup("/userGroup/details");
    }

    @Override
    public boolean isSecuritySystemGroup(long groupID) {
        Roles roles = (Roles)this.context.lookup("/system/roles");
        if (roles == null) {
            return false;
        }
        return roles.guestGroupId == groupID || roles.systemGroupId == groupID || roles.userGroupId == groupID;
    }

    @Override
    public boolean isSecuritySystemGroup(long groupID, String key) {
        Roles roles = (Roles)this.context.lookup("/system/roles");
        if (roles == null) {
            return false;
        }
        if ("user".equals(key)) {
            return roles.userGroupId == groupID;
        }
        if ("system".equals(key)) {
            return roles.systemGroupId == groupID;
        }
        if ("guest".equals(key)) {
            return roles.guestGroupId == groupID;
        }
        throw new IllegalArgumentException("Key not valid.");
    }

    @Override
    public boolean isSystemUser(long userID) {
        Roles roles = (Roles)this.context.lookup("/system/roles");
        if (roles == null) {
            return false;
        }
        return roles.rootId == userID || roles.guestId == userID;
    }

    @Override
    public boolean isSystemUser(long userID, String key) {
        Roles roles = (Roles)this.context.lookup("/system/roles");
        if (roles == null) {
            return false;
        }
        if ("system".equals(key)) {
            return roles.rootId == userID;
        }
        if ("guest".equals(key)) {
            return roles.guestId == userID;
        }
        throw new IllegalArgumentException("Key not valid.");
    }

    @Override
    public String lookupLdapAuthExperimenter(SecurityContext ctx, long userID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.lookupLdapAuthExperimenter(ctx, userID);
    }
}

