/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ROIData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import omero.gateway.model.TermAnnotationData;

public class DeletableObject {
    private DataObject objectToDelete;
    private boolean content;
    private List<Class> annotations;
    private List<String> report;
    private int numberOfErrors;
    private SecurityContext ctx;

    public DeletableObject(DataObject objectToDelete, boolean content) {
        if (objectToDelete == null) {
            throw new IllegalArgumentException("No object to delete.");
        }
        this.objectToDelete = objectToDelete;
        this.content = content;
    }

    public DeletableObject(DataObject objectToDelete) {
        this(objectToDelete, false);
    }

    public boolean deleteContent() {
        return this.content;
    }

    public List<Class> getAnnotations() {
        return this.annotations;
    }

    public void setAttachmentTypes(List<Class> annotations) {
        this.annotations = annotations;
    }

    public DataObject getObjectToDelete() {
        return this.objectToDelete;
    }

    public long getGroupId() {
        if (this.ctx != null) {
            return this.ctx.getGroupID();
        }
        return this.objectToDelete.getGroupId();
    }

    public void setReport(List<String> report) {
        this.report = report;
    }

    public List<String> getReport() {
        return this.report;
    }

    public int getNumberOfErrors() {
        return this.numberOfErrors;
    }

    public String getType() {
        if (this.objectToDelete instanceof ProjectData) {
            return "Project";
        }
        if (this.objectToDelete instanceof DatasetData) {
            return "Dataset";
        }
        if (this.objectToDelete instanceof ImageData) {
            return "Image";
        }
        if (this.objectToDelete instanceof ScreenData) {
            return "Screen";
        }
        if (this.objectToDelete instanceof ROIData) {
            return "Roi";
        }
        if (this.objectToDelete instanceof TagAnnotationData) {
            return "Tag";
        }
        if (this.objectToDelete instanceof TermAnnotationData) {
            return "Ontology Term";
        }
        if (this.objectToDelete instanceof PlateData) {
            return "Plate";
        }
        if (this.objectToDelete instanceof PlateAcquisitionData) {
            return "PlateAcquisition";
        }
        if (this.objectToDelete instanceof FileAnnotationData) {
            return "File";
        }
        if (this.objectToDelete instanceof MapAnnotationData) {
            return "Map Annotation";
        }
        return "";
    }

    public String getMessage() {
        if (this.objectToDelete instanceof ProjectData) {
            return ((ProjectData)this.objectToDelete).getName();
        }
        if (this.objectToDelete instanceof DatasetData) {
            return ((DatasetData)this.objectToDelete).getName();
        }
        if (this.objectToDelete instanceof ImageData) {
            return ((ImageData)this.objectToDelete).getName();
        }
        if (this.objectToDelete instanceof ScreenData) {
            return ((ScreenData)this.objectToDelete).getName();
        }
        if (this.objectToDelete instanceof ROIData) {
            return "ROI for:" + ((ROIData)this.objectToDelete).getImage().getName();
        }
        if (this.objectToDelete instanceof TagAnnotationData) {
            return ((TagAnnotationData)this.objectToDelete).getTagValue();
        }
        if (this.objectToDelete instanceof TermAnnotationData) {
            return ((TermAnnotationData)this.objectToDelete).getTerm();
        }
        if (this.objectToDelete instanceof PlateData) {
            return ((PlateData)this.objectToDelete).getName();
        }
        if (this.objectToDelete instanceof PlateAcquisitionData) {
            return ((PlateAcquisitionData)this.objectToDelete).getLabel();
        }
        if (this.objectToDelete instanceof FileAnnotationData) {
            return ((FileAnnotationData)this.objectToDelete).getFileName();
        }
        if (this.objectToDelete instanceof MapAnnotationData) {
            return "Map Annotation";
        }
        return "";
    }

    public SecurityContext getSecurityContext() {
        return this.ctx;
    }

    public void setSecurityContext(SecurityContext ctx) {
        this.ctx = ctx;
    }
}

