/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import omero.gateway.model.DatasetData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.model.OriginalFile;
import org.openmicroscopy.shoola.env.data.ProcessReport;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.ActivityResultMenu;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ActivityResultRow
extends JButton
implements ActionListener {
    static final String ACTION_PROPERTY = "action";
    private static final String VIEW_TEXT = "View ";
    private static final String BROWSE_TEXT = "Go to ";
    private static final String DOWNLOAD_TEXT = "Download";
    static final String INFO_TEXT = "Info";
    static final String ERROR_TEXT = "Error";
    private static final int DOWNLOAD = 0;
    private static final int VIEW = 1;
    private static final int BROWSE = 2;
    private static final int MAX_LENGTH = 27;
    private ActivityComponent activity;
    private Object row;
    private String name;
    private JPopupMenu menu;
    private JMenuItem viewItem;

    private boolean isDownloadable(Object object) {
        return object instanceof FileAnnotationData || object instanceof OriginalFile;
    }

    private boolean isViewable(Object object) {
        return object instanceof ImageData || object instanceof FileAnnotationData || object instanceof OriginalFile;
    }

    private void createMenu(int x, int y) {
        JMenuItem item;
        if (this.menu != null) {
            this.menu.show(this, x, y);
            return;
        }
        this.menu = new JPopupMenu();
        String text = this.getType();
        if (text != null) {
            item = this.createMenuItem(BROWSE_TEXT + text, 2);
            this.menu.add(item);
        }
        if (this.isViewable(this.row)) {
            String mt = this.getMimetype();
            if (mt != null) {
                this.viewItem = this.createMenuItem(VIEW_TEXT + mt, 1);
                this.menu.add(this.viewItem);
            } else if (!this.isDownloadable(this.row)) {
                this.viewItem = this.createMenuItem(VIEW_TEXT + text, 1);
                this.menu.add(this.viewItem);
            }
        }
        if (this.isDownloadable(this.row)) {
            item = this.createMenuItem(DOWNLOAD_TEXT, 0);
            this.menu.add(item);
        }
        if (this.activity.hasError()) {
            this.menu.add(new ActivityResultMenu(ERROR_TEXT, this.activity.errorObject, this.activity));
        }
        if (this.activity.hasInfo()) {
            this.menu.add(new ActivityResultMenu(INFO_TEXT, this.activity.infoObject, this.activity));
        }
        this.menu.show(this, x, y);
    }

    private JMenuItem createMenuItem(String text, int actionID) {
        JMenuItem b = new JMenuItem(text);
        b.setActionCommand("" + actionID);
        b.addActionListener(this);
        return b;
    }

    private void attachListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ActivityResultRow.this.createMenu(e.getX(), e.getY());
            }
        });
    }

    private String getType() {
        if (this.row instanceof ImageData) {
            return "Image";
        }
        if (this.row instanceof DatasetData) {
            return "Dataset";
        }
        if (this.row instanceof ProjectData) {
            return "Project";
        }
        if (this.row instanceof ScreenData) {
            return "Screen";
        }
        if (this.row instanceof PlateData) {
            return "Plate";
        }
        if (this.row instanceof FileAnnotationData) {
            return "Attachment";
        }
        return null;
    }

    private String getMimetype() {
        OriginalFile of;
        OriginalFile of2;
        FileAnnotationData fa;
        String mimetype = null;
        if (this.row instanceof FileAnnotationData && (fa = (FileAnnotationData)this.row).isLoaded() && (of2 = (OriginalFile)fa.getContent()).isLoaded() && of2.getMimetype() != null) {
            mimetype = of2.getMimetype().getValue();
        }
        if (this.row instanceof OriginalFile && (of = (OriginalFile)this.row).isLoaded() && of.getMimetype() != null) {
            mimetype = of.getMimetype().getValue();
        }
        if (mimetype == null) {
            return null;
        }
        if ("image/jpeg".equals(mimetype)) {
            return "jpeg";
        }
        if ("image/png".equals(mimetype)) {
            return "png";
        }
        if ("image/tiff".equals(mimetype)) {
            return "tiff";
        }
        if ("image/gif".equals(mimetype)) {
            return "gif";
        }
        return null;
    }

    private String getObjectText() {
        Object text = "";
        if (this.row instanceof ImageData) {
            ImageData data = (ImageData)this.row;
            if (data.isLoaded()) {
                text = (String)text + data.getName();
            } else {
                text = (String)text + "Image ID:";
                text = (String)text + data.getId();
            }
        } else if (this.row instanceof DatasetData) {
            DatasetData data = (DatasetData)this.row;
            if (data.isLoaded()) {
                text = (String)text + data.getName();
            } else {
                text = (String)text + "Dataset ID:";
                text = (String)text + data.getId();
            }
        } else if (this.row instanceof PlateData) {
            PlateData data = (PlateData)this.row;
            if (data.isLoaded()) {
                text = (String)text + data.getName();
            } else {
                text = (String)text + "Plate ID:";
                text = (String)text + data.getId();
            }
        } else if (this.row instanceof ScreenData) {
            ScreenData data = (ScreenData)this.row;
            if (data.isLoaded()) {
                text = (String)text + data.getName();
            } else {
                text = (String)text + "Screen ID:";
                text = (String)text + data.getId();
            }
        } else if (this.row instanceof ProjectData) {
            ProjectData data = (ProjectData)this.row;
            if (data.isLoaded()) {
                text = (String)text + data.getName();
            } else {
                text = (String)text + "Project ID:";
                text = (String)text + data.getId();
            }
        } else if (this.row instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)this.row;
            if (data.isLoaded()) {
                text = (String)text + data.getFileName();
            } else {
                text = (String)text + "Annotation ID:";
                text = (String)text + data.getId();
            }
        } else if (this.row instanceof OriginalFile) {
            OriginalFile data = (OriginalFile)this.row;
            if (data.isLoaded()) {
                if (data.getName() != null) {
                    text = (String)text + data.getName().getValue();
                }
            } else {
                text = (String)text + "File ID:";
                text = (String)text + data.getId().getValue();
            }
        } else if (this.row instanceof ProcessReport) {
            ProcessReport report = (ProcessReport)this.row;
            StringBuffer buffer = new StringBuffer();
            buffer.append("Category:" + report.getCategory());
            buffer.append("Name:" + report.getName());
            text = buffer.toString();
        } else {
            text = this.row.toString();
        }
        return text;
    }

    private void buildGUI() {
        this.setOpaque(false);
        this.setForeground(UIUtilities.HYPERLINK_COLOR);
        UIUtilities.unifiedButtonLookAndFeel(this);
        String text = this.getObjectText();
        int l = text.length();
        if (l <= 27) {
            this.setText(text);
        } else {
            this.setText("..." + text.substring(l - 27 - 1, l - 1));
        }
        this.setToolTipText(text);
        Font f = this.getFont();
        this.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
    }

    ActivityResultRow(Object row, ActivityComponent activity) {
        this("", row, activity);
    }

    ActivityResultRow(String name, Object row, ActivityComponent activity) {
        this.activity = activity;
        this.row = row;
        this.name = name;
        this.buildGUI();
        this.attachListeners();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.activity.download("", this.row);
                break;
            }
            case 1: {
                this.activity.view(this.row, this.viewItem);
                break;
            }
            case 2: {
                this.activity.browse(this.row, this.viewItem);
            }
        }
    }
}

