/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util;

import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.WellData;
import omero.gateway.model.WellSampleData;
import omero.model.PlateAcquisition;

public class PojosUtil {
    public static boolean isContainerClass(Class<?> type) {
        return DatasetData.class.equals(type) || ProjectData.class.equals(type) || ScreenData.class.equals(type) || PlateData.class.equals(type) || PlateAcquisitionData.class.equals(type);
    }

    public static boolean isDownloadable(DataObject obj) {
        if (obj instanceof ImageData) {
            ImageData img = (ImageData)obj;
            return img.isArchived() && !img.asIObject().getDetails().getPermissions().isRestricted("RESTRICT-BINARY-ACCESS");
        }
        if (obj instanceof PlateData) {
            PlateData p = (PlateData)obj;
            return !p.asIObject().getDetails().getPermissions().isRestricted("RESTRICT-BINARY-ACCESS");
        }
        if (obj instanceof PlateAcquisitionData) {
            PlateAcquisitionData p = (PlateAcquisitionData)obj;
            PlateAcquisition pa = (PlateAcquisition)p.asIObject();
            return !pa.getPlate().getDetails().getPermissions().isRestricted("RESTRICT-BINARY-ACCESS");
        }
        if (obj instanceof WellSampleData) {
            WellSampleData w = (WellSampleData)obj;
            return w.getImage().isArchived() && !w.asWellSample().getWell().getPlate().getDetails().getPermissions().isRestricted("RESTRICT-BINARY-ACCESS");
        }
        if (obj instanceof WellData) {
            WellData w = (WellData)obj;
            return w.getWellSamples().iterator().next().getImage().isArchived() && !w.getPlate().asIObject().getDetails().getPermissions().isRestricted("RESTRICT-BINARY-ACCESS");
        }
        return false;
    }
}

