/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.math.geom2D;

import org.openmicroscopy.shoola.util.math.geom2D.Line;
import org.openmicroscopy.shoola.util.math.geom2D.PlanePoint;

public class Segment {
    public final PlanePoint origin;
    public final PlanePoint direction;

    public Segment(PlanePoint o, PlanePoint e) {
        if (o == null) {
            throw new NullPointerException("No origin.");
        }
        if (e == null) {
            throw new NullPointerException("No end p.");
        }
        if (o.equals(e)) {
            throw new IllegalArgumentException("Need two different points.");
        }
        this.origin = o;
        this.direction = this.origin.vec(e);
    }

    public PlanePoint getPoint(double k) {
        if (k < 0.0 || k > 1.0) {
            throw new IllegalArgumentException("Coefficient must be in the range [0, 1].");
        }
        return new PlanePoint(this.origin.x1 + k * this.direction.x1, this.origin.x2 + k * this.direction.x2);
    }

    public boolean lies(PlanePoint p) {
        double k2;
        double k1;
        if (p == null) {
            throw new NullPointerException("No point.");
        }
        boolean result = false;
        if (this.direction.x1 == 0.0 && this.direction.x2 != 0.0) {
            double k22 = (p.x2 - this.origin.x2) / this.direction.x2;
            result = k22 < 0.0 || k22 > 1.0 ? false : p.x1 == this.origin.x1;
        } else if (this.direction.x1 != 0.0 && this.direction.x2 == 0.0) {
            double k12 = (p.x1 - this.origin.x1) / this.direction.x1;
            result = k12 < 0.0 || k12 > 1.0 ? false : p.x2 == this.origin.x2;
        } else if (this.direction.x1 != 0.0 && this.direction.x2 != 0.0 && Math.abs((k1 = (p.x1 - this.origin.x1) / this.direction.x1) - (k2 = (p.x2 - this.origin.x2) / this.direction.x2)) < 1.0E-5) {
            return !(k1 < 0.0) && !(k1 > 1.0);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Line)) {
            return false;
        }
        Line other = (Line)o;
        return this.origin == other.origin && this.direction == other.direction;
    }

    public int hashCode() {
        return this.origin.hashCode();
    }
}

