/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class OptionsDialog
extends JDialog {
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private JXHeader contentPanel;
    private JButton noButton;
    private JButton yesButton;
    private JButton cancelButton;
    private JPanel mainPanel;
    private JPanel controlPanel;
    protected JPanel body;

    private void yesSelection() {
        this.onYesSelection();
        this.close();
    }

    private void noSelection() {
        this.onNoSelection();
        this.close();
    }

    private void cancel() {
        this.onCancel();
        this.close();
    }

    private void createComponents() {
        this.body = new JPanel();
        this.mainPanel = new JPanel();
        this.controlPanel = new JPanel();
        this.contentPanel = new JXHeader();
        this.noButton = new JButton("No");
        this.noButton.setName("no button");
        this.yesButton = new JButton("Yes");
        this.yesButton.setName("yes button");
        this.getRootPane().setDefaultButton(this.yesButton);
    }

    private void attachListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                OptionsDialog.this.close();
            }
        });
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.noSelection();
            }
        });
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDialog.this.yesSelection();
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel buildCommentPanel(String instructions, Icon icon) {
        this.contentPanel.setBackgroundPainter((Painter)new RectanglePainter(this.getBackground(), null));
        this.contentPanel.setDescription(instructions);
        this.contentPanel.setIcon(icon);
        this.contentPanel.setIconPosition(JXHeader.IconPosition.LEFT);
        return this.contentPanel;
    }

    private JPanel buildControlPanel() {
        this.controlPanel.setBorder(null);
        this.controlPanel.add(this.yesButton);
        this.controlPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        this.controlPanel.add(this.noButton);
        this.controlPanel.add(Box.createRigidArea(H_SPACER_SIZE));
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 1));
        bar.add(this.controlPanel);
        bar.add(Box.createVerticalStrut(10));
        JPanel p = UIUtilities.buildComponentPanelRight(bar);
        return p;
    }

    private void buildGUI(String message, Icon icon) {
        JXHeader header = new JXHeader();
        header.setBackgroundPainter((Painter)new RectanglePainter(this.getBackground(), null));
        header.setDescription(message);
        this.mainPanel.setOpaque(false);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        double[][] size = new double[][]{{-2.0, 5.0, -1.0}, {-2.0, -1.0, -2.0}};
        this.mainPanel.setLayout((LayoutManager)new TableLayout((double[][])size));
        this.mainPanel.add((Component)new JLabel(icon), "0, 0");
        this.mainPanel.add((Component)header, "2, 0");
        this.mainPanel.add((Component)this.body, "0, 1, 2, 1");
        this.mainPanel.add((Component)this.buildControlPanel(), "0, 2, 2, 2");
        this.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private void initialize(String message, Icon messageIcon) {
        this.createComponents();
        this.attachListeners();
        this.buildGUI(message, messageIcon);
        this.pack();
        this.setName("options dialog");
    }

    public OptionsDialog(JFrame owner, String title, String message, Icon messageIcon) {
        super(owner, title, true);
        this.initialize(message, messageIcon);
    }

    public OptionsDialog(JDialog owner, String title, String message, Icon messageIcon) {
        super(owner, title, true);
        this.initialize(message, messageIcon);
    }

    public void addBodyComponent(JComponent c) {
        this.body.add(c);
        this.body.validate();
        this.body.repaint();
        this.mainPanel.validate();
        this.mainPanel.repaint();
        this.pack();
    }

    public void setYesText(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        this.yesButton.setText(txt);
    }

    public void setNoText(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        this.noButton.setText(txt);
    }

    public void setCancelText(String txt) {
        if (txt == null || txt.trim().length() == 0) {
            return;
        }
        if (this.cancelButton == null) {
            return;
        }
        this.cancelButton.setText(txt);
    }

    public void hideNoButton() {
        this.controlPanel.remove(this.noButton);
        this.controlPanel.revalidate();
        this.repaint();
    }

    public void setYesEnabled(boolean enabled) {
        this.yesButton.setEnabled(enabled);
    }

    public void addCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.setName("cancel button");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.cancel();
                }
            });
        }
        this.controlPanel.add(this.cancelButton);
        this.repaint();
    }

    protected void onYesSelection() {
    }

    protected void onNoSelection() {
    }

    protected void onCancel() {
    }
}

