/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.attributes;

import java.util.HashMap;
import java.util.Map;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.openmicroscopy.shoola.util.roi.io.IOConstants;
import org.openmicroscopy.shoola.util.ui.drawingtools.attributes.DrawingAttributes;

public class FigureProperties
extends AttributeKeys {
    private static Map<AttributeKey, Object> defaultProperties = new HashMap<AttributeKey, Object>();
    protected Map<AttributeKey, Object> propertyMap = new HashMap<AttributeKey, Object>();

    public FigureProperties(AttributeSet initialSet) {
        switch (initialSet) {
            case EMPTY: {
                break;
            }
            case DEFAULT: {
                this.propertyMap.putAll(defaultProperties);
            }
        }
    }

    public FigureProperties(Map<AttributeKey, Object> initialSet) {
        this.addAttribute(initialSet);
    }

    public void setAttributes(Figure fig) {
        for (AttributeKey key : this.propertyMap.keySet()) {
            key.set(fig, this.propertyMap.get(key));
        }
    }

    public void addAttribute(Map<AttributeKey, Object> attributeSet) {
        if (attributeSet == null) {
            return;
        }
        for (Map.Entry<AttributeKey, Object> entry : attributeSet.entrySet()) {
            this.addAttribute(entry.getKey(), entry.getValue());
        }
    }

    public void addAttribute(AttributeKey key, Object defaultValue) {
        if (key == null) {
            return;
        }
        this.propertyMap.put(key, defaultValue);
    }

    public void setPropertyValue(AttributeKey key, Object value) {
        this.propertyMap.put(key, value);
    }

    public Object getPropertyValue(AttributeKey key) {
        if (key == null) {
            return null;
        }
        return this.propertyMap.get(key);
    }

    public boolean hasProperty(AttributeKey key) {
        if (key == null) {
            return false;
        }
        return this.propertyMap.containsKey(key);
    }

    public void removeAttributes(AttributeKey key) {
        if (this.hasProperty(key)) {
            this.propertyMap.remove(key);
        }
    }

    public Map<AttributeKey, Object> getProperties() {
        return this.propertyMap;
    }

    static {
        defaultProperties.put(DrawingAttributes.FILL_COLOR, IOConstants.DEFAULT_FILL_COLOUR);
        defaultProperties.put(DrawingAttributes.STROKE_COLOR, IOConstants.DEFAULT_STROKE_COLOUR);
        defaultProperties.put(DrawingAttributes.STROKE_WIDTH, 1.0);
        defaultProperties.put(DrawingAttributes.TEXT, "Text");
        defaultProperties.put(DrawingAttributes.TEXT_COLOR, IOConstants.DEFAULT_TEXT_COLOUR);
        defaultProperties.put(DrawingAttributes.FONT_SIZE, 12.0);
        defaultProperties.put(DrawingAttributes.SHOWTEXT, true);
    }

    public static enum AttributeSet {
        EMPTY,
        DEFAULT;

    }
}

