/*
 * Decompiled with CFR 0.152.
 */
package ome.system;

import java.util.Properties;
import ome.conditions.ApiUsageException;

public class Server {
    public static final String OMERO_HOST = "server.host";
    public static final String OMERO_PORT = "server.port";
    public static final int DEFAULT_PORT = 1099;
    private String _server;
    private String _port;

    private Server() {
    }

    public Server(String serverHost) {
        if (serverHost == null) {
            throw new ApiUsageException("serverHost argument to Server constructor cannot be null");
        }
        this._server = serverHost;
        this._port = Integer.toString(1099);
    }

    public Server(String serverHost, int port) {
        this(serverHost);
        if (port < 0) {
            throw new ApiUsageException("serverPort may not be null.");
        }
        this._port = Integer.toString(port);
    }

    public Properties asProperties() {
        Properties p = new Properties();
        p.setProperty(OMERO_HOST, this._server);
        p.setProperty(OMERO_PORT, this._port);
        return p;
    }

    public String getHost() {
        return this._server;
    }

    public int getPort() {
        return Integer.valueOf(this._port);
    }
}

