/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.application.DocumentOrientedApplication;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractApplicationAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;

public class OpenAction
extends AbstractApplicationAction {
    public static final String ID = "File.open";

    public OpenAction() {
        this.initActionProperties(ID);
    }

    public void actionPerformed(ActionEvent evt) {
        DocumentOrientedApplication application = this.getApplication();
        if (application.isEnabled()) {
            boolean removeMe;
            DocumentView p;
            application.setEnabled(false);
            DocumentView emptyProject = application.getCurrentView();
            if (emptyProject == null || emptyProject.getFile() != null || emptyProject.isModified()) {
                emptyProject = null;
            }
            if (emptyProject == null) {
                p = application.createView();
                application.add(p);
                removeMe = true;
                removeMe = true;
            } else {
                p = emptyProject;
                removeMe = false;
            }
            JFileChooser fileChooser = p.getOpenChooser();
            if (fileChooser.showOpenDialog(application.getComponent()) == 0) {
                application.show(p);
                this.openFile(fileChooser, p);
            } else {
                if (removeMe) {
                    application.remove(p);
                }
                application.setEnabled(true);
            }
        }
    }

    protected void openFile(JFileChooser fileChooser, final DocumentView documentView) {
        DocumentOrientedApplication application = this.getApplication();
        final File file = fileChooser.getSelectedFile();
        application.setEnabled(true);
        documentView.setEnabled(false);
        documentView.execute(new Worker(){

            public Object construct() {
                try {
                    documentView.read(file);
                    return null;
                }
                catch (Throwable e) {
                    return e;
                }
            }

            public void finished(Object value) {
                OpenAction.this.fileOpened(documentView, file, value);
            }
        });
    }

    protected void fileOpened(DocumentView documentView, File file, Object value) {
        DocumentOrientedApplication application = this.getApplication();
        if (value == null) {
            documentView.setFile(file);
            documentView.setEnabled(true);
            Frame w = (Frame)SwingUtilities.getWindowAncestor(documentView.getComponent());
            if (w != null) {
                w.setExtendedState(w.getExtendedState() & 0xFFFFFFFE);
                w.toFront();
            }
            documentView.getComponent().requestFocus();
            application.addRecentFile(file);
            application.setEnabled(true);
        } else {
            if (value instanceof Throwable) {
                ((Throwable)value).printStackTrace();
            }
            JSheet.showMessageSheet(documentView.getComponent(), "<html>" + UIManager.getString("OptionPane.css") + "<b>Couldn't open the file \"" + file + "\".</b><br>" + value, 0, new SheetListener(){

                public void optionSelected(SheetEvent evt) {
                }
            });
        }
    }
}

