/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CreationTool;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageHolderFigure;
import org.jhotdraw.gui.Worker;

public class ImageTool
extends CreationTool {
    JFileChooser fileChooser;

    public ImageTool(ImageHolderFigure prototype) {
        super(prototype);
    }

    public ImageTool(ImageHolderFigure prototype, Map attributes) {
        super(prototype, (Map<AttributeKey, Object>)attributes);
    }

    public void creationFinished(final Figure createdFigure) {
        if (this.getFileChooser().showOpenDialog(this.getView().getComponent()) == 0) {
            final File file = this.getFileChooser().getSelectedFile();
            new Worker(){

                public Object construct() {
                    try {
                        ((ImageHolderFigure)createdFigure).loadImage(file);
                    }
                    catch (Throwable t) {
                        return t;
                    }
                    return null;
                }

                public void finished(Object value) {
                    BufferedImage img;
                    if (value instanceof Throwable) {
                        Throwable t = (Throwable)value;
                        t.printStackTrace();
                        JOptionPane.showConfirmDialog(ImageTool.this.getView().getComponent(), t.getMessage(), null, 0);
                    }
                    if ((img = ((ImageHolderFigure)createdFigure).getBufferedImage()) != null) {
                        Point2D.Double p1 = createdFigure.getStartPoint();
                        Point2D.Double p2 = new Point2D.Double(p1.x + (double)img.getWidth(), p1.y + (double)img.getHeight());
                        createdFigure.willChange();
                        createdFigure.setBounds(p1, p2);
                        createdFigure.changed();
                    }
                    ImageTool.this.fireToolDone();
                }
            }.start();
        } else {
            this.fireToolDone();
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        return this.fileChooser;
    }
}

