/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.jhotdraw.draw.ChopRectangleConnector;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

public class StickyRectangleConnector
extends ChopRectangleConnector {
    private float angle;

    public StickyRectangleConnector() {
    }

    public StickyRectangleConnector(Figure owner) {
        super(owner);
    }

    public void draw(Graphics2D g) {
        g.setColor(Color.blue);
        g.setStroke(new BasicStroke());
        g.draw(this.getBounds());
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public StickyRectangleConnector(Figure owner, Point2D.Double p) {
        super(owner);
        this.angle = (float)Geom.pointToAngle(owner.getBounds(), p);
    }

    public void updateAnchor(Point2D.Double p) {
        this.angle = (float)Geom.pointToAngle(this.getOwner().getBounds(), p);
    }

    public Point2D.Double getAnchor() {
        return Geom.angleToPoint(this.getOwner().getBounds(), (double)this.angle);
    }

    protected Point2D.Double chop(Figure target, Point2D.Double from) {
        return Geom.angleToPoint(target.getBounds(), (double)this.angle);
    }

    public String getParameters() {
        return Float.toString((float)((double)this.angle / Math.PI * 180.0));
    }

    public void read(DOMInput in) throws IOException {
        super.read(in);
        this.angle = (float)in.getAttribute("angle", 0.0);
    }

    public void write(DOMOutput out) throws IOException {
        super.write(out);
        out.addAttribute("angle", this.angle);
    }
}

