/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGRectRadiusHandle
extends AbstractHandle {
    private static final boolean DEBUG = false;
    private static final int OFFSET = 6;
    private Dimension2DDouble originalArc2D;
    CompositeEdit edit;

    public SVGRectRadiusHandle(Figure owner) {
        super(owner);
    }

    public void draw(Graphics2D g) {
        this.drawDiamond(g, Color.yellow, Color.black);
    }

    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.locate());
        r.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return r;
    }

    private Point locate() {
        SVGRectFigure owner = (SVGRectFigure)this.getOwner();
        Rectangle2D.Double r = owner.getBounds();
        Point2D.Double p = new Point2D.Double(r.x + owner.getArcWidth(), r.y + owner.getArcHeight());
        if (AttributeKeys.TRANSFORM.get(owner) != null) {
            AttributeKeys.TRANSFORM.get(owner).transform(p, p);
        }
        return this.view.drawingToView(p);
    }

    public void trackStart(Point anchor, int modifiersEx) {
        SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        this.originalArc2D = svgRect.getArc();
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        int dx = lead.x - anchor.x;
        int dy = lead.y - anchor.y;
        SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        svgRect.willChange();
        Point2D.Double p = this.view.viewToDrawing(lead);
        if (AttributeKeys.TRANSFORM.get(svgRect) != null) {
            try {
                AttributeKeys.TRANSFORM.get(svgRect).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException ex) {
                // empty catch block
            }
        }
        Rectangle2D.Double r = svgRect.getBounds();
        svgRect.setArc(p.x - r.x, p.y - r.y);
        svgRect.changed();
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        final SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        final Dimension2DDouble oldValue = this.originalArc2D;
        final Dimension2DDouble newValue = svgRect.getArc();
        this.view.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.samples.svg.Labels");
                return labels.getString("arc");
            }

            public void undo() throws CannotUndoException {
                super.undo();
                svgRect.willChange();
                svgRect.setArc(oldValue);
                svgRect.changed();
            }

            public void redo() throws CannotRedoException {
                super.redo();
                svgRect.willChange();
                svgRect.setArc(newValue);
                svgRect.changed();
            }
        });
    }

    public String getToolTipText(Point p) {
        return ResourceBundleUtil.getLAFBundle("org.jhotdraw.draw.Labels").getString("roundRectangleRadiusHandle.tip");
    }
}

