/*
 * Decompiled with CFR 0.152.
 */
package ome.formats.model;

import java.util.LinkedHashMap;
import java.util.List;
import ome.formats.Index;
import ome.formats.model.IObjectContainerStore;
import ome.formats.model.ModelException;
import ome.formats.model.ModelProcessor;
import ome.util.LSID;
import omero.metadatastore.IObjectContainer;
import omero.model.Arc;
import omero.model.Detector;
import omero.model.Filament;
import omero.model.Instrument;
import omero.model.Laser;
import omero.model.OTF;
import omero.model.Objective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentProcessor
implements ModelProcessor {
    private Logger log = LoggerFactory.getLogger(InstrumentProcessor.class);

    @Override
    public void process(IObjectContainerStore store) throws ModelException {
        List<IObjectContainer> containers = store.getIObjectContainers(Detector.class);
        containers.addAll(store.getIObjectContainers(Objective.class));
        containers.addAll(store.getIObjectContainers(OTF.class));
        containers.addAll(store.getIObjectContainers(Arc.class));
        containers.addAll(store.getIObjectContainers(Laser.class));
        containers.addAll(store.getIObjectContainers(Filament.class));
        for (IObjectContainer container : containers) {
            Integer instrumentIndex = container.indexes.get(Index.INSTRUMENT_INDEX.getValue());
            Instrument instrument = (Instrument)store.getSourceObject(new LSID(Instrument.class, new int[]{instrumentIndex}));
            if (instrument != null) continue;
            LinkedHashMap<Index, Integer> indexes = new LinkedHashMap<Index, Integer>();
            indexes.put(Index.INSTRUMENT_INDEX, instrumentIndex);
            container = store.getIObjectContainer(Instrument.class, indexes);
            instrument = (Instrument)container.sourceObject;
        }
    }
}

