/*
 * Decompiled with CFR 0.152.
 */
package ome.services;

import java.io.File;
import java.util.List;
import ome.io.nio.AbstractFileSystemService;
import ome.io.nio.FilePathResolver;
import ome.model.core.Pixels;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroFilePathResolver
implements FilePathResolver {
    private static Logger log = LoggerFactory.getLogger(OmeroFilePathResolver.class);
    protected final SqlAction sql;
    protected final String omeroDataDir;

    public OmeroFilePathResolver(SqlAction sql, String omeroDataDir) {
        this.sql = sql;
        this.omeroDataDir = omeroDataDir;
    }

    public String getOriginalFilePath(AbstractFileSystemService service, Pixels pixels) {
        List namePathRepo = this.sql.getPixelsNamePathRepo(pixels.getId().longValue());
        String name = (String)namePathRepo.get(0);
        String path = (String)namePathRepo.get(1);
        String repo = (String)namePathRepo.get(2);
        if (name != null && path != null) {
            File f = new File(repo == null ? this.omeroDataDir : this.sql.findRepoRootPath(repo));
            f = new File(f, (String)namePathRepo.get(1));
            f = new File(f, (String)namePathRepo.get(0));
            String originalFilePath = f.getAbsolutePath();
            log.info("Metadata only file, resulting path: " + originalFilePath);
            return originalFilePath;
        }
        return null;
    }
}

