/*
 * Decompiled with CFR 0.152.
 */
package ome.model.annotations;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.annotations.Annotation;
import ome.util.DetailsFieldBridge;
import ome.util.Filter;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;

@Entity
@DiscriminatorValue(value="/basic/")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public abstract class BasicAnnotation
extends Annotation
implements Serializable,
IObject,
IMutable {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "basicannotation_owner_filter";
    public static final String GROUP_FILTER = "basicannotation_group_filter";
    public static final String EVENT_FILTER = "basicannotation_event_filter";
    public static final String PERMS_FILTER = "basicannotation_perms_filter";
    public static final Set<String> FIELDS;

    public BasicAnnotation() {
        this(null, true);
    }

    protected BasicAnnotation(Long id) {
        this(id, true);
    }

    public BasicAnnotation(Long id, boolean loaded) {
        super(id, loaded);
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    @Override
    public boolean acceptFilter(Filter __filter) {
        try {
            return super.acceptFilter(__filter);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        return super.retrieve(field);
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        super.putAt(field, value);
    }

    @Override
    public void unload() {
        this._loaded = false;
        super.unload();
    }

    @Override
    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet raw = new HashSet();
        FIELDS = Collections.unmodifiableSet(raw);
    }
}

